/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.event;

import com.mongodb.assertions.Assertions;
import com.mongodb.event.ConnectionCheckOutFailedEvent;
import com.mongodb.event.ConnectionCheckOutStartedEvent;
import com.mongodb.event.ConnectionCheckedInEvent;
import com.mongodb.event.ConnectionCheckedOutEvent;
import com.mongodb.event.ConnectionClosedEvent;
import com.mongodb.event.ConnectionCreatedEvent;
import com.mongodb.event.ConnectionPoolClearedEvent;
import com.mongodb.event.ConnectionPoolClosedEvent;
import com.mongodb.event.ConnectionPoolCreatedEvent;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.event.ConnectionPoolReadyEvent;
import com.mongodb.event.ConnectionReadyEvent;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import java.util.ArrayList;
import java.util.List;

final class ConnectionPoolListenerMulticaster
implements ConnectionPoolListener {
    private static final Logger LOGGER = Loggers.getLogger("protocol.event");
    private final List<ConnectionPoolListener> connectionPoolListeners;

    ConnectionPoolListenerMulticaster(List<ConnectionPoolListener> list) {
        Assertions.isTrue("All ConnectionPoolListener instances are non-null", !list.contains(null));
        this.connectionPoolListeners = new ArrayList<ConnectionPoolListener>(list);
    }

    @Override
    public void connectionPoolCreated(ConnectionPoolCreatedEvent connectionPoolCreatedEvent) {
        for (ConnectionPoolListener connectionPoolListener : this.connectionPoolListeners) {
            try {
                connectionPoolListener.connectionPoolCreated(connectionPoolCreatedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool created event to listener %s", connectionPoolListener), exception);
            }
        }
    }

    @Override
    public void connectionPoolCleared(ConnectionPoolClearedEvent connectionPoolClearedEvent) {
        for (ConnectionPoolListener connectionPoolListener : this.connectionPoolListeners) {
            try {
                connectionPoolListener.connectionPoolCleared(connectionPoolClearedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool cleared event to listener %s", connectionPoolListener), exception);
            }
        }
    }

    @Override
    public void connectionPoolReady(ConnectionPoolReadyEvent connectionPoolReadyEvent) {
        for (ConnectionPoolListener connectionPoolListener : this.connectionPoolListeners) {
            try {
                connectionPoolListener.connectionPoolReady(connectionPoolReadyEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool ready event to listener %s", connectionPoolListener), exception);
            }
        }
    }

    @Override
    public void connectionPoolClosed(ConnectionPoolClosedEvent connectionPoolClosedEvent) {
        for (ConnectionPoolListener connectionPoolListener : this.connectionPoolListeners) {
            try {
                connectionPoolListener.connectionPoolClosed(connectionPoolClosedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool closed event to listener %s", connectionPoolListener), exception);
            }
        }
    }

    @Override
    public void connectionCheckOutStarted(ConnectionCheckOutStartedEvent connectionCheckOutStartedEvent) {
        for (ConnectionPoolListener connectionPoolListener : this.connectionPoolListeners) {
            try {
                connectionPoolListener.connectionCheckOutStarted(connectionCheckOutStartedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection check out started event to listener %s", connectionPoolListener), exception);
            }
        }
    }

    @Override
    public void connectionCheckedOut(ConnectionCheckedOutEvent connectionCheckedOutEvent) {
        for (ConnectionPoolListener connectionPoolListener : this.connectionPoolListeners) {
            try {
                connectionPoolListener.connectionCheckedOut(connectionCheckedOutEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool checked out event to listener %s", connectionPoolListener), exception);
            }
        }
    }

    @Override
    public void connectionCheckOutFailed(ConnectionCheckOutFailedEvent connectionCheckOutFailedEvent) {
        for (ConnectionPoolListener connectionPoolListener : this.connectionPoolListeners) {
            try {
                connectionPoolListener.connectionCheckOutFailed(connectionCheckOutFailedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool check out failed event to listener %s", connectionPoolListener), exception);
            }
        }
    }

    @Override
    public void connectionCheckedIn(ConnectionCheckedInEvent connectionCheckedInEvent) {
        for (ConnectionPoolListener connectionPoolListener : this.connectionPoolListeners) {
            try {
                connectionPoolListener.connectionCheckedIn(connectionCheckedInEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool checked in event to listener %s", connectionPoolListener), exception);
            }
        }
    }

    @Override
    public void connectionCreated(ConnectionCreatedEvent connectionCreatedEvent) {
        for (ConnectionPoolListener connectionPoolListener : this.connectionPoolListeners) {
            try {
                connectionPoolListener.connectionCreated(connectionCreatedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool connection created event to listener %s", connectionPoolListener), exception);
            }
        }
    }

    @Override
    public void connectionReady(ConnectionReadyEvent connectionReadyEvent) {
        for (ConnectionPoolListener connectionPoolListener : this.connectionPoolListeners) {
            try {
                connectionPoolListener.connectionReady(connectionReadyEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool connection ready event to listener %s", connectionPoolListener), exception);
            }
        }
    }

    @Override
    public void connectionClosed(ConnectionClosedEvent connectionClosedEvent) {
        for (ConnectionPoolListener connectionPoolListener : this.connectionPoolListeners) {
            try {
                connectionPoolListener.connectionClosed(connectionClosedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising connection pool connection removed event to listener %s", connectionPoolListener), exception);
            }
        }
    }
}

