/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.event;

import com.mongodb.assertions.Assertions;
import com.mongodb.event.ServerClosedEvent;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerOpeningEvent;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import java.util.ArrayList;
import java.util.List;

final class ServerListenerMulticaster
implements ServerListener {
    private static final Logger LOGGER = Loggers.getLogger("cluster.event");
    private final List<ServerListener> serverListeners;

    ServerListenerMulticaster(List<ServerListener> list) {
        Assertions.isTrue("All ServerListener instances are non-null", !list.contains(null));
        this.serverListeners = new ArrayList<ServerListener>(list);
    }

    @Override
    public void serverOpening(ServerOpeningEvent serverOpeningEvent) {
        for (ServerListener serverListener : this.serverListeners) {
            try {
                serverListener.serverOpening(serverOpeningEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server opening event to listener %s", serverListener), exception);
            }
        }
    }

    @Override
    public void serverClosed(ServerClosedEvent serverClosedEvent) {
        for (ServerListener serverListener : this.serverListeners) {
            try {
                serverListener.serverClosed(serverClosedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server opening event to listener %s", serverListener), exception);
            }
        }
    }

    @Override
    public void serverDescriptionChanged(ServerDescriptionChangedEvent serverDescriptionChangedEvent) {
        for (ServerListener serverListener : this.serverListeners) {
            try {
                serverListener.serverDescriptionChanged(serverDescriptionChangedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server description changed event to listener %s", serverListener), exception);
            }
        }
    }
}

