/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.event;

import com.mongodb.assertions.Assertions;
import com.mongodb.event.ServerHeartbeatFailedEvent;
import com.mongodb.event.ServerHeartbeatStartedEvent;
import com.mongodb.event.ServerHeartbeatSucceededEvent;
import com.mongodb.event.ServerMonitorListener;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import java.util.ArrayList;
import java.util.List;

final class ServerMonitorListenerMulticaster
implements ServerMonitorListener {
    private static final Logger LOGGER = Loggers.getLogger("cluster.event");
    private final List<ServerMonitorListener> serverMonitorListeners;

    ServerMonitorListenerMulticaster(List<ServerMonitorListener> list) {
        Assertions.isTrue("All ServerMonitorListener instances are non-null", !list.contains(null));
        this.serverMonitorListeners = new ArrayList<ServerMonitorListener>(list);
    }

    @Override
    public void serverHearbeatStarted(ServerHeartbeatStartedEvent serverHeartbeatStartedEvent) {
        for (ServerMonitorListener serverMonitorListener : this.serverMonitorListeners) {
            try {
                serverMonitorListener.serverHearbeatStarted(serverHeartbeatStartedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server heartbeat started event to listener %s", serverMonitorListener), exception);
            }
        }
    }

    @Override
    public void serverHeartbeatSucceeded(ServerHeartbeatSucceededEvent serverHeartbeatSucceededEvent) {
        for (ServerMonitorListener serverMonitorListener : this.serverMonitorListeners) {
            try {
                serverMonitorListener.serverHeartbeatSucceeded(serverHeartbeatSucceededEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server heartbeat succeeded event to listener %s", serverMonitorListener), exception);
            }
        }
    }

    @Override
    public void serverHeartbeatFailed(ServerHeartbeatFailedEvent serverHeartbeatFailedEvent) {
        for (ServerMonitorListener serverMonitorListener : this.serverMonitorListeners) {
            try {
                serverMonitorListener.serverHeartbeatFailed(serverHeartbeatFailedEvent);
            }
            catch (Exception exception) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server heartbeat failed event to listener %s", serverMonitorListener), exception);
            }
        }
    }
}

