/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.inject;

import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.inject.Provider;
import com.mongodb.lang.Nullable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public final class SameObjectProvider<T>
implements Provider<T> {
    private final AtomicReference<T> object = new AtomicReference();

    private SameObjectProvider(@Nullable T t) {
        if (t != null) {
            this.initialize(t);
        }
    }

    @Override
    public T get() {
        return Assertions.assertNotNull(this.object.get());
    }

    @Override
    public Optional<T> optional() {
        return Optional.of(this.get());
    }

    public void initialize(T t) {
        Assertions.assertTrue(this.object.compareAndSet(null, t));
    }

    public static <T> SameObjectProvider<T> initialized(T t) {
        return new SameObjectProvider<T>(t);
    }

    public static <T> SameObjectProvider<T> uninitialized() {
        return new SameObjectProvider<Object>(null);
    }
}

