/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.logging;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterId;
import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class LogMessage {
    private final Component component;
    private final Level level;
    private final String messageId;
    private final ClusterId clusterId;
    private final Throwable exception;
    private final Collection<Entry> entries;
    private final String format;

    public LogMessage(Component component, Level level, String string, ClusterId clusterId, List<Entry> list, String string2) {
        this(component, level, string, clusterId, null, list, string2);
    }

    public LogMessage(Component component, Level level, String string, ClusterId clusterId, @Nullable Throwable throwable, Collection<Entry> collection, String string2) {
        this.component = component;
        this.level = level;
        this.messageId = string;
        this.clusterId = clusterId;
        this.exception = throwable;
        this.entries = collection;
        this.format = string2;
    }

    public ClusterId getClusterId() {
        return this.clusterId;
    }

    public Component getComponent() {
        return this.component;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessageId() {
        return this.messageId;
    }

    @Nullable
    public Throwable getException() {
        return this.exception;
    }

    public Collection<Entry> getEntries() {
        return this.entries;
    }

    public StructuredLogMessage toStructuredLogMessage() {
        List list = this.entries.stream().filter(entry -> entry.getValue() != null).collect(Collectors.toList());
        return new StructuredLogMessage(list);
    }

    public UnstructuredLogMessage toUnstructuredLogMessage() {
        return new UnstructuredLogMessage();
    }

    public static enum Component {
        COMMAND("command"),
        CONNECTION("connection"),
        SERVER_SELECTION("serverSelection");

        private static final Map<String, Component> INDEX;
        private final String value;

        private Component(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public static Component of(String string) {
            Component component = INDEX.get(string);
            return Assertions.assertNotNull(component);
        }

        static {
            INDEX = Stream.of(Component.values()).collect(Collectors.toMap(Component::getValue, Function.identity()));
        }
    }

    public static enum Level {
        INFO,
        DEBUG;

    }

    public static final class StructuredLogMessage {
        private final Collection<Entry> entries;

        private StructuredLogMessage(Collection<Entry> collection) {
            collection.forEach(entry -> Assertions.assertNotNull(entry.getValue()));
            this.entries = collection;
        }

        public Collection<Entry> getEntries() {
            return this.entries;
        }
    }

    public final class UnstructuredLogMessage {
        public String interpolate() {
            Iterator iterator = LogMessage.this.entries.iterator();
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (int i = 0; i < LogMessage.this.format.length(); ++i) {
                char c = LogMessage.this.format.charAt(i);
                if (c == '[' || c == '{') {
                    Object object = ((Entry)iterator.next()).getValue();
                    stringBuilder.append(LogMessage.this.format, n, i);
                    if (c == '{') {
                        stringBuilder.append(object);
                    } else if (object == null) {
                        i = LogMessage.this.format.indexOf(93, i);
                    } else {
                        int n2 = LogMessage.this.format.indexOf(123, i);
                        stringBuilder.append(LogMessage.this.format, i + 1, n2);
                        stringBuilder.append(object);
                        i = n2 + 1;
                    }
                    n = i + 1;
                    continue;
                }
                if (c != ']' && c != '}') continue;
                if (c == ']') {
                    stringBuilder.append(LogMessage.this.format, n, i);
                }
                n = i + 1;
            }
            stringBuilder.append(LogMessage.this.format, n, LogMessage.this.format.length());
            return stringBuilder.toString();
        }
    }

    public static final class Entry {
        private final Name name;
        private final Object value;

        public Entry(Name name, @Nullable Object object) {
            this.name = name;
            this.value = object;
        }

        public String getName() {
            return this.name.getValue();
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public static enum Name {
            SERVER_HOST("serverHost"),
            SERVER_PORT("serverPort"),
            COMMAND_NAME("commandName"),
            REQUEST_ID("requestId"),
            OPERATION_ID("operationId"),
            OPERATION("operation"),
            SERVICE_ID("serviceId"),
            SERVER_CONNECTION_ID("serverConnectionId"),
            DRIVER_CONNECTION_ID("driverConnectionId"),
            DURATION_MS("durationMS"),
            DATABASE_NAME("databaseName"),
            REPLY("reply"),
            COMMAND_CONTENT("command"),
            REASON_DESCRIPTION("reason"),
            ERROR_DESCRIPTION("error"),
            FAILURE("failure"),
            MAX_IDLE_TIME_MS("maxIdleTimeMS"),
            MIN_POOL_SIZE("minPoolSize"),
            MAX_POOL_SIZE("maxPoolSize"),
            MAX_CONNECTING("maxConnecting"),
            WAIT_QUEUE_TIMEOUT_MS("waitQueueTimeoutMS"),
            SELECTOR("selector"),
            TOPOLOGY_DESCRIPTION("topologyDescription"),
            REMAINING_TIME_MS("remainingTimeMS");

            private final String value;

            public String getValue() {
                return this.value;
            }

            private Name(String string2) {
                this.value = string2;
            }
        }
    }
}

