/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.logging;

import com.mongodb.connection.ClusterId;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.logging.LogMessage;
import com.mongodb.internal.logging.LoggingInterceptor;
import com.mongodb.lang.Nullable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class StructuredLogger {
    private static final ConcurrentHashMap<String, LoggingInterceptor> INTERCEPTORS = new ConcurrentHashMap();
    private final Logger logger;

    public static void addInterceptor(String string, LoggingInterceptor loggingInterceptor) {
        INTERCEPTORS.put(string, loggingInterceptor);
    }

    public static void removeInterceptor(String string) {
        INTERCEPTORS.remove(string);
    }

    @Nullable
    private static LoggingInterceptor getInterceptor(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return INTERCEPTORS.get(string);
    }

    public StructuredLogger(String string) {
        this(Loggers.getLogger(string));
    }

    public StructuredLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isRequired(LogMessage.Level level, ClusterId clusterId) {
        if (StructuredLogger.getInterceptor(clusterId.getDescription()) != null) {
            return true;
        }
        switch (level) {
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
        }
        throw new UnsupportedOperationException();
    }

    public void log(LogMessage logMessage) {
        LoggingInterceptor loggingInterceptor = StructuredLogger.getInterceptor(logMessage.getClusterId().getDescription());
        if (loggingInterceptor != null) {
            loggingInterceptor.intercept(logMessage);
        }
        switch (logMessage.getLevel()) {
            case DEBUG: {
                StructuredLogger.logUnstructured(logMessage, this.logger::isDebugEnabled, this.logger::debug, this.logger::debug);
                break;
            }
            case INFO: {
                StructuredLogger.logUnstructured(logMessage, this.logger::isInfoEnabled, this.logger::info, this.logger::info);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void logUnstructured(LogMessage logMessage, Supplier<Boolean> supplier, Consumer<String> consumer, BiConsumer<String, Throwable> biConsumer) {
        if (supplier.get().booleanValue()) {
            LogMessage.UnstructuredLogMessage unstructuredLogMessage = logMessage.toUnstructuredLogMessage();
            String string = unstructuredLogMessage.interpolate();
            Throwable throwable = logMessage.getException();
            if (throwable == null) {
                consumer.accept(string);
            } else {
                biConsumer.accept(string, throwable);
            }
        }
    }
}

