/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.Function;
import com.mongodb.WriteConcern;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.TransactionOperation;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;

public class AbortTransactionOperation
extends TransactionOperation {
    private BsonDocument recoveryToken;

    public AbortTransactionOperation(WriteConcern writeConcern) {
        super(writeConcern);
    }

    public AbortTransactionOperation recoveryToken(@Nullable BsonDocument bsonDocument) {
        this.recoveryToken = bsonDocument;
        return this;
    }

    @Override
    protected String getCommandName() {
        return "abortTransaction";
    }

    @Override
    CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            operationContext.getTimeoutContext().resetToDefaultMaxTime();
            BsonDocument bsonDocument = AbortTransactionOperation.super.getCommandCreator().create(operationContext, serverDescription, connectionDescription);
            DocumentHelper.putIfNotNull(bsonDocument, "recoveryToken", this.recoveryToken);
            return bsonDocument;
        };
    }

    @Override
    protected Function<BsonDocument, BsonDocument> getRetryCommandModifier(TimeoutContext timeoutContext) {
        return bsonDocument -> bsonDocument;
    }
}

