/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;

abstract class AbstractWriteSearchIndexOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;

    AbstractWriteSearchIndexOperation(MongoNamespace mongoNamespace) {
        this.namespace = mongoNamespace;
    }

    @Override
    public Void execute(WriteBinding writeBinding) {
        return SyncOperationHelper.withConnection(writeBinding, connection -> {
            try {
                SyncOperationHelper.executeCommand(writeBinding, this.namespace.getDatabaseName(), this.buildCommand(), connection, SyncOperationHelper.writeConcernErrorTransformer(writeBinding.getOperationContext().getTimeoutContext()));
            }
            catch (MongoCommandException mongoCommandException) {
                this.swallowOrThrow(mongoCommandException);
            }
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<Void> singleResultCallback) {
        AsyncOperationHelper.withAsyncSourceAndConnection(asyncWriteBinding::getWriteConnectionSource, false, singleResultCallback, (asyncConnectionSource, asyncConnection, singleResultCallback2) -> AsyncOperationHelper.executeCommandAsync(asyncWriteBinding, this.namespace.getDatabaseName(), this.buildCommand(), asyncConnection, AsyncOperationHelper.writeConcernErrorTransformerAsync(asyncWriteBinding.getOperationContext().getTimeoutContext()), (void_, throwable) -> {
            try {
                this.swallowOrThrow(throwable);
                singleResultCallback.onResult((Void)void_, null);
            }
            catch (Throwable throwable2) {
                singleResultCallback.onResult(null, throwable2);
            }
        }));
    }

    <E extends Throwable> void swallowOrThrow(@Nullable E e) throws E {
        if (e != null) {
            throw e;
        }
    }

    abstract BsonDocument buildCommand();

    MongoNamespace getNamespace() {
        return this.namespace;
    }
}

