/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.operation.AggregateOperationImpl;
import com.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.ExplainHelper;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

public class AggregateOperation<T>
implements AsyncExplainableReadOperation<AsyncBatchCursor<T>>,
ExplainableReadOperation<BatchCursor<T>> {
    private final AggregateOperationImpl<T> wrapped;

    public AggregateOperation(MongoNamespace mongoNamespace, List<BsonDocument> list, Decoder<T> decoder) {
        this(mongoNamespace, list, decoder, AggregationLevel.COLLECTION);
    }

    public AggregateOperation(MongoNamespace mongoNamespace, List<BsonDocument> list, Decoder<T> decoder, AggregationLevel aggregationLevel) {
        this.wrapped = new AggregateOperationImpl<T>(mongoNamespace, list, decoder, aggregationLevel);
    }

    public List<BsonDocument> getPipeline() {
        return this.wrapped.getPipeline();
    }

    public Boolean getAllowDiskUse() {
        return this.wrapped.getAllowDiskUse();
    }

    public AggregateOperation<T> allowDiskUse(@Nullable Boolean bl) {
        this.wrapped.allowDiskUse(bl);
        return this;
    }

    public Integer getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    public AggregateOperation<T> batchSize(@Nullable Integer n) {
        this.wrapped.batchSize(n);
        return this;
    }

    public Collation getCollation() {
        return this.wrapped.getCollation();
    }

    public AggregateOperation<T> collation(@Nullable Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.wrapped.getComment();
    }

    public AggregateOperation<T> comment(@Nullable BsonValue bsonValue) {
        this.wrapped.comment(bsonValue);
        return this;
    }

    public AggregateOperation<T> let(@Nullable BsonDocument bsonDocument) {
        this.wrapped.let(bsonDocument);
        return this;
    }

    public AggregateOperation<T> retryReads(boolean bl) {
        this.wrapped.retryReads(bl);
        return this;
    }

    public boolean getRetryReads() {
        return this.wrapped.getRetryReads();
    }

    @Nullable
    public BsonDocument getHint() {
        BsonValue bsonValue = this.wrapped.getHint();
        if (bsonValue == null) {
            return null;
        }
        if (!bsonValue.isDocument()) {
            throw new IllegalArgumentException("Hint is not a BsonDocument please use the #getHintBsonValue() method. ");
        }
        return bsonValue.asDocument();
    }

    @Nullable
    public BsonValue getHintBsonValue() {
        return this.wrapped.getHint();
    }

    public AggregateOperation<T> hint(@Nullable BsonValue bsonValue) {
        this.wrapped.hint(bsonValue);
        return this;
    }

    public AggregateOperation<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        this.wrapped.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding readBinding) {
        return this.wrapped.execute(readBinding);
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<AsyncBatchCursor<T>> singleResultCallback) {
        this.wrapped.executeAsync(asyncReadBinding, singleResultCallback);
    }

    @Override
    public <R> ReadOperation<R> asExplainableOperation(@Nullable ExplainVerbosity explainVerbosity, Decoder<R> decoder) {
        return this.createExplainableOperation(explainVerbosity, decoder);
    }

    @Override
    public <R> AsyncReadOperation<R> asAsyncExplainableOperation(@Nullable ExplainVerbosity explainVerbosity, Decoder<R> decoder) {
        return this.createExplainableOperation(explainVerbosity, decoder);
    }

    <R> CommandReadOperation<R> createExplainableOperation(@Nullable ExplainVerbosity explainVerbosity, Decoder<R> decoder) {
        return new CommandReadOperation<R>(this.getNamespace().getDatabaseName(), (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = this.wrapped.getCommand(operationContext, 0);
            CommandHelper.applyMaxTimeMS(operationContext.getTimeoutContext(), bsonDocument);
            return ExplainHelper.asExplainCommand(bsonDocument, explainVerbosity);
        }, decoder);
    }

    MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }
}

