/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.CursorType;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncCommandBatchCursor;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandBatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.OperationReadConcernHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

class AggregateOperationImpl<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String RESULT = "result";
    private static final String CURSOR = "cursor";
    private static final String FIRST_BATCH = "firstBatch";
    private static final List<String> FIELD_NAMES_WITH_RESULT = Arrays.asList("result", "firstBatch");
    private final MongoNamespace namespace;
    private final List<BsonDocument> pipeline;
    private final Decoder<T> decoder;
    private final AggregateTarget aggregateTarget;
    private final PipelineCreator pipelineCreator;
    private boolean retryReads;
    private Boolean allowDiskUse;
    private Integer batchSize;
    private Collation collation;
    private BsonValue comment;
    private BsonValue hint;
    private BsonDocument variables;
    private TimeoutMode timeoutMode;
    private CursorType cursorType;

    AggregateOperationImpl(MongoNamespace mongoNamespace, List<BsonDocument> list, Decoder<T> decoder, AggregationLevel aggregationLevel) {
        this(mongoNamespace, list, decoder, AggregateOperationImpl.defaultAggregateTarget(Assertions.notNull("aggregationLevel", aggregationLevel), Assertions.notNull("namespace", mongoNamespace).getCollectionName()), AggregateOperationImpl.defaultPipelineCreator(list));
    }

    AggregateOperationImpl(MongoNamespace mongoNamespace, List<BsonDocument> list, Decoder<T> decoder, AggregateTarget aggregateTarget, PipelineCreator pipelineCreator) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.pipeline = Assertions.notNull("pipeline", list);
        this.decoder = Assertions.notNull("decoder", decoder);
        this.aggregateTarget = Assertions.notNull("aggregateTarget", aggregateTarget);
        this.pipelineCreator = Assertions.notNull("pipelineCreator", pipelineCreator);
    }

    MongoNamespace getNamespace() {
        return this.namespace;
    }

    List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    Decoder<T> getDecoder() {
        return this.decoder;
    }

    Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    AggregateOperationImpl<T> allowDiskUse(@Nullable Boolean bl) {
        this.allowDiskUse = bl;
        return this;
    }

    Integer getBatchSize() {
        return this.batchSize;
    }

    AggregateOperationImpl<T> batchSize(@Nullable Integer n) {
        this.batchSize = n;
        return this;
    }

    Collation getCollation() {
        return this.collation;
    }

    AggregateOperationImpl<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    BsonValue getComment() {
        return this.comment;
    }

    AggregateOperationImpl<T> comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    AggregateOperationImpl<T> let(@Nullable BsonDocument bsonDocument) {
        this.variables = bsonDocument;
        return this;
    }

    AggregateOperationImpl<T> retryReads(boolean bl) {
        this.retryReads = bl;
        return this;
    }

    AggregateOperationImpl<T> cursorType(CursorType cursorType) {
        this.cursorType = cursorType;
        return this;
    }

    boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    BsonValue getHint() {
        return this.hint;
    }

    public AggregateOperationImpl<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        if (timeoutMode != null) {
            this.timeoutMode = timeoutMode;
        }
        return this;
    }

    AggregateOperationImpl<T> hint(@Nullable BsonValue bsonValue) {
        Assertions.isTrueArgument("BsonString or BsonDocument", bsonValue == null || bsonValue.isDocument() || bsonValue.isString());
        this.hint = bsonValue;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding readBinding) {
        return SyncOperationHelper.executeRetryableRead(readBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, FIELD_NAMES_WITH_RESULT), this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<AsyncBatchCursor<T>> singleResultCallback) {
        SingleResultCallback<AsyncBatchCursor<T>> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER);
        AsyncOperationHelper.executeRetryableReadAsync(asyncReadBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, FIELD_NAMES_WITH_RESULT), this.asyncTransformer(), this.retryReads, singleResultCallback2);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> this.getCommand(operationContext, connectionDescription.getMaxWireVersion());
    }

    BsonDocument getCommand(OperationContext operationContext, int n) {
        BsonDocument bsonDocument = new BsonDocument("aggregate", this.aggregateTarget.create());
        OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), n, bsonDocument);
        bsonDocument.put("pipeline", this.pipelineCreator.create());
        OperationHelper.setNonTailableCursorMaxTimeSupplier(this.timeoutMode, operationContext);
        BsonDocument bsonDocument2 = new BsonDocument();
        if (this.batchSize != null) {
            bsonDocument2.put("batchSize", new BsonInt32(this.batchSize));
        }
        bsonDocument.put(CURSOR, bsonDocument2);
        if (this.allowDiskUse != null) {
            bsonDocument.put("allowDiskUse", BsonBoolean.valueOf(this.allowDiskUse));
        }
        if (this.collation != null) {
            bsonDocument.put("collation", this.collation.asDocument());
        }
        if (this.comment != null) {
            bsonDocument.put("comment", this.comment);
        }
        if (this.hint != null) {
            bsonDocument.put("hint", this.hint);
        }
        if (this.variables != null) {
            bsonDocument.put("let", this.variables);
        }
        return bsonDocument;
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, CommandBatchCursor<T>> transformer() {
        return (bsonDocument, connectionSource, connection) -> new CommandBatchCursor<T>(this.getTimeoutMode(), (BsonDocument)bsonDocument, this.batchSize != null ? this.batchSize : 0, this.getMaxTimeForCursor(connectionSource.getOperationContext().getTimeoutContext()), this.decoder, this.comment, connectionSource, connection);
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (bsonDocument, asyncConnectionSource, asyncConnection) -> new AsyncCommandBatchCursor<T>(this.getTimeoutMode(), (BsonDocument)bsonDocument, this.batchSize != null ? this.batchSize : 0, this.getMaxTimeForCursor(asyncConnectionSource.getOperationContext().getTimeoutContext()), this.decoder, this.comment, asyncConnectionSource, asyncConnection);
    }

    private TimeoutMode getTimeoutMode() {
        TimeoutMode timeoutMode = this.timeoutMode;
        if (timeoutMode == null) {
            timeoutMode = TimeoutMode.CURSOR_LIFETIME;
        }
        return timeoutMode;
    }

    private long getMaxTimeForCursor(TimeoutContext timeoutContext) {
        long l = timeoutContext.getMaxAwaitTimeMS();
        if (timeoutContext.hasTimeoutMS()) {
            return CursorType.TailableAwait == this.cursorType ? l : 0L;
        }
        return l;
    }

    private static AggregateTarget defaultAggregateTarget(AggregationLevel aggregationLevel, String string) {
        return () -> {
            if (aggregationLevel == AggregationLevel.DATABASE) {
                return new BsonInt32(1);
            }
            return new BsonString(string);
        };
    }

    private static PipelineCreator defaultPipelineCreator(List<BsonDocument> list) {
        return () -> new BsonArray(list);
    }

    static interface AggregateTarget {
        public BsonValue create();
    }

    static interface PipelineCreator {
        public BsonArray create();
    }
}

