/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;

public class AggregateToCollectionOperation
implements AsyncReadOperation<Void>,
ReadOperation<Void> {
    private final MongoNamespace namespace;
    private final List<BsonDocument> pipeline;
    private final WriteConcern writeConcern;
    private final ReadConcern readConcern;
    private final AggregationLevel aggregationLevel;
    private Boolean allowDiskUse;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private BsonValue comment;
    private BsonValue hint;
    private BsonDocument variables;

    public AggregateToCollectionOperation(MongoNamespace mongoNamespace, List<BsonDocument> list, ReadConcern readConcern, WriteConcern writeConcern) {
        this(mongoNamespace, list, readConcern, writeConcern, AggregationLevel.COLLECTION);
    }

    public AggregateToCollectionOperation(MongoNamespace mongoNamespace, List<BsonDocument> list, @Nullable ReadConcern readConcern, @Nullable WriteConcern writeConcern, AggregationLevel aggregationLevel) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.pipeline = Assertions.notNull("pipeline", list);
        this.writeConcern = writeConcern;
        this.readConcern = readConcern;
        this.aggregationLevel = Assertions.notNull("aggregationLevel", aggregationLevel);
        Assertions.isTrueArgument("pipeline is not empty", !list.isEmpty());
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public AggregateToCollectionOperation allowDiskUse(@Nullable Boolean bl) {
        this.allowDiskUse = bl;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public AggregateToCollectionOperation bypassDocumentValidation(@Nullable Boolean bl) {
        this.bypassDocumentValidation = bl;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public AggregateToCollectionOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public AggregateToCollectionOperation let(@Nullable BsonDocument bsonDocument) {
        this.variables = bsonDocument;
        return this;
    }

    public AggregateToCollectionOperation comment(BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public AggregateToCollectionOperation hint(@Nullable BsonValue bsonValue) {
        this.hint = bsonValue;
        return this;
    }

    public AggregateToCollectionOperation timeoutMode(@Nullable TimeoutMode timeoutMode) {
        Assertions.isTrueArgument("timeoutMode cannot be ITERATION.", timeoutMode == null || timeoutMode.equals((Object)TimeoutMode.CURSOR_LIFETIME));
        return this;
    }

    @Override
    public Void execute(ReadBinding readBinding) {
        return SyncOperationHelper.executeRetryableRead(readBinding, () -> readBinding.getReadConnectionSource(12, ReadPreference.primary()), this.namespace.getDatabaseName(), this.getCommandCreator(), new BsonDocumentCodec(), (bsonDocument, connectionSource, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(bsonDocument, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion(), readBinding.getOperationContext().getTimeoutContext());
            return null;
        }, false);
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<Void> singleResultCallback2) {
        AsyncOperationHelper.executeRetryableReadAsync(asyncReadBinding, singleResultCallback -> asyncReadBinding.getReadConnectionSource(12, ReadPreference.primary(), singleResultCallback), this.namespace.getDatabaseName(), this.getCommandCreator(), new BsonDocumentCodec(), (bsonDocument, asyncConnectionSource, asyncConnection) -> {
            WriteConcernHelper.throwOnWriteConcernError(bsonDocument, asyncConnection.getDescription().getServerAddress(), asyncConnection.getDescription().getMaxWireVersion(), asyncReadBinding.getOperationContext().getTimeoutContext());
            return null;
        }, false, singleResultCallback2);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonValue bsonValue = this.aggregationLevel == AggregationLevel.DATABASE ? new BsonInt32(1) : new BsonString(this.namespace.getCollectionName());
            BsonDocument bsonDocument = new BsonDocument("aggregate", bsonValue);
            bsonDocument.put("pipeline", new BsonArray(this.pipeline));
            if (this.allowDiskUse != null) {
                bsonDocument.put("allowDiskUse", BsonBoolean.valueOf(this.allowDiskUse));
            }
            if (this.bypassDocumentValidation != null) {
                bsonDocument.put("bypassDocumentValidation", BsonBoolean.valueOf(this.bypassDocumentValidation));
            }
            bsonDocument.put("cursor", new BsonDocument());
            WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, bsonDocument);
            if (this.readConcern != null && !this.readConcern.isServerDefault()) {
                bsonDocument.put("readConcern", this.readConcern.asDocument());
            }
            if (this.collation != null) {
                bsonDocument.put("collation", this.collation.asDocument());
            }
            if (this.comment != null) {
                bsonDocument.put("comment", this.comment);
            }
            if (this.hint != null) {
                bsonDocument.put("hint", this.hint);
            }
            if (this.variables != null) {
                bsonDocument.put("let", this.variables);
            }
            return bsonDocument;
        };
    }
}

