/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoException;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.operation.AsyncCommandBatchCursor;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.ChangeStreamBatchCursor;
import com.mongodb.internal.operation.ChangeStreamBatchCursorHelper;
import com.mongodb.internal.operation.ChangeStreamOperation;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.RawBsonDocument;

final class AsyncChangeStreamBatchCursor<T>
implements AsyncAggregateResponseBatchCursor<T> {
    private final AsyncReadBinding binding;
    private final TimeoutContext timeoutContext;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private final int maxWireVersion;
    private volatile BsonDocument resumeToken;
    private final AtomicReference<AsyncCommandBatchCursor<RawBsonDocument>> wrapped;
    private final AtomicBoolean isClosed;

    AsyncChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, AsyncCommandBatchCursor<RawBsonDocument> asyncCommandBatchCursor, AsyncReadBinding asyncReadBinding, @Nullable BsonDocument bsonDocument, int n) {
        this.changeStreamOperation = changeStreamOperation;
        this.wrapped = new AtomicReference<AsyncCommandBatchCursor<RawBsonDocument>>(Assertions.assertNotNull(asyncCommandBatchCursor));
        this.binding = asyncReadBinding;
        asyncReadBinding.retain();
        this.timeoutContext = asyncReadBinding.getOperationContext().getTimeoutContext();
        this.resumeToken = bsonDocument;
        this.maxWireVersion = n;
        this.isClosed = new AtomicBoolean();
    }

    @NonNull
    AsyncCommandBatchCursor<RawBsonDocument> getWrapped() {
        return Assertions.assertNotNull(this.wrapped.get());
    }

    @Override
    public void next(SingleResultCallback<List<T>> singleResultCallback) {
        this.resumeableOperation(AsyncBatchCursor::next, singleResultCallback, false);
    }

    @Override
    public void close() {
        this.timeoutContext.resetTimeoutIfPresent();
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.nullifyAndCloseWrapped();
            }
            finally {
                this.binding.release();
            }
        }
    }

    @Override
    public void setBatchSize(int n) {
        this.getWrapped().setBatchSize(n);
    }

    @Override
    public int getBatchSize() {
        return this.getWrapped().getBatchSize();
    }

    @Override
    public boolean isClosed() {
        if (this.isClosed.get()) {
            return true;
        }
        if (this.wrappedClosedItself()) {
            this.close();
            return true;
        }
        return false;
    }

    private boolean wrappedClosedItself() {
        AsyncAggregateResponseBatchCursor asyncAggregateResponseBatchCursor = this.wrapped.get();
        return asyncAggregateResponseBatchCursor != null && asyncAggregateResponseBatchCursor.isClosed();
    }

    private void nullifyAndCloseWrapped() {
        AsyncAggregateResponseBatchCursor asyncAggregateResponseBatchCursor = this.wrapped.getAndSet(null);
        if (asyncAggregateResponseBatchCursor != null) {
            asyncAggregateResponseBatchCursor.close();
        }
    }

    private void setWrappedOrCloseIt(AsyncCommandBatchCursor<RawBsonDocument> asyncCommandBatchCursor) {
        if (this.isClosed()) {
            Assertions.assertNull(this.wrapped.get());
            asyncCommandBatchCursor.close();
        } else {
            Assertions.assertNull(this.wrapped.getAndSet(asyncCommandBatchCursor));
            if (this.isClosed()) {
                this.nullifyAndCloseWrapped();
            }
        }
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.getWrapped().getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.changeStreamOperation.getStartAtOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.getWrapped().isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void cachePostBatchResumeToken(AsyncCommandBatchCursor<RawBsonDocument> asyncCommandBatchCursor) {
        BsonDocument bsonDocument = asyncCommandBatchCursor.getPostBatchResumeToken();
        if (bsonDocument != null) {
            this.resumeToken = bsonDocument;
        }
    }

    private void resumeableOperation(AsyncBlock asyncBlock, SingleResultCallback<List<T>> singleResultCallback, boolean bl) {
        this.timeoutContext.resetTimeoutIfPresent();
        SingleResultCallback<List<Object>> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER);
        if (this.isClosed()) {
            singleResultCallback2.onResult(null, new MongoException(String.format("%s called after the cursor was closed.", bl ? "tryNext()" : "next()")));
            return;
        }
        AsyncCommandBatchCursor<RawBsonDocument> asyncCommandBatchCursor = this.getWrapped();
        asyncBlock.apply(asyncCommandBatchCursor, (list, throwable) -> {
            if (throwable == null) {
                try {
                    List<T> list2;
                    try {
                        list2 = ChangeStreamBatchCursor.convertAndProduceLastId(Assertions.assertNotNull(list), this.changeStreamOperation.getDecoder(), bsonDocument -> {
                            this.resumeToken = bsonDocument;
                        });
                    }
                    finally {
                        this.cachePostBatchResumeToken(asyncCommandBatchCursor);
                    }
                    singleResultCallback2.onResult(list2, null);
                }
                catch (Exception exception) {
                    singleResultCallback2.onResult(null, exception);
                }
            } else {
                this.cachePostBatchResumeToken(asyncCommandBatchCursor);
                if (ChangeStreamBatchCursorHelper.isResumableError(throwable, this.maxWireVersion)) {
                    this.nullifyAndCloseWrapped();
                    this.retryOperation(asyncBlock, singleResultCallback2, bl);
                } else {
                    singleResultCallback2.onResult(null, throwable);
                }
            }
        });
    }

    private void retryOperation(AsyncBlock asyncBlock, SingleResultCallback<List<T>> singleResultCallback, boolean bl) {
        AsyncOperationHelper.withAsyncReadConnectionSource(this.binding, (asyncConnectionSource, throwable2) -> {
            if (throwable2 != null) {
                singleResultCallback.onResult(null, throwable2);
            } else {
                this.changeStreamOperation.setChangeStreamOptionsForResume(this.resumeToken, Assertions.assertNotNull(asyncConnectionSource).getServerDescription().getMaxWireVersion());
                asyncConnectionSource.release();
                this.changeStreamOperation.executeAsync(this.binding, (asyncBatchCursor, throwable) -> {
                    if (throwable != null) {
                        singleResultCallback.onResult(null, throwable);
                    } else {
                        try {
                            this.setWrappedOrCloseIt(Assertions.assertNotNull((AsyncChangeStreamBatchCursor)asyncBatchCursor).getWrapped());
                        }
                        finally {
                            try {
                                this.binding.release();
                            }
                            finally {
                                this.resumeableOperation(asyncBlock, singleResultCallback, bl);
                            }
                        }
                    }
                });
            }
        });
    }

    private static interface AsyncBlock {
        public void apply(AsyncAggregateResponseBatchCursor<RawBsonDocument> var1, SingleResultCallback<List<RawBsonDocument>> var2);
    }
}

