/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.MongoSocketException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.CommandBatchCursorHelper;
import com.mongodb.internal.operation.CommandCursorResult;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.CursorResourceManager;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

class AsyncCommandBatchCursor<T>
implements AsyncAggregateResponseBatchCursor<T> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    @Nullable
    private final BsonValue comment;
    private final int maxWireVersion;
    private final boolean firstBatchEmpty;
    private final ResourceManager resourceManager;
    private final OperationContext operationContext;
    private final TimeoutMode timeoutMode;
    private final AtomicBoolean processedInitial = new AtomicBoolean();
    private int batchSize;
    private volatile CommandCursorResult<T> commandCursorResult;
    private boolean resetTimeoutWhenClosing;

    AsyncCommandBatchCursor(TimeoutMode timeoutMode, BsonDocument bsonDocument, int n, long l, Decoder<T> decoder, @Nullable BsonValue bsonValue, AsyncConnectionSource asyncConnectionSource, AsyncConnection asyncConnection) {
        ConnectionDescription connectionDescription = asyncConnection.getDescription();
        this.commandCursorResult = this.toCommandCursorResult(connectionDescription.getServerAddress(), "firstBatch", bsonDocument);
        this.namespace = this.commandCursorResult.getNamespace();
        this.batchSize = n;
        this.decoder = decoder;
        this.comment = bsonValue;
        this.maxWireVersion = connectionDescription.getMaxWireVersion();
        this.firstBatchEmpty = this.commandCursorResult.getResults().isEmpty();
        this.operationContext = asyncConnectionSource.getOperationContext();
        this.timeoutMode = timeoutMode;
        this.operationContext.getTimeoutContext().setMaxTimeOverride(l);
        AsyncConnection asyncConnection2 = asyncConnectionSource.getServerDescription().getType() == ServerType.LOAD_BALANCER ? asyncConnection : null;
        this.resourceManager = new ResourceManager(this.namespace, asyncConnectionSource, asyncConnection2, this.commandCursorResult.getServerCursor());
        this.resetTimeoutWhenClosing = true;
    }

    @Override
    public void next(SingleResultCallback<List<T>> singleResultCallback2) {
        this.resourceManager.execute(singleResultCallback -> {
            this.checkTimeoutModeAndResetTimeoutContextIfIteration();
            ServerCursor serverCursor = this.resourceManager.getServerCursor();
            boolean bl = serverCursor == null;
            List list = Collections.emptyList();
            if (!this.processedInitial.getAndSet(true) && !this.firstBatchEmpty) {
                list = this.commandCursorResult.getResults();
            }
            if (bl || !list.isEmpty()) {
                singleResultCallback.onResult(list, null);
            } else {
                this.getMore(serverCursor, singleResultCallback);
            }
        }, singleResultCallback2);
    }

    @Override
    public boolean isClosed() {
        return !this.resourceManager.operable();
    }

    @Override
    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void close() {
        this.resourceManager.close();
    }

    @Nullable
    ServerCursor getServerCursor() {
        if (!this.resourceManager.operable()) {
            return null;
        }
        return this.resourceManager.getServerCursor();
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.commandCursorResult.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.commandCursorResult.getOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.firstBatchEmpty;
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    void checkTimeoutModeAndResetTimeoutContextIfIteration() {
        if (this.timeoutMode == TimeoutMode.ITERATION) {
            this.operationContext.getTimeoutContext().resetTimeoutIfPresent();
        }
    }

    private void getMore(ServerCursor serverCursor, SingleResultCallback<List<T>> singleResultCallback2) {
        this.resourceManager.executeWithConnection((asyncConnection, singleResultCallback) -> this.getMoreLoop(Assertions.assertNotNull(asyncConnection), serverCursor, singleResultCallback), singleResultCallback2);
    }

    private void getMoreLoop(AsyncConnection asyncConnection, ServerCursor serverCursor, SingleResultCallback<List<T>> singleResultCallback) {
        asyncConnection.commandAsync(this.namespace.getDatabaseName(), CommandBatchCursorHelper.getMoreCommandDocument(serverCursor.getId(), asyncConnection.getDescription(), this.namespace, this.batchSize, this.comment), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), CommandResultDocumentCodec.create(this.decoder, "nextBatch"), Assertions.assertNotNull((AsyncConnectionSource)this.resourceManager.getConnectionSource()).getOperationContext(), (bsonDocument, throwable) -> {
            if (throwable != null) {
                Throwable throwable2 = throwable instanceof MongoCommandException ? CommandBatchCursorHelper.translateCommandException((MongoCommandException)throwable, serverCursor) : throwable;
                singleResultCallback.onResult(null, throwable2);
                return;
            }
            this.commandCursorResult = this.toCommandCursorResult(asyncConnection.getDescription().getServerAddress(), "nextBatch", Assertions.assertNotNull(bsonDocument));
            ServerCursor serverCursor2 = this.commandCursorResult.getServerCursor();
            this.resourceManager.setServerCursor(serverCursor2);
            List<T> list = this.commandCursorResult.getResults();
            if (serverCursor2 == null || !list.isEmpty()) {
                singleResultCallback.onResult(list, null);
                return;
            }
            if (!this.resourceManager.operable()) {
                singleResultCallback.onResult(Collections.emptyList(), null);
                return;
            }
            this.getMoreLoop(asyncConnection, serverCursor2, singleResultCallback);
        });
    }

    private CommandCursorResult<T> toCommandCursorResult(ServerAddress serverAddress, String string, BsonDocument bsonDocument) {
        CommandCursorResult commandCursorResult = new CommandCursorResult(serverAddress, string, bsonDocument);
        CommandBatchCursorHelper.logCommandCursorResult(commandCursorResult);
        return commandCursorResult;
    }

    AsyncCommandBatchCursor<T> disableTimeoutResetWhenClosing() {
        this.resetTimeoutWhenClosing = false;
        return this;
    }

    @ThreadSafe
    private final class ResourceManager
    extends CursorResourceManager<AsyncConnectionSource, AsyncConnection> {
        ResourceManager(MongoNamespace mongoNamespace, @Nullable AsyncConnectionSource asyncConnectionSource, @Nullable AsyncConnection asyncConnection, ServerCursor serverCursor) {
            super(mongoNamespace, asyncConnectionSource, asyncConnection, serverCursor);
        }

        <R> void execute(AsyncCallbackSupplier<R> asyncCallbackSupplier, SingleResultCallback<R> singleResultCallback) {
            boolean bl = Assertions.doesNotThrow(this::tryStartOperation);
            if (!bl) {
                singleResultCallback.onResult(null, new IllegalStateException("Cursor has been closed"));
            } else {
                asyncCallbackSupplier.whenComplete(() -> {
                    this.endOperation();
                    if (super.getServerCursor() == null) {
                        this.close();
                    }
                }).get(singleResultCallback);
            }
        }

        @Override
        void markAsPinned(AsyncConnection asyncConnection, Connection.PinningMode pinningMode) {
            asyncConnection.markAsPinned(pinningMode);
        }

        @Override
        void doClose() {
            TimeoutContext timeoutContext = AsyncCommandBatchCursor.this.operationContext.getTimeoutContext();
            timeoutContext.resetToDefaultMaxTime();
            SingleResultCallback<Void> singleResultCallback = (void_, throwable) -> {};
            if (AsyncCommandBatchCursor.this.resetTimeoutWhenClosing) {
                timeoutContext.doWithResetTimeout(this::releaseResourcesAsync, singleResultCallback);
            } else {
                this.releaseResourcesAsync(singleResultCallback);
            }
        }

        private void releaseResourcesAsync(SingleResultCallback<Void> singleResultCallback2) {
            AsyncRunnable.beginAsync().thenRunTryCatchAsyncBlocks(singleResultCallback3 -> {
                if (this.isSkipReleasingServerResourcesOnClose()) {
                    this.unsetServerCursor();
                }
                if (super.getServerCursor() != null) {
                    AsyncRunnable.beginAsync().thenSupply(singleResultCallback -> this.getConnection(singleResultCallback)).thenConsume((asyncConnection, singleResultCallback2) -> AsyncRunnable.beginAsync().thenRun(singleResultCallback -> this.releaseServerResourcesAsync((AsyncConnection)asyncConnection, singleResultCallback)).thenAlwaysRunAndFinish(() -> asyncConnection.release(), singleResultCallback2)).finish(singleResultCallback3);
                } else {
                    singleResultCallback3.complete(singleResultCallback3);
                }
            }, MongoException.class, (throwable, singleResultCallback) -> singleResultCallback.complete(singleResultCallback)).thenAlwaysRunAndFinish(() -> {
                this.unsetServerCursor();
                this.releaseClientResources();
            }, singleResultCallback2);
        }

        <R> void executeWithConnection(AsyncOperationHelper.AsyncCallableConnectionWithCallback<R> asyncCallableConnectionWithCallback, SingleResultCallback<R> singleResultCallback) {
            this.getConnection((asyncConnection, throwable2) -> {
                if (throwable2 != null) {
                    singleResultCallback.onResult(null, throwable2);
                    return;
                }
                asyncCallableConnectionWithCallback.call(Assertions.assertNotNull(asyncConnection), (object, throwable) -> {
                    if (throwable != null) {
                        this.handleException((AsyncConnection)asyncConnection, throwable);
                    }
                    asyncConnection.release();
                    singleResultCallback.onResult(object, throwable);
                });
            });
        }

        private void handleException(AsyncConnection asyncConnection, Throwable throwable) {
            if (throwable instanceof MongoOperationTimeoutException && throwable.getCause() instanceof MongoSocketException) {
                this.onCorruptedConnection(asyncConnection, (MongoSocketException)throwable.getCause());
            } else if (throwable instanceof MongoSocketException) {
                this.onCorruptedConnection(asyncConnection, (MongoSocketException)throwable);
            }
        }

        private void getConnection(SingleResultCallback<AsyncConnection> singleResultCallback) {
            Assertions.assertTrue(this.getState() != CursorResourceManager.State.IDLE);
            AsyncConnection asyncConnection = (AsyncConnection)this.getPinnedConnection();
            if (asyncConnection != null) {
                singleResultCallback.onResult(Assertions.assertNotNull(asyncConnection).retain(), null);
            } else {
                Assertions.assertNotNull((AsyncConnectionSource)this.getConnectionSource()).getConnection(singleResultCallback);
            }
        }

        private void releaseServerResourcesAsync(AsyncConnection asyncConnection, SingleResultCallback<Void> singleResultCallback) {
            AsyncRunnable.beginAsync().thenRun(singleResultCallback2 -> {
                ServerCursor serverCursor = super.getServerCursor();
                if (serverCursor != null) {
                    this.killServerCursorAsync(this.getNamespace(), serverCursor, asyncConnection, singleResultCallback);
                } else {
                    singleResultCallback2.complete(singleResultCallback2);
                }
            }).thenAlwaysRunAndFinish(() -> this.unsetServerCursor(), singleResultCallback);
        }

        private void killServerCursorAsync(MongoNamespace mongoNamespace, ServerCursor serverCursor, AsyncConnection asyncConnection, SingleResultCallback<Void> singleResultCallback) {
            asyncConnection.commandAsync(mongoNamespace.getDatabaseName(), CommandBatchCursorHelper.getKillCursorsCommand(mongoNamespace, serverCursor), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), new BsonDocumentCodec(), AsyncCommandBatchCursor.this.operationContext, (bsonDocument, throwable) -> singleResultCallback.onResult(null, null));
        }
    }
}

