/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.Function;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackBiFunction;
import com.mongodb.internal.async.function.AsyncCallbackFunction;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.async.function.RetryingAsyncCallbackSupplier;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncCommandBatchCursor;
import com.mongodb.internal.operation.AsyncSingleBatchCursor;
import com.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.retry.AttachmentKeys;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

final class AsyncOperationHelper {
    static void withAsyncReadConnectionSource(AsyncReadBinding asyncReadBinding, AsyncCallableWithSource asyncCallableWithSource) {
        asyncReadBinding.getReadConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithSourceCallback(asyncCallableWithSource), OperationHelper.LOGGER));
    }

    static void withAsyncConnection(AsyncWriteBinding asyncWriteBinding, AsyncCallableWithConnection asyncCallableWithConnection) {
        asyncWriteBinding.getWriteConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithConnectionCallback(asyncCallableWithConnection), OperationHelper.LOGGER));
    }

    static <R> void withAsyncSourceAndConnection(AsyncCallbackSupplier<AsyncConnectionSource> asyncCallbackSupplier, boolean bl, SingleResultCallback<R> singleResultCallback, AsyncCallbackBiFunction<AsyncConnectionSource, AsyncConnection, R> asyncCallbackBiFunction) throws OperationHelper.ResourceSupplierInternalException {
        SingleResultCallback<R> singleResultCallback3 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER);
        AsyncOperationHelper.withAsyncSuppliedResource(asyncCallbackSupplier, bl, singleResultCallback3, (asyncConnectionSource, singleResultCallback2) -> AsyncOperationHelper.withAsyncSuppliedResource(asyncConnectionSource::getConnection, bl, singleResultCallback2, (asyncConnection, singleResultCallback) -> asyncCallbackBiFunction.apply((AsyncConnectionSource)asyncConnectionSource, (AsyncConnection)asyncConnection, singleResultCallback)));
    }

    static <R, T extends ReferenceCounted> void withAsyncSuppliedResource(AsyncCallbackSupplier<T> asyncCallbackSupplier, boolean bl, SingleResultCallback<R> singleResultCallback, AsyncCallbackFunction<T, R> asyncCallbackFunction) throws OperationHelper.ResourceSupplierInternalException {
        SingleResultCallback singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER);
        asyncCallbackSupplier.get((referenceCounted, throwable) -> {
            if (throwable != null) {
                if (bl) {
                    throwable = new OperationHelper.ResourceSupplierInternalException(throwable);
                }
                singleResultCallback2.onResult(null, throwable);
            } else {
                Assertions.assertNotNull(referenceCounted);
                try {
                    AsyncCallbackSupplier asyncCallbackSupplier = singleResultCallback -> asyncCallbackFunction.apply(referenceCounted, singleResultCallback);
                    asyncCallbackSupplier.whenComplete(referenceCounted::release).get(singleResultCallback2);
                }
                catch (Exception exception) {
                    singleResultCallback2.onResult(null, exception);
                }
            }
        });
    }

    static void withAsyncConnectionSourceCallableConnection(AsyncConnectionSource asyncConnectionSource, AsyncCallableWithConnection asyncCallableWithConnection) {
        asyncConnectionSource.getConnection((asyncConnection, throwable) -> {
            asyncConnectionSource.release();
            if (throwable != null) {
                asyncCallableWithConnection.call(null, throwable);
            } else {
                asyncCallableWithConnection.call((AsyncConnection)asyncConnection, null);
            }
        });
    }

    static void withAsyncConnectionSource(AsyncConnectionSource asyncConnectionSource, AsyncCallableWithSource asyncCallableWithSource) {
        asyncCallableWithSource.call(asyncConnectionSource, null);
    }

    static <D, T> void executeRetryableReadAsync(AsyncReadBinding asyncReadBinding, String string, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> commandReadTransformerAsync, boolean bl, SingleResultCallback<T> singleResultCallback) {
        AsyncOperationHelper.executeRetryableReadAsync(asyncReadBinding, asyncReadBinding::getReadConnectionSource, string, commandCreator, decoder, commandReadTransformerAsync, bl, singleResultCallback);
    }

    static <D, T> void executeRetryableReadAsync(AsyncReadBinding asyncReadBinding, AsyncCallbackSupplier<AsyncConnectionSource> asyncCallbackSupplier, String string, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> commandReadTransformerAsync, boolean bl, SingleResultCallback<T> singleResultCallback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(bl, asyncReadBinding.getOperationContext().getTimeoutContext());
        asyncReadBinding.retain();
        OperationContext operationContext = asyncReadBinding.getOperationContext();
        AsyncCallbackSupplier<T> asyncCallbackSupplier2 = AsyncOperationHelper.decorateReadWithRetriesAsync(retryState, asyncReadBinding.getOperationContext(), singleResultCallback2 -> AsyncOperationHelper.withAsyncSourceAndConnection(asyncCallbackSupplier, false, singleResultCallback2, (asyncConnectionSource, asyncConnection, singleResultCallback) -> {
            if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(asyncConnectionSource.getServerDescription(), operationContext), singleResultCallback)) {
                return;
            }
            AsyncOperationHelper.createReadCommandAndExecuteAsync(retryState, operationContext, asyncConnectionSource, string, commandCreator, decoder, commandReadTransformerAsync, asyncConnection, singleResultCallback);
        })).whenComplete(asyncReadBinding::release);
        asyncCallbackSupplier2.get(ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER));
    }

    static <T> void executeCommandAsync(AsyncWriteBinding asyncWriteBinding, String string, CommandOperationHelper.CommandCreator commandCreator, CommandWriteTransformerAsync<BsonDocument, T> commandWriteTransformerAsync, SingleResultCallback<T> singleResultCallback2) {
        Assertions.notNull("binding", asyncWriteBinding);
        AsyncOperationHelper.withAsyncSourceAndConnection(asyncWriteBinding::getWriteConnectionSource, false, singleResultCallback2, (asyncConnectionSource, asyncConnection, singleResultCallback) -> AsyncOperationHelper.executeCommandAsync(asyncWriteBinding, string, commandCreator.create(asyncWriteBinding.getOperationContext(), asyncConnectionSource.getServerDescription(), asyncConnection.getDescription()), asyncConnection, commandWriteTransformerAsync, singleResultCallback));
    }

    static <T> void executeCommandAsync(AsyncWriteBinding asyncWriteBinding, String string, BsonDocument bsonDocument, AsyncConnection asyncConnection, CommandWriteTransformerAsync<BsonDocument, T> commandWriteTransformerAsync, SingleResultCallback<T> singleResultCallback) {
        Assertions.notNull("binding", asyncWriteBinding);
        SingleResultCallback<T> singleResultCallback2 = AsyncOperationHelper.addingRetryableLabelCallback(singleResultCallback, asyncConnection.getDescription().getMaxWireVersion());
        asyncConnection.commandAsync(string, bsonDocument, NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), new BsonDocumentCodec(), asyncWriteBinding.getOperationContext(), AsyncOperationHelper.transformingWriteCallback(commandWriteTransformerAsync, asyncConnection, singleResultCallback2));
    }

    static <T, R> void executeRetryableWriteAsync(AsyncWriteBinding asyncWriteBinding, String string, @Nullable ReadPreference readPreference, FieldNameValidator fieldNameValidator, Decoder<T> decoder, CommandOperationHelper.CommandCreator commandCreator, CommandWriteTransformerAsync<T, R> commandWriteTransformerAsync, Function<BsonDocument, BsonDocument> function, SingleResultCallback<R> singleResultCallback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(true, asyncWriteBinding.getOperationContext().getTimeoutContext());
        asyncWriteBinding.retain();
        OperationContext operationContext = asyncWriteBinding.getOperationContext();
        AsyncCallbackSupplier<R> asyncCallbackSupplier = AsyncOperationHelper.decorateWriteWithRetriesAsync(retryState, operationContext, singleResultCallback2 -> {
            boolean bl = retryState.isFirstAttempt();
            if (!bl && operationContext.getSessionContext().hasActiveTransaction()) {
                operationContext.getSessionContext().clearTransactionContext();
            }
            AsyncOperationHelper.withAsyncSourceAndConnection(asyncWriteBinding::getWriteConnectionSource, true, singleResultCallback2, (asyncConnectionSource, asyncConnection, singleResultCallback) -> {
                BsonDocument bsonDocument2;
                SingleResultCallback singleResultCallback2;
                int n = asyncConnection.getDescription().getMaxWireVersion();
                SingleResultCallback singleResultCallback3 = singleResultCallback2 = bl ? singleResultCallback : AsyncOperationHelper.addingRetryableLabelCallback(singleResultCallback, n);
                if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryWrite(asyncConnection.getDescription(), operationContext.getSessionContext()), singleResultCallback2)) {
                    return;
                }
                try {
                    bsonDocument2 = retryState.attachment(AttachmentKeys.command()).map(bsonDocument -> {
                        Assertions.assertFalse(bl);
                        return (BsonDocument)function.apply((BsonDocument)bsonDocument);
                    }).orElseGet(() -> commandCreator.create(operationContext, asyncConnectionSource.getServerDescription(), asyncConnection.getDescription()));
                    retryState.attach(AttachmentKeys.maxWireVersion(), n, true).attach(AttachmentKeys.retryableCommandFlag(), CommandOperationHelper.isRetryWritesEnabled(bsonDocument2), true).attach(AttachmentKeys.commandDescriptionSupplier(), bsonDocument2::getFirstKey, false).attach(AttachmentKeys.command(), bsonDocument2, false);
                }
                catch (Throwable throwable) {
                    singleResultCallback2.onResult(null, throwable);
                    return;
                }
                asyncConnection.commandAsync(string, bsonDocument2, fieldNameValidator, readPreference, decoder, operationContext, AsyncOperationHelper.transformingWriteCallback(commandWriteTransformerAsync, asyncConnection, singleResultCallback2));
            });
        }).whenComplete(asyncWriteBinding::release);
        asyncCallbackSupplier.get(AsyncOperationHelper.exceptionTransformingCallback(ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER)));
    }

    static <D, T> void createReadCommandAndExecuteAsync(RetryState retryState, OperationContext operationContext, AsyncConnectionSource asyncConnectionSource, String string, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformerAsync<D, T> commandReadTransformerAsync, AsyncConnection asyncConnection, SingleResultCallback<T> singleResultCallback) {
        BsonDocument bsonDocument;
        try {
            bsonDocument = commandCreator.create(operationContext, asyncConnectionSource.getServerDescription(), asyncConnection.getDescription());
            retryState.attach(AttachmentKeys.commandDescriptionSupplier(), bsonDocument::getFirstKey, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            singleResultCallback.onResult(null, illegalArgumentException);
            return;
        }
        asyncConnection.commandAsync(string, bsonDocument, NoOpFieldNameValidator.INSTANCE, asyncConnectionSource.getReadPreference(), decoder, operationContext, AsyncOperationHelper.transformingReadCallback(commandReadTransformerAsync, asyncConnectionSource, asyncConnection, singleResultCallback));
    }

    static <R> AsyncCallbackSupplier<R> decorateReadWithRetriesAsync(RetryState retryState, OperationContext operationContext, AsyncCallbackSupplier<R> asyncCallbackSupplier) {
        return new RetryingAsyncCallbackSupplier(retryState, CommandOperationHelper.onRetryableReadAttemptFailure(operationContext), CommandOperationHelper::shouldAttemptToRetryRead, singleResultCallback -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            asyncCallbackSupplier.get(singleResultCallback);
        });
    }

    static <R> AsyncCallbackSupplier<R> decorateWriteWithRetriesAsync(RetryState retryState, OperationContext operationContext, AsyncCallbackSupplier<R> asyncCallbackSupplier) {
        return new RetryingAsyncCallbackSupplier(retryState, CommandOperationHelper.onRetryableWriteAttemptFailure(operationContext), CommandOperationHelper::loggingShouldAttemptToRetryWriteAndAddRetryableLabel, singleResultCallback -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            asyncCallbackSupplier.get(singleResultCallback);
        });
    }

    static CommandWriteTransformerAsync<BsonDocument, Void> writeConcernErrorTransformerAsync(TimeoutContext timeoutContext) {
        return (bsonDocument, asyncConnection) -> {
            Assertions.assertNotNull(bsonDocument);
            WriteConcernHelper.throwOnWriteConcernError(bsonDocument, asyncConnection.getDescription().getServerAddress(), asyncConnection.getDescription().getMaxWireVersion(), timeoutContext);
            return null;
        };
    }

    static <T> CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncSingleBatchCursorTransformer(String string) {
        return (bsonDocument, asyncConnectionSource, asyncConnection) -> new AsyncSingleBatchCursor(BsonDocumentWrapperHelper.toList(bsonDocument, string), 0);
    }

    static <T> AsyncBatchCursor<T> cursorDocumentToAsyncBatchCursor(TimeoutMode timeoutMode, BsonDocument bsonDocument, int n, Decoder<T> decoder, @Nullable BsonValue bsonValue, AsyncConnectionSource asyncConnectionSource, AsyncConnection asyncConnection) {
        return new AsyncCommandBatchCursor<T>(timeoutMode, bsonDocument, n, 0L, decoder, bsonValue, asyncConnectionSource, asyncConnection);
    }

    static <T> SingleResultCallback<T> releasingCallback(SingleResultCallback<T> singleResultCallback, AsyncConnection asyncConnection) {
        return new ReferenceCountedReleasingWrappedCallback<T>(singleResultCallback, Collections.singletonList(asyncConnection));
    }

    static <R> SingleResultCallback<R> exceptionTransformingCallback(SingleResultCallback<R> singleResultCallback) {
        return (object, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof MongoException) {
                    singleResultCallback.onResult(null, CommandOperationHelper.transformWriteException((MongoException)throwable));
                } else {
                    singleResultCallback.onResult(null, throwable);
                }
            } else {
                singleResultCallback.onResult(object, null);
            }
        };
    }

    private static <T, R> SingleResultCallback<T> transformingWriteCallback(CommandWriteTransformerAsync<T, R> commandWriteTransformerAsync, AsyncConnection asyncConnection, SingleResultCallback<R> singleResultCallback) {
        return (object, throwable) -> {
            if (throwable != null) {
                singleResultCallback.onResult(null, throwable);
            } else {
                Object r;
                try {
                    r = commandWriteTransformerAsync.apply(Assertions.assertNotNull(object), asyncConnection);
                }
                catch (Throwable throwable2) {
                    singleResultCallback.onResult(null, throwable2);
                    return;
                }
                singleResultCallback.onResult(r, null);
            }
        };
    }

    private static <R> SingleResultCallback<R> addingRetryableLabelCallback(SingleResultCallback<R> singleResultCallback, int n) {
        return (object, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof MongoException) {
                    CommandOperationHelper.addRetryableWriteErrorLabel((MongoException)throwable, n);
                }
                singleResultCallback.onResult(null, throwable);
            } else {
                singleResultCallback.onResult(object, null);
            }
        };
    }

    private static <T, R> SingleResultCallback<T> transformingReadCallback(CommandReadTransformerAsync<T, R> commandReadTransformerAsync, AsyncConnectionSource asyncConnectionSource, AsyncConnection asyncConnection, SingleResultCallback<R> singleResultCallback) {
        return (object, throwable) -> {
            if (throwable != null) {
                singleResultCallback.onResult(null, throwable);
            } else {
                Object r;
                try {
                    r = commandReadTransformerAsync.apply(Assertions.assertNotNull(object), asyncConnectionSource, asyncConnection);
                }
                catch (Throwable throwable2) {
                    singleResultCallback.onResult(null, throwable2);
                    return;
                }
                singleResultCallback.onResult(r, null);
            }
        };
    }

    private AsyncOperationHelper() {
    }

    private static class AsyncCallableWithSourceCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithSource callable;

        AsyncCallableWithSourceCallback(AsyncCallableWithSource asyncCallableWithSource) {
            this.callable = asyncCallableWithSource;
        }

        @Override
        public void onResult(@Nullable AsyncConnectionSource asyncConnectionSource, @Nullable Throwable throwable) {
            if (throwable != null) {
                this.callable.call(null, throwable);
            } else {
                AsyncOperationHelper.withAsyncConnectionSource(Assertions.assertNotNull(asyncConnectionSource), this.callable);
            }
        }
    }

    static interface AsyncCallableWithSource {
        public void call(@Nullable AsyncConnectionSource var1, @Nullable Throwable var2);
    }

    private static class AsyncCallableWithConnectionCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithConnection callable;

        AsyncCallableWithConnectionCallback(AsyncCallableWithConnection asyncCallableWithConnection) {
            this.callable = asyncCallableWithConnection;
        }

        @Override
        public void onResult(@Nullable AsyncConnectionSource asyncConnectionSource, @Nullable Throwable throwable) {
            if (throwable != null) {
                this.callable.call(null, throwable);
            } else {
                AsyncOperationHelper.withAsyncConnectionSourceCallableConnection(Assertions.assertNotNull(asyncConnectionSource), this.callable);
            }
        }
    }

    static interface AsyncCallableWithConnection {
        public void call(@Nullable AsyncConnection var1, @Nullable Throwable var2);
    }

    static interface CommandReadTransformerAsync<T, R> {
        @Nullable
        public R apply(T var1, AsyncConnectionSource var2, AsyncConnection var3);
    }

    static interface CommandWriteTransformerAsync<T, R> {
        @Nullable
        public R apply(T var1, AsyncConnection var2);
    }

    private static class ReferenceCountedReleasingWrappedCallback<T>
    implements SingleResultCallback<T> {
        private final SingleResultCallback<T> wrapped;
        private final List<? extends ReferenceCounted> referenceCounted;

        ReferenceCountedReleasingWrappedCallback(SingleResultCallback<T> singleResultCallback, List<? extends ReferenceCounted> list) {
            this.wrapped = singleResultCallback;
            this.referenceCounted = Assertions.notNull("referenceCounted", list);
        }

        @Override
        public void onResult(@Nullable T t, @Nullable Throwable throwable) {
            for (ReferenceCounted referenceCounted : this.referenceCounted) {
                if (referenceCounted == null) continue;
                referenceCounted.release();
            }
            this.wrapped.onResult(t, throwable);
        }
    }

    static interface AsyncCallableConnectionWithCallback<T> {
        public void call(AsyncConnection var1, SingleResultCallback<T> var2);
    }
}

