/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.SearchIndexModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.MapReduceAsyncBatchCursor;
import com.mongodb.internal.operation.MapReduceStatistics;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class AsyncOperations<TDocument> {
    private final Operations<TDocument> operations;
    private final TimeoutSettings timeoutSettings;

    public AsyncOperations(MongoNamespace mongoNamespace, Class<TDocument> clazz, ReadPreference readPreference, CodecRegistry codecRegistry, ReadConcern readConcern, WriteConcern writeConcern, boolean bl, boolean bl2, TimeoutSettings timeoutSettings) {
        WriteConcern writeConcern2 = writeConcern;
        if (timeoutSettings.getTimeoutMS() != null) {
            writeConcern2 = Assertions.assertNotNull(WriteConcernHelper.cloneWithoutTimeout(writeConcern));
        }
        this.operations = new Operations<TDocument>(mongoNamespace, clazz, readPreference, codecRegistry, readConcern, writeConcern2, bl, bl2);
        this.timeoutSettings = timeoutSettings;
    }

    public MongoNamespace getNamespace() {
        return Assertions.assertNotNull(this.operations.getNamespace());
    }

    public Class<TDocument> getDocumentClass() {
        return this.operations.getDocumentClass();
    }

    public ReadPreference getReadPreference() {
        return this.operations.getReadPreference();
    }

    public CodecRegistry getCodecRegistry() {
        return this.operations.getCodecRegistry();
    }

    public ReadConcern getReadConcern() {
        return this.operations.getReadConcern();
    }

    public WriteConcern getWriteConcern() {
        return this.operations.getWriteConcern();
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    public boolean isRetryWrites() {
        return this.operations.isRetryWrites();
    }

    public boolean isRetryReads() {
        return this.operations.isRetryReads();
    }

    public TimeoutSettings createTimeoutSettings(long l) {
        return this.timeoutSettings.withMaxTimeMS(l);
    }

    public TimeoutSettings createTimeoutSettings(long l, long l2) {
        return this.timeoutSettings.withMaxTimeAndMaxAwaitTimeMS(l, l2);
    }

    public TimeoutSettings createTimeoutSettings(CountOptions countOptions) {
        return this.createTimeoutSettings(countOptions.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(EstimatedDocumentCountOptions estimatedDocumentCountOptions) {
        return this.createTimeoutSettings(estimatedDocumentCountOptions.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOptions findOptions) {
        return this.timeoutSettings.withMaxTimeAndMaxAwaitTimeMS(findOptions.getMaxTime(TimeUnit.MILLISECONDS), findOptions.getMaxAwaitTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOneAndDeleteOptions findOneAndDeleteOptions) {
        return this.createTimeoutSettings(findOneAndDeleteOptions.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOneAndReplaceOptions findOneAndReplaceOptions) {
        return this.createTimeoutSettings(findOneAndReplaceOptions.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public TimeoutSettings createTimeoutSettings(FindOneAndUpdateOptions findOneAndUpdateOptions) {
        return this.timeoutSettings.withMaxTimeMS(findOneAndUpdateOptions.getMaxTime(TimeUnit.MILLISECONDS));
    }

    public AsyncReadOperation<Long> countDocuments(Bson bson, CountOptions countOptions) {
        return this.operations.countDocuments(bson, countOptions);
    }

    public AsyncReadOperation<Long> estimatedDocumentCount(EstimatedDocumentCountOptions estimatedDocumentCountOptions) {
        return this.operations.estimatedDocumentCount(estimatedDocumentCountOptions);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> findFirst(Bson bson, Class<TResult> clazz, FindOptions findOptions) {
        return this.operations.findFirst(bson, clazz, findOptions);
    }

    public <TResult> AsyncExplainableReadOperation<AsyncBatchCursor<TResult>> find(Bson bson, Class<TResult> clazz, FindOptions findOptions) {
        return this.operations.find(bson, clazz, findOptions);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> find(MongoNamespace mongoNamespace, Bson bson, Class<TResult> clazz, FindOptions findOptions) {
        return this.operations.find(mongoNamespace, bson, clazz, findOptions);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> distinct(String string, Bson bson, Class<TResult> clazz, Collation collation, BsonValue bsonValue, Bson bson2, String string2) {
        return this.operations.distinct(string, bson, clazz, collation, bsonValue, bson2, string2);
    }

    public <TResult> AsyncExplainableReadOperation<AsyncBatchCursor<TResult>> aggregate(List<? extends Bson> list, Class<TResult> clazz, @Nullable TimeoutMode timeoutMode, @Nullable Integer n, Collation collation, Bson bson, String string, BsonValue bsonValue, Bson bson2, Boolean bl, AggregationLevel aggregationLevel) {
        return this.operations.aggregate(list, clazz, timeoutMode, n, collation, bson, string, bsonValue, bson2, bl, aggregationLevel);
    }

    public AsyncReadOperation<Void> aggregateToCollection(List<? extends Bson> list, @Nullable TimeoutMode timeoutMode, Boolean bl, Boolean bl2, Collation collation, Bson bson, String string, BsonValue bsonValue, Bson bson2, AggregationLevel aggregationLevel) {
        return this.operations.aggregateToCollection(list, timeoutMode, bl, bl2, collation, bson, string, bsonValue, bson2, aggregationLevel);
    }

    public AsyncWriteOperation<MapReduceStatistics> mapReduceToCollection(String string, String string2, String string3, String string4, String string5, Bson bson, int n, boolean bl, Bson bson2, Bson bson3, boolean bl2, MapReduceAction mapReduceAction, Boolean bl3, Collation collation) {
        return this.operations.mapReduceToCollection(string, string2, string3, string4, string5, bson, n, bl, bson2, bson3, bl2, mapReduceAction, bl3, collation);
    }

    public <TResult> AsyncReadOperation<MapReduceAsyncBatchCursor<TResult>> mapReduce(String string, String string2, String string3, Class<TResult> clazz, Bson bson, int n, boolean bl, Bson bson2, Bson bson3, boolean bl2, Collation collation) {
        return this.operations.mapReduce(string, string2, string3, clazz, bson, n, bl, bson2, bson3, bl2, collation);
    }

    public AsyncWriteOperation<TDocument> findOneAndDelete(Bson bson, FindOneAndDeleteOptions findOneAndDeleteOptions) {
        return this.operations.findOneAndDelete(bson, findOneAndDeleteOptions);
    }

    public AsyncWriteOperation<TDocument> findOneAndReplace(Bson bson, TDocument TDocument, FindOneAndReplaceOptions findOneAndReplaceOptions) {
        return this.operations.findOneAndReplace(bson, TDocument, findOneAndReplaceOptions);
    }

    public AsyncWriteOperation<TDocument> findOneAndUpdate(Bson bson, Bson bson2, FindOneAndUpdateOptions findOneAndUpdateOptions) {
        return this.operations.findOneAndUpdate(bson, bson2, findOneAndUpdateOptions);
    }

    public AsyncWriteOperation<TDocument> findOneAndUpdate(Bson bson, List<? extends Bson> list, FindOneAndUpdateOptions findOneAndUpdateOptions) {
        return this.operations.findOneAndUpdate(bson, list, findOneAndUpdateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> insertOne(TDocument TDocument, InsertOneOptions insertOneOptions) {
        return this.operations.insertOne(TDocument, insertOneOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> replaceOne(Bson bson, TDocument TDocument, ReplaceOptions replaceOptions) {
        return this.operations.replaceOne(bson, TDocument, replaceOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> deleteOne(Bson bson, DeleteOptions deleteOptions) {
        return this.operations.deleteOne(bson, deleteOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> deleteMany(Bson bson, DeleteOptions deleteOptions) {
        return this.operations.deleteMany(bson, deleteOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateOne(Bson bson, Bson bson2, UpdateOptions updateOptions) {
        return this.operations.updateOne(bson, bson2, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateOne(Bson bson, List<? extends Bson> list, UpdateOptions updateOptions) {
        return this.operations.updateOne(bson, list, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateMany(Bson bson, Bson bson2, UpdateOptions updateOptions) {
        return this.operations.updateMany(bson, bson2, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateMany(Bson bson, List<? extends Bson> list, UpdateOptions updateOptions) {
        return this.operations.updateMany(bson, list, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> insertMany(List<? extends TDocument> list, InsertManyOptions insertManyOptions) {
        return this.operations.insertMany(list, insertManyOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> list, BulkWriteOptions bulkWriteOptions) {
        return this.operations.bulkWrite(list, bulkWriteOptions);
    }

    public AsyncWriteOperation<ClientBulkWriteResult> clientBulkWriteOperation(List<? extends ClientNamespacedWriteModel> list, @Nullable ClientBulkWriteOptions clientBulkWriteOptions) {
        return this.operations.clientBulkWriteOperation(list, clientBulkWriteOptions);
    }

    public <TResult> AsyncReadOperation<TResult> commandRead(Bson bson, Class<TResult> clazz) {
        return this.operations.commandRead(bson, clazz);
    }

    public AsyncWriteOperation<Void> dropDatabase() {
        return this.operations.dropDatabase();
    }

    public AsyncWriteOperation<Void> createCollection(String string, CreateCollectionOptions createCollectionOptions, AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.createCollection(string, createCollectionOptions, autoEncryptionSettings);
    }

    public AsyncWriteOperation<Void> dropCollection(DropCollectionOptions dropCollectionOptions, AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.dropCollection(dropCollectionOptions, autoEncryptionSettings);
    }

    public AsyncWriteOperation<Void> renameCollection(MongoNamespace mongoNamespace, RenameCollectionOptions renameCollectionOptions) {
        return this.operations.renameCollection(mongoNamespace, renameCollectionOptions);
    }

    public AsyncWriteOperation<Void> createView(String string, String string2, List<? extends Bson> list, CreateViewOptions createViewOptions) {
        return this.operations.createView(string, string2, list, createViewOptions);
    }

    public AsyncWriteOperation<Void> createIndexes(List<IndexModel> list, CreateIndexOptions createIndexOptions) {
        return this.operations.createIndexes(list, createIndexOptions);
    }

    public AsyncWriteOperation<Void> createSearchIndexes(List<SearchIndexModel> list) {
        return this.operations.createSearchIndexes(list);
    }

    public AsyncWriteOperation<Void> updateSearchIndex(String string, Bson bson) {
        return this.operations.updateSearchIndex(string, bson);
    }

    public AsyncWriteOperation<Void> dropSearchIndex(String string) {
        return this.operations.dropSearchIndex(string);
    }

    public <TResult> AsyncExplainableReadOperation<AsyncBatchCursor<TResult>> listSearchIndexes(Class<TResult> clazz, @Nullable String string, @Nullable Integer n, @Nullable Collation collation, @Nullable BsonValue bsonValue, @Nullable Boolean bl) {
        return this.operations.listSearchIndexes(clazz, string, n, collation, bsonValue, bl);
    }

    public AsyncWriteOperation<Void> dropIndex(String string, DropIndexOptions dropIndexOptions) {
        return this.operations.dropIndex(string, dropIndexOptions);
    }

    public AsyncWriteOperation<Void> dropIndex(Bson bson, DropIndexOptions dropIndexOptions) {
        return this.operations.dropIndex(bson, dropIndexOptions);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listCollections(String string, Class<TResult> clazz, Bson bson, boolean bl, boolean bl2, @Nullable Integer n, BsonValue bsonValue, @Nullable TimeoutMode timeoutMode) {
        return this.operations.listCollections(string, clazz, bson, bl, bl2, n, bsonValue, timeoutMode);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listDatabases(Class<TResult> clazz, Bson bson, Boolean bl, Boolean bl2, BsonValue bsonValue) {
        return this.operations.listDatabases(clazz, bson, bl, bl2, bsonValue);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listIndexes(Class<TResult> clazz, @Nullable Integer n, BsonValue bsonValue, @Nullable TimeoutMode timeoutMode) {
        return this.operations.listIndexes(clazz, n, bsonValue, timeoutMode);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> changeStream(FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<? extends Bson> list, Decoder<TResult> decoder, ChangeStreamLevel changeStreamLevel, Integer n, Collation collation, BsonValue bsonValue, BsonDocument bsonDocument, BsonTimestamp bsonTimestamp, BsonDocument bsonDocument2, boolean bl) {
        return this.operations.changeStream(fullDocument, fullDocumentBeforeChange, list, decoder, changeStreamLevel, n, collation, bsonValue, bsonDocument, bsonTimestamp, bsonDocument2, bl);
    }
}

