/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoException;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import java.util.Collections;
import java.util.List;

class AsyncSingleBatchCursor<T>
implements AsyncBatchCursor<T> {
    private final List<T> batch;
    private final int batchSize;
    private volatile boolean hasNext = true;
    private volatile boolean closed = false;

    static <R> AsyncSingleBatchCursor<R> createEmptyAsyncSingleBatchCursor(int n) {
        return new AsyncSingleBatchCursor(Collections.emptyList(), n);
    }

    AsyncSingleBatchCursor(List<T> list, int n) {
        this.batch = list;
        this.batchSize = n;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void next(SingleResultCallback<List<T>> singleResultCallback) {
        if (this.closed) {
            singleResultCallback.onResult(null, new MongoException("next() called after the cursor was closed."));
        } else if (this.hasNext && !this.batch.isEmpty()) {
            this.hasNext = false;
            singleResultCallback.onResult(this.batch, null);
        } else {
            this.closed = true;
            singleResultCallback.onResult(Collections.emptyList(), null);
        }
    }

    @Override
    public void setBatchSize(int n) {
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

