/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.FindAndModifyHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

public abstract class BaseFindAndModifyOperation<T>
implements AsyncWriteOperation<T>,
WriteOperation<T> {
    private final MongoNamespace namespace;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final Decoder<T> decoder;
    private BsonDocument filter;
    private BsonDocument projection;
    private BsonDocument sort;
    private Collation collation;
    private BsonDocument hint;
    private String hintString;
    private BsonValue comment;
    private BsonDocument variables;

    protected BaseFindAndModifyOperation(MongoNamespace mongoNamespace, WriteConcern writeConcern, boolean bl, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = bl;
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public T execute(WriteBinding writeBinding) {
        return SyncOperationHelper.executeRetryableWrite(writeBinding, this.getDatabaseName(), null, this.getFieldNameValidator(), CommandResultDocumentCodec.create(this.getDecoder(), "value"), this.getCommandCreator(), FindAndModifyHelper.transformer(), bsonDocument -> bsonDocument);
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<T> singleResultCallback) {
        AsyncOperationHelper.executeRetryableWriteAsync(asyncWriteBinding, this.getDatabaseName(), null, this.getFieldNameValidator(), CommandResultDocumentCodec.create(this.getDecoder(), "value"), this.getCommandCreator(), FindAndModifyHelper.asyncTransformer(), bsonDocument -> bsonDocument, singleResultCallback);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public boolean isRetryWrites() {
        return this.retryWrites;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public BaseFindAndModifyOperation<T> filter(@Nullable BsonDocument bsonDocument) {
        this.filter = bsonDocument;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public BaseFindAndModifyOperation<T> projection(@Nullable BsonDocument bsonDocument) {
        this.projection = bsonDocument;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public BaseFindAndModifyOperation<T> sort(@Nullable BsonDocument bsonDocument) {
        this.sort = bsonDocument;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    @Nullable
    public BsonDocument getHint() {
        return this.hint;
    }

    public BaseFindAndModifyOperation<T> hint(@Nullable BsonDocument bsonDocument) {
        this.hint = bsonDocument;
        return this;
    }

    @Nullable
    public String getHintString() {
        return this.hintString;
    }

    public BaseFindAndModifyOperation<T> hintString(@Nullable String string) {
        this.hintString = string;
        return this;
    }

    public BaseFindAndModifyOperation<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public BaseFindAndModifyOperation<T> comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    public BsonDocument getLet() {
        return this.variables;
    }

    public BaseFindAndModifyOperation<T> let(@Nullable BsonDocument bsonDocument) {
        this.variables = bsonDocument;
        return this;
    }

    protected abstract FieldNameValidator getFieldNameValidator();

    protected abstract void specializeCommand(BsonDocument var1, ConnectionDescription var2);

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            SessionContext sessionContext = operationContext.getSessionContext();
            BsonDocument bsonDocument = new BsonDocument("findAndModify", new BsonString(this.getNamespace().getCollectionName()));
            DocumentHelper.putIfNotNull(bsonDocument, "query", this.getFilter());
            DocumentHelper.putIfNotNull(bsonDocument, "fields", this.getProjection());
            DocumentHelper.putIfNotNull(bsonDocument, "sort", this.getSort());
            this.specializeCommand(bsonDocument, connectionDescription);
            if (this.getWriteConcern().isAcknowledged() && !this.getWriteConcern().isServerDefault() && !sessionContext.hasActiveTransaction()) {
                bsonDocument.put("writeConcern", this.getWriteConcern().asDocument());
            }
            if (this.getCollation() != null) {
                bsonDocument.put("collation", this.getCollation().asDocument());
            }
            if (this.getHint() != null || this.getHintString() != null) {
                OperationHelper.validateHintForFindAndModify(connectionDescription, this.getWriteConcern());
                if (this.getHint() != null) {
                    bsonDocument.put("hint", this.getHint());
                } else {
                    bsonDocument.put("hint", new BsonString(this.getHintString()));
                }
            }
            DocumentHelper.putIfNotNull(bsonDocument, "comment", this.getComment());
            DocumentHelper.putIfNotNull(bsonDocument, "let", this.getLet());
            if (OperationHelper.isRetryableWrite(this.isRetryWrites(), this.getWriteConcern(), connectionDescription, sessionContext)) {
                bsonDocument.put("txnNumber", new BsonInt64(sessionContext.advanceTransactionNumber()));
            }
            return bsonDocument;
        };
    }

    private String getDatabaseName() {
        return this.getNamespace().getDatabaseName();
    }
}

