/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteInsert;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.bulk.DeleteRequest;
import com.mongodb.internal.bulk.UpdateRequest;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.bulk.WriteRequestWithIndex;
import com.mongodb.internal.connection.BulkWriteBatchCombiner;
import com.mongodb.internal.connection.IndexMap;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.SplittablePayload;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.internal.validator.MappedFieldNameValidator;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.internal.validator.ReplacingDocumentFieldNameValidator;
import com.mongodb.internal.validator.UpdateFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public final class BulkWriteBatch {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final Decoder<BsonDocument> DECODER = REGISTRY.get(BsonDocument.class);
    private final MongoNamespace namespace;
    private final ConnectionDescription connectionDescription;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private final Boolean bypassDocumentValidation;
    private final boolean retryWrites;
    private final BulkWriteBatchCombiner bulkWriteBatchCombiner;
    private final IndexMap indexMap;
    private final WriteRequest.Type batchType;
    private final BsonDocument command;
    private final SplittablePayload payload;
    private final List<WriteRequestWithIndex> unprocessed;
    private final OperationContext operationContext;
    private final BsonValue comment;
    private final BsonDocument variables;

    static BulkWriteBatch createBulkWriteBatch(MongoNamespace mongoNamespace, ConnectionDescription connectionDescription, boolean bl, WriteConcern writeConcern, Boolean bl2, boolean bl3, List<? extends WriteRequest> list, OperationContext operationContext, @Nullable BsonValue bsonValue, @Nullable BsonDocument bsonDocument) {
        boolean bl4 = OperationHelper.isRetryableWrite(bl3, writeConcern, connectionDescription, operationContext.getSessionContext());
        ArrayList<WriteRequestWithIndex> arrayList = new ArrayList<WriteRequestWithIndex>();
        boolean bl5 = true;
        for (int i = 0; i < list.size(); ++i) {
            WriteRequest writeRequest = list.get(i);
            bl5 = bl5 && BulkWriteBatch.isRetryable(writeRequest);
            arrayList.add(new WriteRequestWithIndex(writeRequest, i));
        }
        if (bl4 && !bl5) {
            bl4 = false;
            BulkWriteBatch.logWriteModelDoesNotSupportRetries();
        }
        return new BulkWriteBatch(mongoNamespace, connectionDescription, bl, writeConcern, bl2, bl4, new BulkWriteBatchCombiner(connectionDescription.getServerAddress(), bl, writeConcern), arrayList, operationContext, bsonValue, bsonDocument);
    }

    private BulkWriteBatch(MongoNamespace mongoNamespace, ConnectionDescription connectionDescription, boolean bl, WriteConcern writeConcern2, @Nullable Boolean bl2, boolean bl3, BulkWriteBatchCombiner bulkWriteBatchCombiner, List<WriteRequestWithIndex> list, OperationContext operationContext, @Nullable BsonValue bsonValue, @Nullable BsonDocument bsonDocument) {
        this.namespace = mongoNamespace;
        this.connectionDescription = connectionDescription;
        this.ordered = bl;
        this.writeConcern = writeConcern2;
        this.bypassDocumentValidation = bl2;
        this.bulkWriteBatchCombiner = bulkWriteBatchCombiner;
        this.batchType = list.isEmpty() ? WriteRequest.Type.INSERT : list.get(0).getType();
        this.retryWrites = bl3;
        ArrayList<WriteRequestWithIndex> arrayList = new ArrayList<WriteRequestWithIndex>();
        ArrayList<WriteRequestWithIndex> arrayList2 = new ArrayList<WriteRequestWithIndex>();
        IndexMap indexMap = IndexMap.create();
        for (int i = 0; i < list.size(); ++i) {
            WriteRequestWithIndex writeRequestWithIndex = list.get(i);
            if (writeRequestWithIndex.getType() != this.batchType) {
                if (bl) {
                    arrayList2.addAll(list.subList(i, list.size()));
                    break;
                }
                arrayList2.add(writeRequestWithIndex);
                continue;
            }
            indexMap = indexMap.add(arrayList.size(), writeRequestWithIndex.getIndex());
            arrayList.add(writeRequestWithIndex);
        }
        this.indexMap = indexMap;
        this.unprocessed = arrayList2;
        this.payload = new SplittablePayload(this.getPayloadType(this.batchType), arrayList, bl, this.getFieldNameValidator());
        this.operationContext = operationContext;
        this.comment = bsonValue;
        this.variables = bsonDocument;
        this.command = new BsonDocument();
        SessionContext sessionContext = operationContext.getSessionContext();
        if (!arrayList.isEmpty()) {
            this.command.put(this.getCommandName(this.batchType), new BsonString(mongoNamespace.getCollectionName()));
            this.command.put("ordered", new BsonBoolean(bl));
            CommandOperationHelper.commandWriteConcern(writeConcern2, sessionContext).ifPresent(writeConcern -> this.command.put("writeConcern", writeConcern.asDocument()));
            if (bl2 != null) {
                this.command.put("bypassDocumentValidation", new BsonBoolean(bl2));
            }
            DocumentHelper.putIfNotNull(this.command, "comment", bsonValue);
            DocumentHelper.putIfNotNull(this.command, "let", bsonDocument);
            if (bl3) {
                this.command.put("txnNumber", new BsonInt64(sessionContext.advanceTransactionNumber()));
            }
        }
    }

    private BulkWriteBatch(MongoNamespace mongoNamespace, ConnectionDescription connectionDescription, boolean bl, WriteConcern writeConcern, Boolean bl2, boolean bl3, BulkWriteBatchCombiner bulkWriteBatchCombiner, IndexMap indexMap, WriteRequest.Type type, BsonDocument bsonDocument, SplittablePayload splittablePayload, List<WriteRequestWithIndex> list, OperationContext operationContext, @Nullable BsonValue bsonValue, @Nullable BsonDocument bsonDocument2) {
        this.namespace = mongoNamespace;
        this.connectionDescription = connectionDescription;
        this.ordered = bl;
        this.writeConcern = writeConcern;
        this.bypassDocumentValidation = bl2;
        this.bulkWriteBatchCombiner = bulkWriteBatchCombiner;
        this.indexMap = indexMap;
        this.batchType = type;
        this.payload = splittablePayload;
        this.unprocessed = list;
        this.retryWrites = bl3;
        this.operationContext = operationContext;
        this.comment = bsonValue;
        this.variables = bsonDocument2;
        if (bl3) {
            bsonDocument.put("txnNumber", new BsonInt64(operationContext.getSessionContext().advanceTransactionNumber()));
        }
        this.command = bsonDocument;
    }

    void addResult(@Nullable BsonDocument bsonDocument) {
        if (this.writeConcern.isAcknowledged()) {
            if (this.hasError(Assertions.assertNotNull(bsonDocument))) {
                MongoBulkWriteException mongoBulkWriteException = this.getBulkWriteException(bsonDocument);
                this.bulkWriteBatchCombiner.addErrorResult(mongoBulkWriteException, this.indexMap);
            } else {
                this.bulkWriteBatchCombiner.addResult(this.getBulkWriteResult(bsonDocument));
            }
        }
    }

    boolean getRetryWrites() {
        return this.retryWrites;
    }

    BsonDocument getCommand() {
        return this.command;
    }

    SplittablePayload getPayload() {
        return this.payload;
    }

    Decoder<BsonDocument> getDecoder() {
        return DECODER;
    }

    BulkWriteResult getResult() {
        return this.bulkWriteBatchCombiner.getResult();
    }

    boolean hasErrors() {
        return this.bulkWriteBatchCombiner.hasErrors();
    }

    @Nullable
    MongoBulkWriteException getError() {
        return this.bulkWriteBatchCombiner.getError();
    }

    boolean shouldProcessBatch() {
        return !this.bulkWriteBatchCombiner.shouldStopSendingMoreBatches() && !this.payload.isEmpty();
    }

    boolean hasAnotherBatch() {
        return !this.unprocessed.isEmpty();
    }

    BulkWriteBatch getNextBatch() {
        if (this.payload.hasAnotherSplit()) {
            IndexMap indexMap = IndexMap.create();
            int n = 0;
            for (int i = this.payload.getPosition(); i < this.payload.size(); ++i) {
                indexMap = indexMap.add(n, this.indexMap.map(i));
                ++n;
            }
            return new BulkWriteBatch(this.namespace, this.connectionDescription, this.ordered, this.writeConcern, this.bypassDocumentValidation, this.retryWrites, this.bulkWriteBatchCombiner, indexMap, this.batchType, this.command, this.payload.getNextSplit(), this.unprocessed, this.operationContext, this.comment, this.variables);
        }
        return new BulkWriteBatch(this.namespace, this.connectionDescription, this.ordered, this.writeConcern, this.bypassDocumentValidation, this.retryWrites, this.bulkWriteBatchCombiner, this.unprocessed, this.operationContext, this.comment, this.variables);
    }

    private FieldNameValidator getFieldNameValidator() {
        if (this.batchType == WriteRequest.Type.UPDATE || this.batchType == WriteRequest.Type.REPLACE) {
            Map<String, FieldNameValidator> map = this.batchType == WriteRequest.Type.REPLACE ? Collections.singletonMap("u", ReplacingDocumentFieldNameValidator.INSTANCE) : Collections.singletonMap("u", new UpdateFieldNameValidator());
            return new MappedFieldNameValidator(NoOpFieldNameValidator.INSTANCE, map);
        }
        return NoOpFieldNameValidator.INSTANCE;
    }

    private BulkWriteResult getBulkWriteResult(BsonDocument bsonDocument) {
        int n = bsonDocument.getNumber("n").intValue();
        List<BulkWriteInsert> list = this.getInsertedItems(bsonDocument);
        List<BulkWriteUpsert> list2 = this.getUpsertedItems(bsonDocument);
        return BulkWriteResult.acknowledged(this.batchType, n - list2.size(), this.getModifiedCount(bsonDocument), list2, list);
    }

    private List<BulkWriteInsert> getInsertedItems(BsonDocument bsonDocument) {
        Set set = this.getWriteErrors(bsonDocument).stream().map(BulkWriteError::getIndex).collect(Collectors.toSet());
        return this.payload.getInsertedIds().entrySet().stream().filter(entry -> !set.contains(entry.getKey())).map(entry -> new BulkWriteInsert((Integer)entry.getKey(), (BsonValue)entry.getValue())).collect(Collectors.toList());
    }

    private List<BulkWriteUpsert> getUpsertedItems(BsonDocument bsonDocument) {
        BsonArray bsonArray = bsonDocument.getArray("upserted", new BsonArray());
        ArrayList<BulkWriteUpsert> arrayList = new ArrayList<BulkWriteUpsert>();
        for (BsonValue bsonValue : bsonArray) {
            BsonDocument bsonDocument2 = (BsonDocument)bsonValue;
            arrayList.add(new BulkWriteUpsert(this.indexMap.map(bsonDocument2.getNumber("index").intValue()), bsonDocument2.get("_id")));
        }
        return arrayList;
    }

    private int getModifiedCount(BsonDocument bsonDocument) {
        return bsonDocument.getNumber("nModified", new BsonInt32(0)).intValue();
    }

    private boolean hasError(BsonDocument bsonDocument) {
        return bsonDocument.get("writeErrors") != null || bsonDocument.get("writeConcernError") != null;
    }

    private MongoBulkWriteException getBulkWriteException(BsonDocument bsonDocument) {
        if (!this.hasError(bsonDocument)) {
            throw new MongoInternalException("This method should not have been called");
        }
        return new MongoBulkWriteException(this.getBulkWriteResult(bsonDocument), this.getWriteErrors(bsonDocument), this.getWriteConcernError(bsonDocument), this.connectionDescription.getServerAddress(), bsonDocument.getArray("errorLabels", new BsonArray()).stream().map(bsonValue -> bsonValue.asString().getValue()).collect(Collectors.toSet()));
    }

    private List<BulkWriteError> getWriteErrors(BsonDocument bsonDocument) {
        ArrayList<BulkWriteError> arrayList = new ArrayList<BulkWriteError>();
        BsonArray bsonArray = (BsonArray)bsonDocument.get("writeErrors");
        if (bsonArray != null) {
            for (BsonValue bsonValue : bsonArray) {
                BsonDocument bsonDocument2 = (BsonDocument)bsonValue;
                arrayList.add(new BulkWriteError(bsonDocument2.getNumber("code").intValue(), bsonDocument2.getString("errmsg").getValue(), bsonDocument2.getDocument("errInfo", new BsonDocument()), bsonDocument2.getNumber("index").intValue()));
            }
        }
        return arrayList;
    }

    @Nullable
    private WriteConcernError getWriteConcernError(BsonDocument bsonDocument) {
        BsonDocument bsonDocument2 = (BsonDocument)bsonDocument.get("writeConcernError");
        if (bsonDocument2 == null) {
            return null;
        }
        return WriteConcernHelper.createWriteConcernError(bsonDocument2);
    }

    private String getCommandName(WriteRequest.Type type) {
        if (type == WriteRequest.Type.INSERT) {
            return "insert";
        }
        if (type == WriteRequest.Type.UPDATE || type == WriteRequest.Type.REPLACE) {
            return "update";
        }
        return "delete";
    }

    private SplittablePayload.Type getPayloadType(WriteRequest.Type type) {
        if (type == WriteRequest.Type.INSERT) {
            return SplittablePayload.Type.INSERT;
        }
        if (type == WriteRequest.Type.UPDATE) {
            return SplittablePayload.Type.UPDATE;
        }
        if (type == WriteRequest.Type.REPLACE) {
            return SplittablePayload.Type.REPLACE;
        }
        return SplittablePayload.Type.DELETE;
    }

    private static boolean isRetryable(WriteRequest writeRequest) {
        if (writeRequest.getType() == WriteRequest.Type.UPDATE || writeRequest.getType() == WriteRequest.Type.REPLACE) {
            return !((UpdateRequest)writeRequest).isMulti();
        }
        if (writeRequest.getType() == WriteRequest.Type.DELETE) {
            return !((DeleteRequest)writeRequest).isMulti();
        }
        return true;
    }

    static void logWriteModelDoesNotSupportRetries() {
        OperationHelper.LOGGER.debug("retryWrites set but one or more writeRequests do not support retryable writes");
    }
}

