/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoChangeStreamException;
import com.mongodb.MongoException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AggregateResponseBatchCursor;
import com.mongodb.internal.operation.ChangeStreamBatchCursorHelper;
import com.mongodb.internal.operation.ChangeStreamOperation;
import com.mongodb.internal.operation.CommandBatchCursor;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.RawBsonDocument;
import org.bson.codecs.Decoder;

final class ChangeStreamBatchCursor<T>
implements AggregateResponseBatchCursor<T> {
    private final ReadBinding binding;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private final int maxWireVersion;
    private final TimeoutContext timeoutContext;
    private CommandBatchCursor<RawBsonDocument> wrapped;
    private BsonDocument resumeToken;
    private final AtomicBoolean closed;
    private boolean lastOperationTimedOut;

    ChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, CommandBatchCursor<RawBsonDocument> commandBatchCursor, ReadBinding readBinding, @Nullable BsonDocument bsonDocument, int n) {
        this.timeoutContext = readBinding.getOperationContext().getTimeoutContext();
        this.changeStreamOperation = changeStreamOperation;
        this.binding = readBinding.retain();
        this.wrapped = commandBatchCursor;
        this.resumeToken = bsonDocument;
        this.maxWireVersion = n;
        this.closed = new AtomicBoolean();
        this.lastOperationTimedOut = false;
    }

    CommandBatchCursor<RawBsonDocument> getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean hasNext() {
        return this.resumeableOperation(aggregateResponseBatchCursor -> {
            try {
                Boolean bl = aggregateResponseBatchCursor.hasNext();
                return bl;
            }
            finally {
                this.cachePostBatchResumeToken((AggregateResponseBatchCursor<RawBsonDocument>)aggregateResponseBatchCursor);
            }
        });
    }

    @Override
    public List<T> next() {
        return this.resumeableOperation(aggregateResponseBatchCursor -> {
            try {
                List<T> list = ChangeStreamBatchCursor.convertAndProduceLastId((List<RawBsonDocument>)aggregateResponseBatchCursor.next(), this.changeStreamOperation.getDecoder(), bsonDocument -> {
                    this.resumeToken = bsonDocument;
                });
                return list;
            }
            finally {
                this.cachePostBatchResumeToken((AggregateResponseBatchCursor<RawBsonDocument>)aggregateResponseBatchCursor);
            }
        });
    }

    @Override
    public int available() {
        return this.wrapped.available();
    }

    @Override
    public List<T> tryNext() {
        return this.resumeableOperation(aggregateResponseBatchCursor -> {
            try {
                List<RawBsonDocument> list = aggregateResponseBatchCursor.tryNext();
                List<T> list2 = list == null ? null : ChangeStreamBatchCursor.convertAndProduceLastId(list, this.changeStreamOperation.getDecoder(), bsonDocument -> {
                    this.resumeToken = bsonDocument;
                });
                return list2;
            }
            finally {
                this.cachePostBatchResumeToken((AggregateResponseBatchCursor<RawBsonDocument>)aggregateResponseBatchCursor);
            }
        });
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.timeoutContext.resetTimeoutIfPresent();
            this.wrapped.close();
            this.binding.release();
        }
    }

    @Override
    public void setBatchSize(int n) {
        this.wrapped.setBatchSize(n);
    }

    @Override
    public int getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    @Override
    public ServerCursor getServerCursor() {
        return this.wrapped.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.wrapped.getServerAddress();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.wrapped.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.changeStreamOperation.getStartAtOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.wrapped.isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void cachePostBatchResumeToken(AggregateResponseBatchCursor<RawBsonDocument> aggregateResponseBatchCursor) {
        if (aggregateResponseBatchCursor.getPostBatchResumeToken() != null) {
            this.resumeToken = aggregateResponseBatchCursor.getPostBatchResumeToken();
        }
    }

    static <T> List<T> convertAndProduceLastId(List<RawBsonDocument> list, Decoder<T> decoder, Consumer<BsonDocument> consumer) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (RawBsonDocument rawBsonDocument : Assertions.assertNotNull(list)) {
            if (!rawBsonDocument.containsKey("_id")) {
                throw new MongoChangeStreamException("Cannot provide resume functionality when the resume token is missing.");
            }
            arrayList.add(rawBsonDocument.decode(decoder));
        }
        if (!list.isEmpty()) {
            consumer.accept(list.get(list.size() - 1).getDocument("_id"));
        }
        return arrayList;
    }

    <R> R resumeableOperation(Function<AggregateResponseBatchCursor<RawBsonDocument>, R> function) {
        this.timeoutContext.resetTimeoutIfPresent();
        try {
            R r = this.execute(function);
            this.lastOperationTimedOut = false;
            return r;
        }
        catch (Throwable throwable) {
            this.lastOperationTimedOut = ChangeStreamBatchCursor.isTimeoutException(throwable);
            throw throwable;
        }
    }

    private <R> R execute(Function<AggregateResponseBatchCursor<RawBsonDocument>, R> function) {
        boolean bl = this.hasPreviousNextTimedOut();
        while (true) {
            if (bl) {
                this.resumeChangeStream();
            }
            try {
                return function.apply(this.wrapped);
            }
            catch (Throwable throwable) {
                if (!ChangeStreamBatchCursorHelper.isResumableError(throwable, this.maxWireVersion)) {
                    throw MongoException.fromThrowableNonNull(throwable);
                }
                bl = true;
                continue;
            }
            break;
        }
    }

    private void resumeChangeStream() {
        this.wrapped.close();
        SyncOperationHelper.withReadConnectionSource(this.binding, connectionSource -> {
            this.changeStreamOperation.setChangeStreamOptionsForResume(this.resumeToken, connectionSource.getServerDescription().getMaxWireVersion());
            return null;
        });
        this.wrapped = ((ChangeStreamBatchCursor)this.changeStreamOperation.execute(this.binding)).getWrapped();
        this.binding.release();
    }

    private boolean hasPreviousNextTimedOut() {
        return this.lastOperationTimedOut && !this.closed.get();
    }

    private static boolean isTimeoutException(Throwable throwable) {
        return throwable instanceof MongoOperationTimeoutException;
    }
}

