/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.CursorType;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.AggregateOperationImpl;
import com.mongodb.internal.operation.AsyncChangeStreamBatchCursor;
import com.mongodb.internal.operation.AsyncCommandBatchCursor;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ChangeStreamBatchCursor;
import com.mongodb.internal.operation.CommandBatchCursor;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.codecs.Decoder;
import org.bson.codecs.RawBsonDocumentCodec;

public class ChangeStreamOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final RawBsonDocumentCodec RAW_BSON_DOCUMENT_CODEC = new RawBsonDocumentCodec();
    private final AggregateOperationImpl<RawBsonDocument> wrapped;
    private final FullDocument fullDocument;
    private final FullDocumentBeforeChange fullDocumentBeforeChange;
    private final Decoder<T> decoder;
    private final ChangeStreamLevel changeStreamLevel;
    private BsonDocument resumeAfter;
    private BsonDocument startAfter;
    private BsonTimestamp startAtOperationTime;
    private boolean showExpandedEvents;

    public ChangeStreamOperation(MongoNamespace mongoNamespace, FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<BsonDocument> list, Decoder<T> decoder) {
        this(mongoNamespace, fullDocument, fullDocumentBeforeChange, list, decoder, ChangeStreamLevel.COLLECTION);
    }

    public ChangeStreamOperation(MongoNamespace mongoNamespace, FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<BsonDocument> list, Decoder<T> decoder, ChangeStreamLevel changeStreamLevel) {
        this.wrapped = new AggregateOperationImpl<RawBsonDocument>(mongoNamespace, list, RAW_BSON_DOCUMENT_CODEC, this.getAggregateTarget(), this.getPipelineCreator()).cursorType(CursorType.TailableAwait);
        this.fullDocument = Assertions.notNull("fullDocument", fullDocument);
        this.fullDocumentBeforeChange = Assertions.notNull("fullDocumentBeforeChange", fullDocumentBeforeChange);
        this.decoder = Assertions.notNull("decoder", decoder);
        this.changeStreamLevel = Assertions.notNull("changeStreamLevel", changeStreamLevel);
    }

    public MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public FullDocument getFullDocument() {
        return this.fullDocument;
    }

    public BsonDocument getResumeAfter() {
        return this.resumeAfter;
    }

    public ChangeStreamOperation<T> resumeAfter(BsonDocument bsonDocument) {
        this.resumeAfter = bsonDocument;
        return this;
    }

    public BsonDocument getStartAfter() {
        return this.startAfter;
    }

    public ChangeStreamOperation<T> startAfter(BsonDocument bsonDocument) {
        this.startAfter = bsonDocument;
        return this;
    }

    public List<BsonDocument> getPipeline() {
        return this.wrapped.getPipeline();
    }

    public Integer getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    public ChangeStreamOperation<T> batchSize(@Nullable Integer n) {
        this.wrapped.batchSize(n);
        return this;
    }

    public Collation getCollation() {
        return this.wrapped.getCollation();
    }

    public ChangeStreamOperation<T> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    public ChangeStreamOperation<T> startAtOperationTime(BsonTimestamp bsonTimestamp) {
        this.startAtOperationTime = bsonTimestamp;
        return this;
    }

    public BsonTimestamp getStartAtOperationTime() {
        return this.startAtOperationTime;
    }

    public ChangeStreamOperation<T> retryReads(boolean bl) {
        this.wrapped.retryReads(bl);
        return this;
    }

    public boolean getRetryReads() {
        return this.wrapped.getRetryReads();
    }

    @Nullable
    public BsonValue getComment() {
        return this.wrapped.getComment();
    }

    public ChangeStreamOperation<T> comment(BsonValue bsonValue) {
        this.wrapped.comment(bsonValue);
        return this;
    }

    public boolean getShowExpandedEvents() {
        return this.showExpandedEvents;
    }

    public ChangeStreamOperation<T> showExpandedEvents(boolean bl) {
        this.showExpandedEvents = bl;
        return this;
    }

    private AggregateOperationImpl<RawBsonDocument> getAggregateOperation(TimeoutContext timeoutContext) {
        if (timeoutContext.hasTimeoutMS()) {
            return this.wrapped.timeoutMode(TimeoutMode.CURSOR_LIFETIME);
        }
        return this.wrapped;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding readBinding) {
        TimeoutContext timeoutContext = readBinding.getOperationContext().getTimeoutContext();
        CommandBatchCursor<RawBsonDocument> commandBatchCursor = ((CommandBatchCursor)this.getAggregateOperation(timeoutContext).execute(readBinding)).disableTimeoutResetWhenClosing();
        return new ChangeStreamBatchCursor(this, commandBatchCursor, readBinding, this.setChangeStreamOptions(commandBatchCursor.getPostBatchResumeToken(), commandBatchCursor.getOperationTime(), commandBatchCursor.getMaxWireVersion(), commandBatchCursor.isFirstBatchEmpty()), commandBatchCursor.getMaxWireVersion());
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<AsyncBatchCursor<T>> singleResultCallback) {
        TimeoutContext timeoutContext = asyncReadBinding.getOperationContext().getTimeoutContext();
        this.getAggregateOperation(timeoutContext).executeAsync(asyncReadBinding, (asyncBatchCursor, throwable) -> {
            if (throwable != null) {
                singleResultCallback.onResult(null, throwable);
            } else {
                AsyncCommandBatchCursor<RawBsonDocument> asyncCommandBatchCursor = ((AsyncCommandBatchCursor)Assertions.assertNotNull(asyncBatchCursor)).disableTimeoutResetWhenClosing();
                singleResultCallback.onResult(new AsyncChangeStreamBatchCursor(this, asyncCommandBatchCursor, asyncReadBinding, this.setChangeStreamOptions(asyncCommandBatchCursor.getPostBatchResumeToken(), asyncCommandBatchCursor.getOperationTime(), asyncCommandBatchCursor.getMaxWireVersion(), asyncCommandBatchCursor.isFirstBatchEmpty()), asyncCommandBatchCursor.getMaxWireVersion()), null);
            }
        });
    }

    @Nullable
    private BsonDocument setChangeStreamOptions(@Nullable BsonDocument bsonDocument, @Nullable BsonTimestamp bsonTimestamp, int n, boolean bl) {
        BsonDocument bsonDocument2 = null;
        if (this.startAfter != null) {
            bsonDocument2 = this.startAfter;
        } else if (this.resumeAfter != null) {
            bsonDocument2 = this.resumeAfter;
        } else if (this.startAtOperationTime == null && bsonDocument == null && bl && n >= 7) {
            this.startAtOperationTime = bsonTimestamp;
        }
        return bsonDocument2;
    }

    public void setChangeStreamOptionsForResume(@Nullable BsonDocument bsonDocument, int n) {
        this.startAfter = null;
        if (bsonDocument != null) {
            this.startAtOperationTime = null;
            this.resumeAfter = bsonDocument;
        } else if (this.startAtOperationTime != null && n >= 7) {
            this.resumeAfter = null;
        } else {
            this.resumeAfter = null;
            this.startAtOperationTime = null;
        }
    }

    private AggregateOperationImpl.AggregateTarget getAggregateTarget() {
        return () -> this.changeStreamLevel == ChangeStreamLevel.COLLECTION ? new BsonString(this.getNamespace().getCollectionName()) : new BsonInt32(1);
    }

    private AggregateOperationImpl.PipelineCreator getPipelineCreator() {
        return () -> {
            ArrayList<BsonDocument> arrayList = new ArrayList<BsonDocument>();
            BsonDocument bsonDocument = new BsonDocument();
            if (this.fullDocument != FullDocument.DEFAULT) {
                bsonDocument.append("fullDocument", new BsonString(this.fullDocument.getValue()));
            }
            if (this.fullDocumentBeforeChange != FullDocumentBeforeChange.DEFAULT) {
                bsonDocument.append("fullDocumentBeforeChange", new BsonString(this.fullDocumentBeforeChange.getValue()));
            }
            if (this.changeStreamLevel == ChangeStreamLevel.CLIENT) {
                bsonDocument.append("allChangesForCluster", BsonBoolean.TRUE);
            }
            if (this.showExpandedEvents) {
                bsonDocument.append("showExpandedEvents", BsonBoolean.TRUE);
            }
            if (this.resumeAfter != null) {
                bsonDocument.append("resumeAfter", this.resumeAfter);
            }
            if (this.startAfter != null) {
                bsonDocument.append("startAfter", this.startAfter);
            }
            if (this.startAtOperationTime != null) {
                bsonDocument.append("startAtOperationTime", this.startAtOperationTime);
            }
            arrayList.add(new BsonDocument("$changeStream", bsonDocument));
            arrayList.addAll(this.getPipeline());
            return new BsonArray(arrayList);
        };
    }
}

