/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ClientBulkWriteException;
import com.mongodb.MongoClientException;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoServerException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientDeleteResult;
import com.mongodb.client.model.bulk.ClientInsertOneResult;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.client.model.bulk.ClientUpdateResult;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.AsyncSupplier;
import com.mongodb.internal.async.MutableValue;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.client.model.bulk.AbstractClientDeleteModel;
import com.mongodb.internal.client.model.bulk.AbstractClientDeleteOptions;
import com.mongodb.internal.client.model.bulk.AbstractClientNamespacedWriteModel;
import com.mongodb.internal.client.model.bulk.AbstractClientUpdateModel;
import com.mongodb.internal.client.model.bulk.AbstractClientUpdateOptions;
import com.mongodb.internal.client.model.bulk.AcknowledgedSummaryClientBulkWriteResult;
import com.mongodb.internal.client.model.bulk.AcknowledgedVerboseClientBulkWriteResult;
import com.mongodb.internal.client.model.bulk.ClientWriteModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientBulkWriteOptions;
import com.mongodb.internal.client.model.bulk.ConcreteClientDeleteManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientDeleteOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientDeleteResult;
import com.mongodb.internal.client.model.bulk.ConcreteClientInsertOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientInsertOneResult;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedDeleteManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedDeleteOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedInsertOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedReplaceOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedUpdateManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedUpdateOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientReplaceOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientReplaceOneOptions;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateOneOptions;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateResult;
import com.mongodb.internal.client.model.bulk.UnacknowledgedClientBulkWriteResult;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.DualMessageSequences;
import com.mongodb.internal.connection.IdHoldingBsonWriter;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.BulkWriteBatch;
import com.mongodb.internal.operation.CommandBatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.operation.retry.AttachmentKeys;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.internal.validator.ReplacingDocumentFieldNameValidator;
import com.mongodb.internal.validator.UpdateFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonArray;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.FieldNameValidator;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public final class ClientBulkWriteOperation
implements WriteOperation<ClientBulkWriteResult>,
AsyncWriteOperation<ClientBulkWriteResult> {
    private static final ConcreteClientBulkWriteOptions EMPTY_OPTIONS = new ConcreteClientBulkWriteOptions();
    private static final String BULK_WRITE_COMMAND_NAME = "bulkWrite";
    private static final EncoderContext DEFAULT_ENCODER_CONTEXT = EncoderContext.builder().build();
    private static final EncoderContext COLLECTIBLE_DOCUMENT_ENCODER_CONTEXT = EncoderContext.builder().isEncodingCollectibleDocument(true).build();
    private static final int INITIAL_BATCH_MODEL_START_INDEX = 0;
    private static final int SERVER_DEFAULT_CURSOR_BATCH_SIZE = 0;
    private final List<? extends ClientNamespacedWriteModel> models;
    private final ConcreteClientBulkWriteOptions options;
    private final WriteConcern writeConcernSetting;
    private final boolean retryWritesSetting;
    private final CodecRegistry codecRegistry;

    public ClientBulkWriteOperation(List<? extends ClientNamespacedWriteModel> list, @Nullable ClientBulkWriteOptions clientBulkWriteOptions, WriteConcern writeConcern, boolean bl, CodecRegistry codecRegistry) {
        this.models = list;
        this.options = clientBulkWriteOptions == null ? EMPTY_OPTIONS : (ConcreteClientBulkWriteOptions)clientBulkWriteOptions;
        this.writeConcernSetting = writeConcern;
        this.retryWritesSetting = bl;
        this.codecRegistry = codecRegistry;
    }

    @Override
    public ClientBulkWriteResult execute(WriteBinding writeBinding) throws ClientBulkWriteException {
        WriteConcern writeConcern = this.validateAndGetEffectiveWriteConcern(writeBinding.getOperationContext().getSessionContext());
        ResultAccumulator resultAccumulator = new ResultAccumulator();
        MongoException mongoException = null;
        try {
            this.executeAllBatches(writeConcern, writeBinding, resultAccumulator);
        }
        catch (MongoException mongoException2) {
            mongoException = CommandOperationHelper.transformWriteException(mongoException2);
        }
        return resultAccumulator.build(mongoException, writeConcern);
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<ClientBulkWriteResult> singleResultCallback2) {
        WriteConcern writeConcern = this.validateAndGetEffectiveWriteConcern(asyncWriteBinding.getOperationContext().getSessionContext());
        ResultAccumulator resultAccumulator = new ResultAccumulator();
        MutableValue mutableValue = new MutableValue();
        AsyncRunnable.beginAsync().thenSupply(singleResultCallback -> this.executeAllBatchesAsync(writeConcern, asyncWriteBinding, resultAccumulator, singleResultCallback)).onErrorIf(throwable -> throwable instanceof MongoException, (throwable, singleResultCallback) -> {
            mutableValue.set(CommandOperationHelper.transformWriteException((MongoException)throwable));
            singleResultCallback.complete(singleResultCallback);
        }).thenApply((void_, singleResultCallback) -> singleResultCallback.complete(resultAccumulator.build((MongoException)mutableValue.getNullable(), writeConcern))).finish(singleResultCallback2);
    }

    private void executeAllBatches(WriteConcern writeConcern, WriteBinding writeBinding, ResultAccumulator resultAccumulator) throws MongoException {
        Integer n = 0;
        while ((n = this.executeBatch(n, writeConcern, writeBinding, resultAccumulator)) != null) {
        }
    }

    private void executeAllBatchesAsync(WriteConcern writeConcern, AsyncWriteBinding asyncWriteBinding, ResultAccumulator resultAccumulator, SingleResultCallback<Void> singleResultCallback) {
        MutableValue<Integer> mutableValue = new MutableValue<Integer>(0);
        AsyncRunnable.beginAsync().thenRunDoWhileLoop(singleResultCallback2 -> AsyncRunnable.beginAsync().thenSupply(singleResultCallback -> this.executeBatchAsync((Integer)mutableValue.get(), writeConcern, asyncWriteBinding, resultAccumulator, singleResultCallback)).thenApply((n, singleResultCallback) -> {
            mutableValue.set((Integer)n);
            singleResultCallback.complete(singleResultCallback);
        }).finish(singleResultCallback2), () -> mutableValue.getNullable() != null).finish(singleResultCallback);
    }

    @Nullable
    private Integer executeBatch(int n, WriteConcern writeConcern, WriteBinding writeBinding, ResultAccumulator resultAccumulator) {
        List<? extends ClientNamespacedWriteModel> list = this.models.subList(n, this.models.size());
        Assertions.assertFalse(list.isEmpty());
        OperationContext operationContext = writeBinding.getOperationContext();
        SessionContext sessionContext = operationContext.getSessionContext();
        TimeoutContext timeoutContext = operationContext.getTimeoutContext();
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryWritesSetting, timeoutContext);
        BatchEncoder batchEncoder = new BatchEncoder();
        Supplier<ExhaustiveClientBulkWriteCommandOkResponse> supplier = SyncOperationHelper.decorateWriteWithRetries(retryState, operationContext, () -> SyncOperationHelper.withSourceAndConnection(writeBinding::getWriteConnectionSource, true, (connectionSource, connection) -> {
            ConnectionDescription connectionDescription = connection.getDescription();
            boolean bl = OperationHelper.isRetryableWrite(this.retryWritesSetting, writeConcern, connectionDescription, sessionContext);
            retryState.breakAndThrowIfRetryAnd(() -> !bl);
            resultAccumulator.onNewServerAddress(connectionDescription.getServerAddress());
            retryState.attach(AttachmentKeys.maxWireVersion(), connectionDescription.getMaxWireVersion(), true).attach(AttachmentKeys.commandDescriptionSupplier(), () -> BULK_WRITE_COMMAND_NAME, false);
            ClientBulkWriteCommand clientBulkWriteCommand = this.createBulkWriteCommand(retryState, bl, writeConcern, sessionContext, list, batchEncoder, () -> retryState.attach(AttachmentKeys.retryableCommandFlag(), true, true));
            return this.executeBulkWriteCommandAndExhaustOkResponse(retryState, (ConnectionSource)connectionSource, (Connection)connection, clientBulkWriteCommand, writeConcern, operationContext);
        }));
        try {
            ExhaustiveClientBulkWriteCommandOkResponse exhaustiveClientBulkWriteCommandOkResponse = supplier.get();
            return resultAccumulator.onBulkWriteCommandOkResponseOrNoResponse(n, exhaustiveClientBulkWriteCommandOkResponse, batchEncoder.intoEncodedBatchInfo());
        }
        catch (MongoWriteConcernWithResponseException mongoWriteConcernWithResponseException) {
            return resultAccumulator.onBulkWriteCommandOkResponseWithWriteConcernError(n, mongoWriteConcernWithResponseException, batchEncoder.intoEncodedBatchInfo());
        }
        catch (MongoCommandException mongoCommandException) {
            resultAccumulator.onBulkWriteCommandErrorResponse(mongoCommandException);
            throw mongoCommandException;
        }
        catch (MongoException mongoException) {
            CommandOperationHelper.shouldAttemptToRetryWriteAndAddRetryableLabel(retryState, mongoException);
            resultAccumulator.onBulkWriteCommandErrorWithoutResponse(mongoException);
            throw mongoException;
        }
    }

    private void executeBatchAsync(int n, WriteConcern writeConcern, AsyncWriteBinding asyncWriteBinding, ResultAccumulator resultAccumulator, SingleResultCallback<Integer> singleResultCallback3) {
        List<? extends ClientNamespacedWriteModel> list = this.models.subList(n, this.models.size());
        Assertions.assertFalse(list.isEmpty());
        OperationContext operationContext = asyncWriteBinding.getOperationContext();
        SessionContext sessionContext = operationContext.getSessionContext();
        TimeoutContext timeoutContext = operationContext.getTimeoutContext();
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryWritesSetting, timeoutContext);
        BatchEncoder batchEncoder = new BatchEncoder();
        AsyncCallbackSupplier asyncCallbackSupplier = AsyncOperationHelper.decorateWriteWithRetriesAsync(retryState, operationContext, singleResultCallback2 -> AsyncOperationHelper.withAsyncSourceAndConnection(asyncWriteBinding::getWriteConnectionSource, true, singleResultCallback2, (asyncConnectionSource, asyncConnection, singleResultCallback) -> {
            ConnectionDescription connectionDescription = asyncConnection.getDescription();
            boolean bl = OperationHelper.isRetryableWrite(this.retryWritesSetting, writeConcern, connectionDescription, sessionContext);
            retryState.breakAndThrowIfRetryAnd(() -> !bl);
            resultAccumulator.onNewServerAddress(connectionDescription.getServerAddress());
            retryState.attach(AttachmentKeys.maxWireVersion(), connectionDescription.getMaxWireVersion(), true).attach(AttachmentKeys.commandDescriptionSupplier(), () -> BULK_WRITE_COMMAND_NAME, false);
            ClientBulkWriteCommand clientBulkWriteCommand = this.createBulkWriteCommand(retryState, bl, writeConcern, sessionContext, list, batchEncoder, () -> retryState.attach(AttachmentKeys.retryableCommandFlag(), true, true));
            this.executeBulkWriteCommandAndExhaustOkResponseAsync(retryState, (AsyncConnectionSource)asyncConnectionSource, (AsyncConnection)asyncConnection, clientBulkWriteCommand, writeConcern, operationContext, singleResultCallback);
        }));
        AsyncRunnable.beginAsync().thenSupply(singleResultCallback -> asyncCallbackSupplier.get(singleResultCallback)).thenApply((exhaustiveClientBulkWriteCommandOkResponse, singleResultCallback) -> singleResultCallback.complete(resultAccumulator.onBulkWriteCommandOkResponseOrNoResponse(n, (ExhaustiveClientBulkWriteCommandOkResponse)exhaustiveClientBulkWriteCommandOkResponse, batchEncoder.intoEncodedBatchInfo()))).onErrorIf(throwable -> true, (throwable, singleResultCallback) -> {
            if (throwable instanceof MongoWriteConcernWithResponseException) {
                MongoWriteConcernWithResponseException mongoWriteConcernWithResponseException = (MongoWriteConcernWithResponseException)throwable;
                singleResultCallback.complete(resultAccumulator.onBulkWriteCommandOkResponseWithWriteConcernError(n, mongoWriteConcernWithResponseException, batchEncoder.intoEncodedBatchInfo()));
            } else if (throwable instanceof MongoCommandException) {
                MongoCommandException mongoCommandException = (MongoCommandException)throwable;
                resultAccumulator.onBulkWriteCommandErrorResponse(mongoCommandException);
                singleResultCallback.completeExceptionally((Throwable)throwable);
            } else if (throwable instanceof MongoException) {
                MongoException mongoException = (MongoException)throwable;
                CommandOperationHelper.shouldAttemptToRetryWriteAndAddRetryableLabel(retryState, mongoException);
                resultAccumulator.onBulkWriteCommandErrorWithoutResponse(mongoException);
                singleResultCallback.completeExceptionally(mongoException);
            } else {
                singleResultCallback.completeExceptionally((Throwable)throwable);
            }
        }).finish(singleResultCallback3);
    }

    @Nullable
    private ExhaustiveClientBulkWriteCommandOkResponse executeBulkWriteCommandAndExhaustOkResponse(RetryState retryState, ConnectionSource connectionSource, Connection connection, ClientBulkWriteCommand clientBulkWriteCommand, WriteConcern writeConcern, OperationContext operationContext) throws MongoWriteConcernWithResponseException {
        BsonDocument bsonDocument = connection.command("admin", clientBulkWriteCommand.getCommandDocument(), NoOpFieldNameValidator.INSTANCE, null, CommandResultDocumentCodec.create(this.codecRegistry.get(BsonDocument.class), "firstBatch"), operationContext, writeConcern.isAcknowledged(), clientBulkWriteCommand.getOpsAndNsInfo());
        if (bsonDocument == null) {
            return null;
        }
        List list = this.doWithRetriesDisabledForCommand(retryState, "getMore", () -> this.exhaustBulkWriteCommandOkResponseCursor(connectionSource, connection, bsonDocument));
        return ClientBulkWriteOperation.createExhaustiveClientBulkWriteCommandOkResponse(bsonDocument, list, connection.getDescription());
    }

    private void executeBulkWriteCommandAndExhaustOkResponseAsync(RetryState retryState, AsyncConnectionSource asyncConnectionSource, AsyncConnection asyncConnection, ClientBulkWriteCommand clientBulkWriteCommand, WriteConcern writeConcern, OperationContext operationContext, SingleResultCallback<ExhaustiveClientBulkWriteCommandOkResponse> singleResultCallback2) {
        AsyncRunnable.beginAsync().thenSupply(singleResultCallback -> asyncConnection.commandAsync("admin", clientBulkWriteCommand.getCommandDocument(), NoOpFieldNameValidator.INSTANCE, null, CommandResultDocumentCodec.create(this.codecRegistry.get(BsonDocument.class), "firstBatch"), operationContext, writeConcern.isAcknowledged(), clientBulkWriteCommand.getOpsAndNsInfo(), singleResultCallback)).thenApply((bsonDocument, singleResultCallback3) -> {
            if (bsonDocument == null) {
                singleResultCallback3.complete((ExhaustiveClientBulkWriteCommandOkResponse)null);
                return;
            }
            AsyncRunnable.beginAsync().thenSupply(singleResultCallback2 -> this.doWithRetriesDisabledForCommandAsync(retryState, "getMore", singleResultCallback -> this.exhaustBulkWriteCommandOkResponseCursorAsync(asyncConnectionSource, asyncConnection, (BsonDocument)bsonDocument, singleResultCallback), singleResultCallback2)).thenApply((list, singleResultCallback) -> singleResultCallback.complete(ClientBulkWriteOperation.createExhaustiveClientBulkWriteCommandOkResponse(bsonDocument, list, asyncConnection.getDescription()))).finish(singleResultCallback3);
        }).finish(singleResultCallback2);
    }

    private static ExhaustiveClientBulkWriteCommandOkResponse createExhaustiveClientBulkWriteCommandOkResponse(BsonDocument bsonDocument, List<List<BsonDocument>> list, ConnectionDescription connectionDescription) {
        ExhaustiveClientBulkWriteCommandOkResponse exhaustiveClientBulkWriteCommandOkResponse = new ExhaustiveClientBulkWriteCommandOkResponse(bsonDocument, list);
        MongoWriteConcernException mongoWriteConcernException = Exceptions.createWriteConcernException(bsonDocument, connectionDescription.getServerAddress());
        if (mongoWriteConcernException != null) {
            throw new MongoWriteConcernWithResponseException(mongoWriteConcernException, exhaustiveClientBulkWriteCommandOkResponse);
        }
        return exhaustiveClientBulkWriteCommandOkResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R doWithRetriesDisabledForCommand(RetryState retryState, String string, Supplier<R> supplier) {
        Optional<Boolean> optional = retryState.attachment(AttachmentKeys.retryableCommandFlag());
        Supplier<String> supplier2 = retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).orElseThrow(Assertions::fail);
        try {
            retryState.attach(AttachmentKeys.retryableCommandFlag(), false, true).attach(AttachmentKeys.commandDescriptionSupplier(), () -> string, false);
            R r = supplier.get();
            return r;
        }
        finally {
            optional.ifPresent(bl -> retryState.attach(AttachmentKeys.retryableCommandFlag(), bl, true));
            retryState.attach(AttachmentKeys.commandDescriptionSupplier(), supplier2, false);
        }
    }

    private <R> void doWithRetriesDisabledForCommandAsync(RetryState retryState, String string, AsyncSupplier<R> asyncSupplier, SingleResultCallback<R> singleResultCallback2) {
        Optional<Boolean> optional = retryState.attachment(AttachmentKeys.retryableCommandFlag());
        Supplier<String> supplier = retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).orElseThrow(Assertions::fail);
        AsyncRunnable.beginAsync().thenSupply(singleResultCallback -> {
            retryState.attach(AttachmentKeys.retryableCommandFlag(), false, true).attach(AttachmentKeys.commandDescriptionSupplier(), () -> string, false);
            asyncSupplier.finish(singleResultCallback);
        }).thenAlwaysRunAndFinish(() -> {
            optional.ifPresent(bl -> retryState.attach(AttachmentKeys.retryableCommandFlag(), bl, true));
            retryState.attach(AttachmentKeys.commandDescriptionSupplier(), supplier, false);
        }, singleResultCallback2);
    }

    private List<List<BsonDocument>> exhaustBulkWriteCommandOkResponseCursor(ConnectionSource connectionSource, Connection connection, BsonDocument bsonDocument) {
        try (CommandBatchCursor<BsonDocument> commandBatchCursor = SyncOperationHelper.cursorDocumentToBatchCursor(TimeoutMode.CURSOR_LIFETIME, bsonDocument, 0, this.codecRegistry.get(BsonDocument.class), this.options.getComment().orElse(null), connectionSource, connection);){
            List<List<BsonDocument>> list = commandBatchCursor.exhaust();
            return list;
        }
    }

    private void exhaustBulkWriteCommandOkResponseCursorAsync(AsyncConnectionSource asyncConnectionSource, AsyncConnection asyncConnection, BsonDocument bsonDocument, SingleResultCallback<List<List<BsonDocument>>> singleResultCallback2) {
        AsyncBatchCursor<BsonDocument> asyncBatchCursor = AsyncOperationHelper.cursorDocumentToAsyncBatchCursor(TimeoutMode.CURSOR_LIFETIME, bsonDocument, 0, this.codecRegistry.get(BsonDocument.class), this.options.getComment().orElse(null), asyncConnectionSource, asyncConnection);
        AsyncRunnable.beginAsync().thenSupply(singleResultCallback -> asyncBatchCursor.exhaust(singleResultCallback)).thenAlwaysRunAndFinish(() -> asyncBatchCursor.close(), singleResultCallback2);
    }

    private ClientBulkWriteCommand createBulkWriteCommand(RetryState retryState, boolean bl2, WriteConcern writeConcern2, SessionContext sessionContext, List<? extends ClientNamespacedWriteModel> list, BatchEncoder batchEncoder, Runnable runnable) {
        BsonDocument bsonDocument = new BsonDocument(BULK_WRITE_COMMAND_NAME, new BsonInt32(1)).append("errorsOnly", BsonBoolean.valueOf(!this.options.isVerboseResults())).append("ordered", BsonBoolean.valueOf(this.options.isOrdered()));
        this.options.isBypassDocumentValidation().ifPresent(bl -> bsonDocument.append("bypassDocumentValidation", BsonBoolean.valueOf(bl)));
        this.options.getComment().ifPresent(bsonValue -> bsonDocument.append("comment", (BsonValue)bsonValue));
        this.options.getLet().ifPresent(bson -> bsonDocument.append("let", bson.toBsonDocument(BsonDocument.class, this.codecRegistry)));
        CommandOperationHelper.commandWriteConcern(writeConcern2, sessionContext).ifPresent(writeConcern -> bsonDocument.append("writeConcern", writeConcern.asDocument()));
        return new ClientBulkWriteCommand(bsonDocument, new ClientBulkWriteCommand.OpsAndNsInfo(bl2, list, batchEncoder, this.options, () -> {
            runnable.run();
            return retryState.isFirstAttempt() ? sessionContext.advanceTransactionNumber() : sessionContext.getTransactionNumber();
        }));
    }

    private WriteConcern validateAndGetEffectiveWriteConcern(SessionContext sessionContext) {
        WriteConcern writeConcern = CommandOperationHelper.validateAndGetEffectiveWriteConcern(this.writeConcernSetting, sessionContext);
        if (!writeConcern.isAcknowledged()) {
            if (this.options.isVerboseResults()) {
                throw new MongoClientException("Cannot request unacknowledged write concern and verbose results");
            }
            if (this.options.isOrdered()) {
                throw new MongoClientException("Cannot request unacknowledged write concern and ordered writes");
            }
        }
        return writeConcern;
    }

    private <T> void encodeUsingRegistry(BsonWriter bsonWriter, T t) {
        this.encodeUsingRegistry(bsonWriter, t, DEFAULT_ENCODER_CONTEXT);
    }

    private <T> void encodeUsingRegistry(BsonWriter bsonWriter, T t, EncoderContext encoderContext) {
        Codec<?> codec = this.codecRegistry.get(t.getClass());
        codec.encode(bsonWriter, t, encoderContext);
    }

    private static AbstractClientNamespacedWriteModel getNamespacedModel(List<? extends ClientNamespacedWriteModel> list, int n) {
        return (AbstractClientNamespacedWriteModel)((Object)list.get(n));
    }

    private final class ResultAccumulator {
        @Nullable
        private ServerAddress serverAddress = null;
        private final ArrayList<BatchResult> batchResults = new ArrayList();

        ResultAccumulator() {
        }

        ClientBulkWriteResult build(@Nullable MongoException mongoException, WriteConcern writeConcern) throws MongoException {
            Object object;
            boolean bl = ClientBulkWriteOperation.this.options.isVerboseResults();
            boolean bl2 = false;
            boolean bl3 = false;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            HashMap<Integer, ClientInsertOneResult> hashMap = bl ? new HashMap<Integer, ClientInsertOneResult>() : Collections.emptyMap();
            HashMap<Integer, ClientUpdateResult> hashMap2 = bl ? new HashMap<Integer, ClientUpdateResult>() : Collections.emptyMap();
            HashMap<Integer, ClientDeleteResult> hashMap3 = bl ? new HashMap<Integer, ClientDeleteResult>() : Collections.emptyMap();
            ArrayList<WriteConcernError> arrayList = new ArrayList<WriteConcernError>();
            HashMap<Integer, WriteError> hashMap4 = new HashMap<Integer, WriteError>();
            for (BatchResult batchResult : this.batchResults) {
                if (!batchResult.hasResponse()) continue;
                bl2 = true;
                MongoWriteConcernException mongoWriteConcernException = batchResult.getWriteConcernException();
                if (mongoWriteConcernException != null) {
                    arrayList.add(mongoWriteConcernException.getWriteConcernError());
                }
                int n = batchResult.getBatchStartModelIndex();
                ExhaustiveClientBulkWriteCommandOkResponse exhaustiveClientBulkWriteCommandOkResponse = batchResult.getResponse();
                boolean bl4 = ClientBulkWriteOperation.this.options.isOrdered();
                int n2 = exhaustiveClientBulkWriteCommandOkResponse.getNErrors();
                bl3 = bl3 || bl4 && n2 == 0 || !bl4 && n2 < batchResult.getBatchModelsCount();
                l += (long)exhaustiveClientBulkWriteCommandOkResponse.getNInserted();
                l2 += (long)exhaustiveClientBulkWriteCommandOkResponse.getNUpserted();
                l3 += (long)exhaustiveClientBulkWriteCommandOkResponse.getNMatched();
                l4 += (long)exhaustiveClientBulkWriteCommandOkResponse.getNModified();
                l5 += (long)exhaustiveClientBulkWriteCommandOkResponse.getNDeleted();
                Map<Integer, BsonValue> map = batchResult.getInsertModelDocumentIds();
                for (BsonDocument bsonDocument : exhaustiveClientBulkWriteCommandOkResponse.getCursorExhaust()) {
                    Object object2;
                    int n3 = bsonDocument.getInt32("idx").getValue();
                    int n4 = n + n3;
                    if (bsonDocument.getNumber("ok").intValue() == 1) {
                        Assertions.assertTrue(bl);
                        object2 = ClientBulkWriteOperation.getNamespacedModel(ClientBulkWriteOperation.this.models, n4);
                        if (object2 instanceof ConcreteClientNamespacedInsertOneModel) {
                            hashMap.put(n4, new ConcreteClientInsertOneResult(map.get(n3)));
                            continue;
                        }
                        if (object2 instanceof ConcreteClientNamespacedUpdateOneModel || object2 instanceof ConcreteClientNamespacedUpdateManyModel || object2 instanceof ConcreteClientNamespacedReplaceOneModel) {
                            BsonDocument bsonDocument2 = bsonDocument.getDocument("upserted", null);
                            hashMap2.put(n4, new ConcreteClientUpdateResult(bsonDocument.getInt32("n").getValue(), bsonDocument.getInt32("nModified").getValue(), bsonDocument2 == null ? null : bsonDocument2.get("_id")));
                            continue;
                        }
                        if (object2 instanceof ConcreteClientNamespacedDeleteOneModel || object2 instanceof ConcreteClientNamespacedDeleteManyModel) {
                            hashMap3.put(n4, new ConcreteClientDeleteResult(bsonDocument.getInt32("n").getValue()));
                            continue;
                        }
                        Assertions.fail(object2.getClass().toString());
                        continue;
                    }
                    bl3 = bl3 || bl4 && n3 > 0;
                    object2 = new WriteError(bsonDocument.getInt32("code").getValue(), bsonDocument.getString("errmsg").getValue(), bsonDocument.getDocument("errInfo", new BsonDocument()));
                    hashMap4.put(n4, (WriteError)object2);
                }
            }
            if (mongoException == null && arrayList.isEmpty() && hashMap4.isEmpty()) {
                if (writeConcern.isAcknowledged()) {
                    object = new AcknowledgedSummaryClientBulkWriteResult(l, l2, l3, l4, l5);
                    return bl ? new AcknowledgedVerboseClientBulkWriteResult((AcknowledgedSummaryClientBulkWriteResult)object, hashMap, hashMap2, hashMap3) : object;
                }
                return UnacknowledgedClientBulkWriteResult.INSTANCE;
            }
            if (bl2) {
                object = bl3 ? new AcknowledgedSummaryClientBulkWriteResult(l, l2, l3, l4, l5) : null;
                throw new ClientBulkWriteException(mongoException, arrayList, hashMap4, (ClientBulkWriteResult)(bl && object != null ? new AcknowledgedVerboseClientBulkWriteResult((AcknowledgedSummaryClientBulkWriteResult)object, hashMap, hashMap2, hashMap3) : object), Assertions.assertNotNull(this.serverAddress));
            }
            throw Assertions.assertNotNull(mongoException);
        }

        void onNewServerAddress(ServerAddress serverAddress) {
            this.serverAddress = serverAddress;
        }

        @Nullable
        Integer onBulkWriteCommandOkResponseOrNoResponse(int n, @Nullable ExhaustiveClientBulkWriteCommandOkResponse exhaustiveClientBulkWriteCommandOkResponse, BatchEncoder.EncodedBatchInfo encodedBatchInfo) {
            return this.onBulkWriteCommandOkResponseOrNoResponse(n, exhaustiveClientBulkWriteCommandOkResponse, null, encodedBatchInfo);
        }

        @Nullable
        Integer onBulkWriteCommandOkResponseWithWriteConcernError(int n, MongoWriteConcernWithResponseException mongoWriteConcernWithResponseException, BatchEncoder.EncodedBatchInfo encodedBatchInfo) {
            MongoWriteConcernException mongoWriteConcernException = (MongoWriteConcernException)mongoWriteConcernWithResponseException.getCause();
            this.onNewServerAddress(mongoWriteConcernException.getServerAddress());
            ExhaustiveClientBulkWriteCommandOkResponse exhaustiveClientBulkWriteCommandOkResponse = (ExhaustiveClientBulkWriteCommandOkResponse)mongoWriteConcernWithResponseException.getResponse();
            return this.onBulkWriteCommandOkResponseOrNoResponse(n, exhaustiveClientBulkWriteCommandOkResponse, mongoWriteConcernException, encodedBatchInfo);
        }

        @Nullable
        private Integer onBulkWriteCommandOkResponseOrNoResponse(int n, @Nullable ExhaustiveClientBulkWriteCommandOkResponse exhaustiveClientBulkWriteCommandOkResponse, @Nullable MongoWriteConcernException mongoWriteConcernException, BatchEncoder.EncodedBatchInfo encodedBatchInfo) {
            BatchResult batchResult = exhaustiveClientBulkWriteCommandOkResponse == null ? BatchResult.noResponse(n, encodedBatchInfo) : BatchResult.okResponse(n, encodedBatchInfo, exhaustiveClientBulkWriteCommandOkResponse, mongoWriteConcernException);
            this.batchResults.add(batchResult);
            int n2 = n + batchResult.getBatchModelsCount();
            return exhaustiveClientBulkWriteCommandOkResponse == null || exhaustiveClientBulkWriteCommandOkResponse.operationMayContinue(ClientBulkWriteOperation.this.options) ? (n2 == ClientBulkWriteOperation.this.models.size() ? null : Integer.valueOf(n2)) : null;
        }

        void onBulkWriteCommandErrorResponse(MongoCommandException mongoCommandException) {
            this.onNewServerAddress(mongoCommandException.getServerAddress());
        }

        void onBulkWriteCommandErrorWithoutResponse(MongoException mongoException) {
            Exceptions.serverAddressFromException(mongoException).ifPresent(this::onNewServerAddress);
        }
    }

    public final class BatchEncoder {
        private EncodedBatchInfo encodedBatchInfo = new EncodedBatchInfo();

        EncodedBatchInfo intoEncodedBatchInfo() {
            EncodedBatchInfo encodedBatchInfo = Assertions.assertNotNull(this.encodedBatchInfo);
            this.encodedBatchInfo = null;
            Assertions.assertTrue(encodedBatchInfo.getModelsCount() > 0);
            return encodedBatchInfo;
        }

        void reset() {
            Assertions.assertNotNull(this.encodedBatchInfo).modelsCount = 0;
        }

        void reset(int n) {
            Assertions.assertNotNull(this.encodedBatchInfo).modelsCount -= 1;
            this.encodedBatchInfo.insertModelDocumentIds.remove(n);
        }

        void encodeWriteModel(BsonBinaryWriter bsonBinaryWriter, ClientWriteModel clientWriteModel, int n, int n2) {
            Assertions.assertNotNull(this.encodedBatchInfo).modelsCount++;
            bsonBinaryWriter.writeStartDocument();
            if (clientWriteModel instanceof ConcreteClientInsertOneModel) {
                bsonBinaryWriter.writeInt32("insert", n2);
                this.encodeWriteModelInternals(bsonBinaryWriter, (ConcreteClientInsertOneModel)clientWriteModel, n);
            } else if (clientWriteModel instanceof ConcreteClientUpdateOneModel) {
                bsonBinaryWriter.writeInt32("update", n2);
                bsonBinaryWriter.writeBoolean("multi", false);
                this.encodeWriteModelInternals((BsonWriter)bsonBinaryWriter, (ConcreteClientUpdateOneModel)clientWriteModel);
            } else if (clientWriteModel instanceof ConcreteClientUpdateManyModel) {
                bsonBinaryWriter.writeInt32("update", n2);
                bsonBinaryWriter.writeBoolean("multi", true);
                this.encodeWriteModelInternals((BsonWriter)bsonBinaryWriter, (ConcreteClientUpdateManyModel)clientWriteModel);
            } else if (clientWriteModel instanceof ConcreteClientReplaceOneModel) {
                bsonBinaryWriter.writeInt32("update", n2);
                this.encodeWriteModelInternals(bsonBinaryWriter, (ConcreteClientReplaceOneModel)clientWriteModel);
            } else if (clientWriteModel instanceof ConcreteClientDeleteOneModel) {
                bsonBinaryWriter.writeInt32("delete", n2);
                bsonBinaryWriter.writeBoolean("multi", false);
                this.encodeWriteModelInternals((BsonWriter)bsonBinaryWriter, (ConcreteClientDeleteOneModel)clientWriteModel);
            } else if (clientWriteModel instanceof ConcreteClientDeleteManyModel) {
                bsonBinaryWriter.writeInt32("delete", n2);
                bsonBinaryWriter.writeBoolean("multi", true);
                this.encodeWriteModelInternals((BsonWriter)bsonBinaryWriter, (ConcreteClientDeleteManyModel)clientWriteModel);
            } else {
                throw Assertions.fail(clientWriteModel.getClass().toString());
            }
            bsonBinaryWriter.writeEndDocument();
        }

        private void encodeWriteModelInternals(BsonBinaryWriter bsonBinaryWriter, ConcreteClientInsertOneModel concreteClientInsertOneModel, int n2) {
            bsonBinaryWriter.writeName("document");
            Object object = concreteClientInsertOneModel.getDocument();
            Assertions.assertNotNull(this.encodedBatchInfo).insertModelDocumentIds.compute(n2, (n, bsonValue) -> {
                IdHoldingBsonWriter idHoldingBsonWriter = new IdHoldingBsonWriter((BsonWriter)bsonBinaryWriter, bsonValue instanceof BsonObjectId ? bsonValue.asObjectId() : null);
                ClientBulkWriteOperation.this.encodeUsingRegistry(idHoldingBsonWriter, object, COLLECTIBLE_DOCUMENT_ENCODER_CONTEXT);
                return idHoldingBsonWriter.getId();
            });
        }

        private void encodeWriteModelInternals(BsonWriter bsonWriter, ConcreteClientUpdateOneModel concreteClientUpdateOneModel) {
            this.encodeWriteModelInternals(bsonWriter, (AbstractClientUpdateModel<?>)concreteClientUpdateOneModel);
            ((ConcreteClientUpdateOneOptions)concreteClientUpdateOneModel.getOptions()).getSort().ifPresent(bson -> {
                bsonWriter.writeName("sort");
                ClientBulkWriteOperation.this.encodeUsingRegistry(bsonWriter, bson);
            });
        }

        private void encodeWriteModelInternals(BsonWriter bsonWriter, AbstractClientUpdateModel<?> abstractClientUpdateModel) {
            bsonWriter.writeName("filter");
            ClientBulkWriteOperation.this.encodeUsingRegistry(bsonWriter, abstractClientUpdateModel.getFilter());
            abstractClientUpdateModel.getUpdate().ifPresent(bson -> {
                bsonWriter.writeName("updateMods");
                ClientBulkWriteOperation.this.encodeUsingRegistry(bsonWriter, bson);
            });
            abstractClientUpdateModel.getUpdatePipeline().ifPresent(iterable -> {
                bsonWriter.writeStartArray("updateMods");
                iterable.forEach(bson -> ClientBulkWriteOperation.this.encodeUsingRegistry(bsonWriter, bson));
                bsonWriter.writeEndArray();
            });
            Object obj = abstractClientUpdateModel.getOptions();
            ((AbstractClientUpdateOptions)obj).getArrayFilters().ifPresent(iterable -> {
                bsonWriter.writeStartArray("arrayFilters");
                iterable.forEach(bson -> ClientBulkWriteOperation.this.encodeUsingRegistry(bsonWriter, bson));
                bsonWriter.writeEndArray();
            });
            ((AbstractClientUpdateOptions)obj).getCollation().ifPresent(collation -> {
                bsonWriter.writeName("collation");
                ClientBulkWriteOperation.this.encodeUsingRegistry(bsonWriter, collation.asDocument());
            });
            ((AbstractClientUpdateOptions)obj).getHint().ifPresent(bson -> {
                bsonWriter.writeName("hint");
                ClientBulkWriteOperation.this.encodeUsingRegistry(bsonWriter, bson);
            });
            ((AbstractClientUpdateOptions)obj).getHintString().ifPresent(string -> bsonWriter.writeString("hint", (String)string));
            ((AbstractClientUpdateOptions)obj).isUpsert().ifPresent(bl -> bsonWriter.writeBoolean("upsert", (boolean)bl));
        }

        private void encodeWriteModelInternals(BsonBinaryWriter bsonBinaryWriter, ConcreteClientReplaceOneModel concreteClientReplaceOneModel) {
            bsonBinaryWriter.writeBoolean("multi", false);
            bsonBinaryWriter.writeName("filter");
            ClientBulkWriteOperation.this.encodeUsingRegistry(bsonBinaryWriter, concreteClientReplaceOneModel.getFilter());
            bsonBinaryWriter.writeName("updateMods");
            ClientBulkWriteOperation.this.encodeUsingRegistry(bsonBinaryWriter, concreteClientReplaceOneModel.getReplacement(), COLLECTIBLE_DOCUMENT_ENCODER_CONTEXT);
            ConcreteClientReplaceOneOptions concreteClientReplaceOneOptions = concreteClientReplaceOneModel.getOptions();
            concreteClientReplaceOneOptions.getCollation().ifPresent(collation -> {
                bsonBinaryWriter.writeName("collation");
                ClientBulkWriteOperation.this.encodeUsingRegistry(bsonBinaryWriter, collation.asDocument());
            });
            concreteClientReplaceOneOptions.getHint().ifPresent(bson -> {
                bsonBinaryWriter.writeName("hint");
                ClientBulkWriteOperation.this.encodeUsingRegistry(bsonBinaryWriter, bson);
            });
            concreteClientReplaceOneOptions.getHintString().ifPresent(string -> bsonBinaryWriter.writeString("hint", (String)string));
            concreteClientReplaceOneOptions.isUpsert().ifPresent(bl -> bsonBinaryWriter.writeBoolean("upsert", (boolean)bl));
            concreteClientReplaceOneOptions.getSort().ifPresent(bson -> {
                bsonBinaryWriter.writeName("sort");
                ClientBulkWriteOperation.this.encodeUsingRegistry(bsonBinaryWriter, bson);
            });
        }

        private void encodeWriteModelInternals(BsonWriter bsonWriter, AbstractClientDeleteModel<?> abstractClientDeleteModel) {
            bsonWriter.writeName("filter");
            ClientBulkWriteOperation.this.encodeUsingRegistry(bsonWriter, abstractClientDeleteModel.getFilter());
            Object obj = abstractClientDeleteModel.getOptions();
            ((AbstractClientDeleteOptions)obj).getCollation().ifPresent(collation -> {
                bsonWriter.writeName("collation");
                ClientBulkWriteOperation.this.encodeUsingRegistry(bsonWriter, collation.asDocument());
            });
            ((AbstractClientDeleteOptions)obj).getHint().ifPresent(bson -> {
                bsonWriter.writeName("hint");
                ClientBulkWriteOperation.this.encodeUsingRegistry(bsonWriter, bson);
            });
            ((AbstractClientDeleteOptions)obj).getHintString().ifPresent(string -> bsonWriter.writeString("hint", (String)string));
        }

        final class EncodedBatchInfo {
            private final HashMap<Integer, BsonValue> insertModelDocumentIds = new HashMap();
            private int modelsCount = 0;

            private EncodedBatchInfo() {
            }

            Map<Integer, BsonValue> getInsertModelDocumentIds() {
                return this.insertModelDocumentIds;
            }

            int getModelsCount() {
                return this.modelsCount;
            }
        }
    }

    private static final class ExhaustiveClientBulkWriteCommandOkResponse {
        private final int nErrors;
        private final int nInserted;
        private final int nUpserted;
        private final int nMatched;
        private final int nModified;
        private final int nDeleted;
        private final List<BsonDocument> cursorExhaust;

        ExhaustiveClientBulkWriteCommandOkResponse(BsonDocument bsonDocument, List<List<BsonDocument>> list) {
            this.nErrors = bsonDocument.getInt32("nErrors").getValue();
            this.nInserted = bsonDocument.getInt32("nInserted").getValue();
            this.nUpserted = bsonDocument.getInt32("nUpserted").getValue();
            this.nMatched = bsonDocument.getInt32("nMatched").getValue();
            this.nModified = bsonDocument.getInt32("nModified").getValue();
            this.nDeleted = bsonDocument.getInt32("nDeleted").getValue();
            this.cursorExhaust = list.isEmpty() ? Collections.emptyList() : (list.size() == 1 ? list.get(0) : list.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        }

        boolean operationMayContinue(ConcreteClientBulkWriteOptions concreteClientBulkWriteOptions) {
            return this.nErrors == 0 || !concreteClientBulkWriteOptions.isOrdered();
        }

        int getNErrors() {
            return this.nErrors;
        }

        int getNInserted() {
            return this.nInserted;
        }

        int getNUpserted() {
            return this.nUpserted;
        }

        int getNMatched() {
            return this.nMatched;
        }

        int getNModified() {
            return this.nModified;
        }

        int getNDeleted() {
            return this.nDeleted;
        }

        List<BsonDocument> getCursorExhaust() {
            return this.cursorExhaust;
        }
    }

    public static final class ClientBulkWriteCommand {
        private final BsonDocument commandDocument;
        private final OpsAndNsInfo opsAndNsInfo;

        ClientBulkWriteCommand(BsonDocument bsonDocument, OpsAndNsInfo opsAndNsInfo) {
            this.commandDocument = bsonDocument;
            this.opsAndNsInfo = opsAndNsInfo;
        }

        BsonDocument getCommandDocument() {
            return this.commandDocument;
        }

        OpsAndNsInfo getOpsAndNsInfo() {
            return this.opsAndNsInfo;
        }

        public static final class OpsAndNsInfo
        extends DualMessageSequences {
            private final boolean effectiveRetryWrites;
            private final List<? extends ClientNamespacedWriteModel> models;
            private final BatchEncoder batchEncoder;
            private final ConcreteClientBulkWriteOptions options;
            private final Supplier<Long> doIfCommandIsRetryableAndAdvanceGetTxnNumber;

            public OpsAndNsInfo(boolean bl, List<? extends ClientNamespacedWriteModel> list, BatchEncoder batchEncoder, ConcreteClientBulkWriteOptions concreteClientBulkWriteOptions, Supplier<Long> supplier) {
                super("ops", new OpsFieldNameValidator(list), "nsInfo", NoOpFieldNameValidator.INSTANCE);
                this.effectiveRetryWrites = bl;
                this.models = list;
                this.batchEncoder = batchEncoder;
                this.options = concreteClientBulkWriteOptions;
                this.doIfCommandIsRetryableAndAdvanceGetTxnNumber = supplier;
            }

            @Override
            public DualMessageSequences.EncodeDocumentsResult encodeDocuments(DualMessageSequences.WritersProviderAndLimitsChecker writersProviderAndLimitsChecker) {
                this.batchEncoder.reset();
                LinkedHashMap<MongoNamespace, Integer> linkedHashMap = new LinkedHashMap<MongoNamespace, Integer>();
                DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult writeResult = DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.OK_LIMIT_NOT_REACHED;
                boolean bl = this.effectiveRetryWrites;
                int n = -1;
                for (int i = 0; i < this.models.size() && writeResult == DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.OK_LIMIT_NOT_REACHED; ++i) {
                    boolean bl2;
                    int n2;
                    MongoNamespace mongoNamespace;
                    int n3;
                    int n4;
                    AbstractClientNamespacedWriteModel abstractClientNamespacedWriteModel = ClientBulkWriteOperation.getNamespacedModel(this.models, i);
                    writeResult = writersProviderAndLimitsChecker.tryWrite((arg_0, arg_1) -> this.lambda$encodeDocuments$1(abstractClientNamespacedWriteModel, n4 = i, n3 = linkedHashMap.computeIfAbsent(mongoNamespace = abstractClientNamespacedWriteModel.getNamespace(), arg_0 -> OpsAndNsInfo.lambda$encodeDocuments$0(n2 = linkedHashMap.size(), arg_0)).intValue(), bl2 = linkedHashMap.size() != n2, mongoNamespace, arg_0, arg_1));
                    if (writeResult == DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.FAIL_LIMIT_EXCEEDED) {
                        this.batchEncoder.reset(n4);
                        continue;
                    }
                    n = n4;
                    if (!bl || !OpsAndNsInfo.doesNotSupportRetries(abstractClientNamespacedWriteModel)) continue;
                    bl = false;
                    BulkWriteBatch.logWriteModelDoesNotSupportRetries();
                }
                return new DualMessageSequences.EncodeDocumentsResult(this.options.isOrdered() && n < this.models.size() - 1, bl ? Collections.singletonList(new BsonElement("txnNumber", new BsonInt64(this.doIfCommandIsRetryableAndAdvanceGetTxnNumber.get()))) : Collections.emptyList());
            }

            private static boolean doesNotSupportRetries(AbstractClientNamespacedWriteModel abstractClientNamespacedWriteModel) {
                return abstractClientNamespacedWriteModel instanceof ConcreteClientNamespacedUpdateManyModel || abstractClientNamespacedWriteModel instanceof ConcreteClientNamespacedDeleteManyModel;
            }

            private /* synthetic */ int lambda$encodeDocuments$1(AbstractClientNamespacedWriteModel abstractClientNamespacedWriteModel, int n, int n2, boolean bl, MongoNamespace mongoNamespace, BsonBinaryWriter bsonBinaryWriter, BsonBinaryWriter bsonBinaryWriter2) {
                this.batchEncoder.encodeWriteModel(bsonBinaryWriter, abstractClientNamespacedWriteModel.getModel(), n, n2);
                if (bl) {
                    bsonBinaryWriter2.writeStartDocument();
                    bsonBinaryWriter2.writeString("ns", mongoNamespace.getFullName());
                    bsonBinaryWriter2.writeEndDocument();
                }
                return n + 1;
            }

            private static /* synthetic */ Integer lambda$encodeDocuments$0(int n, MongoNamespace mongoNamespace) {
                return n;
            }

            private static final class OpsFieldNameValidator
            implements FieldNameValidator {
                private static final Set<String> OPERATION_DISCRIMINATOR_FIELD_NAMES = Stream.of("insert", "update", "delete").collect(Collectors.toSet());
                private final List<? extends ClientNamespacedWriteModel> models;
                private final ReplacingUpdateModsFieldValidator replacingValidator;
                private final UpdatingUpdateModsFieldValidator updatingValidator;
                private int currentIndividualOperationIndex;

                OpsFieldNameValidator(List<? extends ClientNamespacedWriteModel> list) {
                    this.models = list;
                    this.replacingValidator = new ReplacingUpdateModsFieldValidator();
                    this.updatingValidator = new UpdatingUpdateModsFieldValidator();
                    this.currentIndividualOperationIndex = -1;
                }

                @Override
                public boolean validate(String string) {
                    if (OPERATION_DISCRIMINATOR_FIELD_NAMES.contains(string)) {
                        ++this.currentIndividualOperationIndex;
                    }
                    return true;
                }

                @Override
                public FieldNameValidator getValidatorForField(String string) {
                    if (string.equals("updateMods")) {
                        return this.currentIndividualOperationIsReplace() ? this.replacingValidator.reset() : this.updatingValidator.reset();
                    }
                    return NoOpFieldNameValidator.INSTANCE;
                }

                private boolean currentIndividualOperationIsReplace() {
                    return ClientBulkWriteOperation.getNamespacedModel(this.models, this.currentIndividualOperationIndex) instanceof ConcreteClientNamespacedReplaceOneModel;
                }

                private static final class ReplacingUpdateModsFieldValidator
                implements FieldNameValidator {
                    private boolean firstFieldSinceLastReset = true;

                    ReplacingUpdateModsFieldValidator() {
                    }

                    @Override
                    public boolean validate(String string) {
                        if (this.firstFieldSinceLastReset) {
                            this.firstFieldSinceLastReset = false;
                            return ReplacingDocumentFieldNameValidator.INSTANCE.validate(string);
                        }
                        return true;
                    }

                    @Override
                    public String getValidationErrorMessage(String string) {
                        return ReplacingDocumentFieldNameValidator.INSTANCE.getValidationErrorMessage(string);
                    }

                    @Override
                    public FieldNameValidator getValidatorForField(String string) {
                        return NoOpFieldNameValidator.INSTANCE;
                    }

                    ReplacingUpdateModsFieldValidator reset() {
                        this.firstFieldSinceLastReset = true;
                        return this;
                    }
                }

                private static final class UpdatingUpdateModsFieldValidator
                implements FieldNameValidator {
                    private final UpdateFieldNameValidator delegate = new UpdateFieldNameValidator();
                    private boolean firstFieldSinceLastReset = true;

                    UpdatingUpdateModsFieldValidator() {
                    }

                    @Override
                    public boolean validate(String string) {
                        if (this.firstFieldSinceLastReset) {
                            this.firstFieldSinceLastReset = false;
                            return this.delegate.validate(string);
                        }
                        return true;
                    }

                    @Override
                    public String getValidationErrorMessage(String string) {
                        return this.delegate.getValidationErrorMessage(string);
                    }

                    @Override
                    public FieldNameValidator getValidatorForField(String string) {
                        return NoOpFieldNameValidator.INSTANCE;
                    }

                    @Override
                    public void start() {
                        this.delegate.start();
                    }

                    @Override
                    public void end() {
                        this.delegate.end();
                    }

                    UpdatingUpdateModsFieldValidator reset() {
                        this.delegate.reset();
                        this.firstFieldSinceLastReset = true;
                        return this;
                    }
                }
            }
        }
    }

    public static final class Exceptions {
        public static Optional<ServerAddress> serverAddressFromException(@Nullable MongoException mongoException) {
            ServerAddress serverAddress = null;
            if (mongoException instanceof MongoServerException) {
                serverAddress = ((MongoServerException)mongoException).getServerAddress();
            } else if (mongoException instanceof MongoSocketException) {
                serverAddress = ((MongoSocketException)mongoException).getServerAddress();
            }
            return Optional.ofNullable(serverAddress);
        }

        @Nullable
        private static MongoWriteConcernException createWriteConcernException(BsonDocument bsonDocument, ServerAddress serverAddress) {
            String string = "writeConcernError";
            if (!bsonDocument.containsKey("writeConcernError")) {
                return null;
            }
            BsonDocument bsonDocument2 = bsonDocument.getDocument("writeConcernError");
            WriteConcernError writeConcernError = WriteConcernHelper.createWriteConcernError(bsonDocument2);
            Set<String> set = bsonDocument.getArray("errorLabels", new BsonArray()).stream().map(bsonValue -> bsonValue.asString().getValue()).collect(Collectors.toSet());
            return new MongoWriteConcernException(writeConcernError, null, serverAddress, set);
        }
    }

    static final class BatchResult {
        private final int batchStartModelIndex;
        private final BatchEncoder.EncodedBatchInfo encodedBatchInfo;
        @Nullable
        private final ExhaustiveClientBulkWriteCommandOkResponse response;
        @Nullable
        private final MongoWriteConcernException writeConcernException;

        static BatchResult okResponse(int n, BatchEncoder.EncodedBatchInfo encodedBatchInfo, ExhaustiveClientBulkWriteCommandOkResponse exhaustiveClientBulkWriteCommandOkResponse, @Nullable MongoWriteConcernException mongoWriteConcernException) {
            return new BatchResult(n, encodedBatchInfo, Assertions.assertNotNull(exhaustiveClientBulkWriteCommandOkResponse), mongoWriteConcernException);
        }

        static BatchResult noResponse(int n, BatchEncoder.EncodedBatchInfo encodedBatchInfo) {
            return new BatchResult(n, encodedBatchInfo, null, null);
        }

        private BatchResult(int n, BatchEncoder.EncodedBatchInfo encodedBatchInfo, @Nullable ExhaustiveClientBulkWriteCommandOkResponse exhaustiveClientBulkWriteCommandOkResponse, @Nullable MongoWriteConcernException mongoWriteConcernException) {
            this.batchStartModelIndex = n;
            this.encodedBatchInfo = encodedBatchInfo;
            this.response = exhaustiveClientBulkWriteCommandOkResponse;
            this.writeConcernException = mongoWriteConcernException;
        }

        int getBatchStartModelIndex() {
            return this.batchStartModelIndex;
        }

        int getBatchModelsCount() {
            return this.encodedBatchInfo.getModelsCount();
        }

        boolean hasResponse() {
            return this.response != null;
        }

        ExhaustiveClientBulkWriteCommandOkResponse getResponse() {
            return Assertions.assertNotNull(this.response);
        }

        @Nullable
        MongoWriteConcernException getWriteConcernException() {
            Assertions.assertTrue(this.hasResponse());
            return this.writeConcernException;
        }

        Map<Integer, BsonValue> getInsertModelDocumentIds() {
            Assertions.assertTrue(this.hasResponse());
            return this.encodedBatchInfo.getInsertModelDocumentIds();
        }
    }
}

