/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.MongoSocketException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AggregateResponseBatchCursor;
import com.mongodb.internal.operation.CommandBatchCursorHelper;
import com.mongodb.internal.operation.CommandCursorResult;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.CursorResourceManager;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

class CommandBatchCursor<T>
implements AggregateResponseBatchCursor<T> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    @Nullable
    private final BsonValue comment;
    private final int maxWireVersion;
    private final boolean firstBatchEmpty;
    private final ResourceManager resourceManager;
    private final OperationContext operationContext;
    private final TimeoutMode timeoutMode;
    private int batchSize;
    private CommandCursorResult<T> commandCursorResult;
    @Nullable
    private List<T> nextBatch;
    private boolean resetTimeoutWhenClosing;

    CommandBatchCursor(TimeoutMode timeoutMode, BsonDocument bsonDocument, int n, long l, Decoder<T> decoder, @Nullable BsonValue bsonValue, ConnectionSource connectionSource, Connection connection) {
        ConnectionDescription connectionDescription = connection.getDescription();
        this.commandCursorResult = this.toCommandCursorResult(connectionDescription.getServerAddress(), "firstBatch", bsonDocument);
        this.namespace = this.commandCursorResult.getNamespace();
        this.batchSize = n;
        this.decoder = decoder;
        this.comment = bsonValue;
        this.maxWireVersion = connectionDescription.getMaxWireVersion();
        this.firstBatchEmpty = this.commandCursorResult.getResults().isEmpty();
        this.operationContext = connectionSource.getOperationContext();
        this.timeoutMode = timeoutMode;
        this.operationContext.getTimeoutContext().setMaxTimeOverride(l);
        Connection connection2 = connectionSource.getServerDescription().getType() == ServerType.LOAD_BALANCER ? connection : null;
        this.resourceManager = new ResourceManager(this.namespace, connectionSource, connection2, this.commandCursorResult.getServerCursor());
        this.resetTimeoutWhenClosing = true;
    }

    @Override
    public boolean hasNext() {
        return Assertions.assertNotNull(this.resourceManager.execute("Cursor has been closed", this::doHasNext));
    }

    private boolean doHasNext() {
        if (this.nextBatch != null) {
            return true;
        }
        this.checkTimeoutModeAndResetTimeoutContextIfIteration();
        while (this.resourceManager.getServerCursor() != null) {
            this.getMore();
            if (!this.resourceManager.operable()) {
                throw new IllegalStateException("Cursor has been closed");
            }
            if (this.nextBatch == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> next() {
        return Assertions.assertNotNull(this.resourceManager.execute("Iterator has been closed", this::doNext));
    }

    @Override
    public int available() {
        return !this.resourceManager.operable() || this.nextBatch == null ? 0 : this.nextBatch.size();
    }

    @Nullable
    private List<T> doNext() {
        if (!this.doHasNext()) {
            throw new NoSuchElementException();
        }
        List<T> list = this.nextBatch;
        this.nextBatch = null;
        return list;
    }

    boolean isClosed() {
        return !this.resourceManager.operable();
    }

    @Override
    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public void close() {
        this.resourceManager.close();
    }

    @Override
    @Nullable
    public List<T> tryNext() {
        return this.resourceManager.execute("Cursor has been closed", () -> {
            if (!this.tryHasNext()) {
                return null;
            }
            return this.doNext();
        });
    }

    private boolean tryHasNext() {
        if (this.nextBatch != null) {
            return true;
        }
        if (this.resourceManager.getServerCursor() != null) {
            this.getMore();
        }
        return this.nextBatch != null;
    }

    @Override
    @Nullable
    public ServerCursor getServerCursor() {
        if (!this.resourceManager.operable()) {
            throw new IllegalStateException("Iterator has been closed");
        }
        return this.resourceManager.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        if (!this.resourceManager.operable()) {
            throw new IllegalStateException("Iterator has been closed");
        }
        return this.commandCursorResult.getServerAddress();
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.commandCursorResult.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.commandCursorResult.getOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.firstBatchEmpty;
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    void checkTimeoutModeAndResetTimeoutContextIfIteration() {
        if (this.timeoutMode == TimeoutMode.ITERATION) {
            this.operationContext.getTimeoutContext().resetTimeoutIfPresent();
        }
    }

    private void getMore() {
        ServerCursor serverCursor = Assertions.assertNotNull(this.resourceManager.getServerCursor());
        this.resourceManager.executeWithConnection(connection -> {
            ServerCursor serverCursor2;
            try {
                this.commandCursorResult = this.toCommandCursorResult(connection.getDescription().getServerAddress(), "nextBatch", Assertions.assertNotNull(connection.command(this.namespace.getDatabaseName(), CommandBatchCursorHelper.getMoreCommandDocument(serverCursor.getId(), connection.getDescription(), this.namespace, this.batchSize, this.comment), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), CommandResultDocumentCodec.create(this.decoder, "nextBatch"), Assertions.assertNotNull((ConnectionSource)this.resourceManager.getConnectionSource()).getOperationContext())));
                serverCursor2 = this.commandCursorResult.getServerCursor();
            }
            catch (MongoCommandException mongoCommandException) {
                throw CommandBatchCursorHelper.translateCommandException(mongoCommandException, serverCursor);
            }
            this.resourceManager.setServerCursor(serverCursor2);
        });
    }

    private CommandCursorResult<T> toCommandCursorResult(ServerAddress serverAddress, String string, BsonDocument bsonDocument) {
        CommandCursorResult commandCursorResult = new CommandCursorResult(serverAddress, string, bsonDocument);
        CommandBatchCursorHelper.logCommandCursorResult(commandCursorResult);
        this.nextBatch = commandCursorResult.getResults().isEmpty() ? null : commandCursorResult.getResults();
        return commandCursorResult;
    }

    CommandBatchCursor<T> disableTimeoutResetWhenClosing() {
        this.resetTimeoutWhenClosing = false;
        return this;
    }

    @ThreadSafe
    private final class ResourceManager
    extends CursorResourceManager<ConnectionSource, Connection> {
        ResourceManager(MongoNamespace mongoNamespace, @Nullable ConnectionSource connectionSource, @Nullable Connection connection, ServerCursor serverCursor) {
            super(mongoNamespace, connectionSource, connection, serverCursor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        <R> R execute(String string, Supplier<R> supplier) throws IllegalStateException {
            if (!this.tryStartOperation()) {
                throw new IllegalStateException(string);
            }
            try {
                R r = supplier.get();
                return r;
            }
            finally {
                this.endOperation();
            }
        }

        @Override
        void markAsPinned(Connection connection, Connection.PinningMode pinningMode) {
            connection.markAsPinned(pinningMode);
        }

        @Override
        void doClose() {
            TimeoutContext timeoutContext = CommandBatchCursor.this.operationContext.getTimeoutContext();
            timeoutContext.resetToDefaultMaxTime();
            if (CommandBatchCursor.this.resetTimeoutWhenClosing) {
                timeoutContext.doWithResetTimeout(this::releaseResources);
            } else {
                this.releaseResources();
            }
        }

        private void releaseResources() {
            block8: {
                try {
                    if (this.isSkipReleasingServerResourcesOnClose()) {
                        this.unsetServerCursor();
                    }
                    if (super.getServerCursor() == null) break block8;
                    Connection connection = this.getConnection();
                    try {
                        this.releaseServerResources(connection);
                    }
                    finally {
                        connection.release();
                    }
                }
                catch (MongoException mongoException) {
                }
                finally {
                    this.unsetServerCursor();
                    this.releaseClientResources();
                }
            }
        }

        void executeWithConnection(Consumer<Connection> consumer) {
            Connection connection = this.getConnection();
            try {
                consumer.accept(connection);
            }
            catch (MongoSocketException mongoSocketException) {
                this.onCorruptedConnection(connection, mongoSocketException);
                throw mongoSocketException;
            }
            catch (MongoOperationTimeoutException mongoOperationTimeoutException) {
                Throwable throwable = mongoOperationTimeoutException.getCause();
                if (throwable instanceof MongoSocketException) {
                    this.onCorruptedConnection(connection, (MongoSocketException)throwable);
                }
                throw mongoOperationTimeoutException;
            }
            finally {
                connection.release();
            }
        }

        private Connection getConnection() {
            Assertions.assertTrue(this.getState() != CursorResourceManager.State.IDLE);
            Connection connection = (Connection)this.getPinnedConnection();
            if (connection == null) {
                return Assertions.assertNotNull((ConnectionSource)this.getConnectionSource()).getConnection();
            }
            return connection.retain();
        }

        private void releaseServerResources(Connection connection) {
            try {
                ServerCursor serverCursor = super.getServerCursor();
                if (serverCursor != null) {
                    this.killServerCursor(this.getNamespace(), serverCursor, connection);
                }
            }
            finally {
                this.unsetServerCursor();
            }
        }

        private void killServerCursor(MongoNamespace mongoNamespace, ServerCursor serverCursor, Connection connection) {
            connection.command(mongoNamespace.getDatabaseName(), CommandBatchCursorHelper.getKillCursorsCommand(mongoNamespace, serverCursor), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), new BsonDocumentCodec(), CommandBatchCursor.this.operationContext);
        }
    }
}

