/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoCursorNotFoundException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoQueryException;
import com.mongodb.ServerCursor;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.operation.CommandCursorResult;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;

final class CommandBatchCursorHelper {
    static final String FIRST_BATCH = "firstBatch";
    static final String NEXT_BATCH = "nextBatch";
    static final String MESSAGE_IF_CLOSED_AS_CURSOR = "Cursor has been closed";
    static final String MESSAGE_IF_CLOSED_AS_ITERATOR = "Iterator has been closed";
    static final String MESSAGE_IF_CONCURRENT_OPERATION = "Another operation is currently in progress, concurrent operations are not supported";

    static BsonDocument getMoreCommandDocument(long l, ConnectionDescription connectionDescription, MongoNamespace mongoNamespace, int n, @Nullable BsonValue bsonValue) {
        BsonDocument bsonDocument = new BsonDocument("getMore", new BsonInt64(l)).append("collection", new BsonString(mongoNamespace.getCollectionName()));
        if (n != 0) {
            bsonDocument.append("batchSize", new BsonInt32(n));
        }
        if (ServerVersionHelper.serverIsAtLeastVersionFourDotFour(connectionDescription)) {
            DocumentHelper.putIfNotNull(bsonDocument, "comment", bsonValue);
        }
        return bsonDocument;
    }

    static <T> CommandCursorResult<T> logCommandCursorResult(CommandCursorResult<T> commandCursorResult) {
        if (OperationHelper.LOGGER.isDebugEnabled()) {
            OperationHelper.LOGGER.debug(String.format("Received batch of %d documents with cursorId %d from server %s", commandCursorResult.getResults().size(), commandCursorResult.getCursorId(), commandCursorResult.getServerAddress()));
        }
        return commandCursorResult;
    }

    static BsonDocument getKillCursorsCommand(MongoNamespace mongoNamespace, ServerCursor serverCursor) {
        return new BsonDocument("killCursors", new BsonString(mongoNamespace.getCollectionName())).append("cursors", new BsonArray(Collections.singletonList(new BsonInt64(serverCursor.getId()))));
    }

    static MongoQueryException translateCommandException(MongoCommandException mongoCommandException, ServerCursor serverCursor) {
        if (mongoCommandException.getErrorCode() == 43) {
            return new MongoCursorNotFoundException(serverCursor.getId(), mongoCommandException.getResponse(), serverCursor.getAddress());
        }
        return new MongoQueryException(mongoCommandException.getResponse(), mongoCommandException.getServerAddress());
    }

    private CommandBatchCursorHelper() {
    }
}

