/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoClientException;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoConnectionPoolClearedException;
import com.mongodb.MongoException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSecurityException;
import com.mongodb.MongoServerException;
import com.mongodb.MongoSocketException;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.retry.AttachmentKeys;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.bson.BsonDocument;

final class CommandOperationHelper {
    private static final List<Integer> RETRYABLE_ERROR_CODES = Arrays.asList(6, 7, 89, 91, 189, 262, 9001, 13436, 13435, 11602, 11600, 10107);
    static final String RETRYABLE_WRITE_ERROR_LABEL = "RetryableWriteError";
    private static final String NO_WRITES_PERFORMED_ERROR_LABEL = "NoWritesPerformed";

    static WriteConcern validateAndGetEffectiveWriteConcern(WriteConcern writeConcern, SessionContext sessionContext) throws MongoClientException {
        WriteConcern writeConcern2;
        boolean bl = sessionContext.hasActiveTransaction();
        WriteConcern writeConcern3 = writeConcern2 = bl ? WriteConcern.ACKNOWLEDGED : writeConcern;
        if (sessionContext.hasSession() && !sessionContext.isImplicitSession() && !bl && !writeConcern2.isAcknowledged()) {
            throw new MongoClientException("Unacknowledged writes are not supported when using an explicit session");
        }
        return writeConcern2;
    }

    static Optional<WriteConcern> commandWriteConcern(WriteConcern writeConcern, SessionContext sessionContext) {
        return writeConcern.isServerDefault() || sessionContext.hasActiveTransaction() ? Optional.empty() : Optional.of(writeConcern);
    }

    static BinaryOperator<Throwable> onRetryableReadAttemptFailure(OperationContext operationContext) {
        return (throwable, throwable2) -> {
            operationContext.getServerDeprioritization().onAttemptFailure((Throwable)throwable2);
            return CommandOperationHelper.chooseRetryableReadException(throwable, throwable2);
        };
    }

    private static Throwable chooseRetryableReadException(@Nullable Throwable throwable, Throwable throwable2) {
        Assertions.assertFalse(throwable2 instanceof OperationHelper.ResourceSupplierInternalException);
        if (throwable == null || throwable2 instanceof MongoSocketException || throwable2 instanceof MongoServerException) {
            return throwable2;
        }
        return throwable;
    }

    static BinaryOperator<Throwable> onRetryableWriteAttemptFailure(OperationContext operationContext) {
        return (throwable, throwable2) -> {
            operationContext.getServerDeprioritization().onAttemptFailure((Throwable)throwable2);
            return CommandOperationHelper.chooseRetryableWriteException(throwable, throwable2);
        };
    }

    private static Throwable chooseRetryableWriteException(@Nullable Throwable throwable, Throwable throwable2) {
        if (throwable == null) {
            if (throwable2 instanceof OperationHelper.ResourceSupplierInternalException) {
                return throwable2.getCause();
            }
            return throwable2;
        }
        if (throwable2 instanceof OperationHelper.ResourceSupplierInternalException || throwable2 instanceof MongoException && ((MongoException)throwable2).hasErrorLabel(NO_WRITES_PERFORMED_ERROR_LABEL)) {
            return throwable;
        }
        return throwable2;
    }

    static RetryState initialRetryState(boolean bl, TimeoutContext timeoutContext) {
        if (bl) {
            return RetryState.withRetryableState(1, timeoutContext);
        }
        return RetryState.withNonRetryableState();
    }

    static boolean isRetryableException(Throwable throwable) {
        if (!(throwable instanceof MongoException)) {
            return false;
        }
        if (throwable instanceof MongoSocketException || throwable instanceof MongoNotPrimaryException || throwable instanceof MongoNodeIsRecoveringException || throwable instanceof MongoConnectionPoolClearedException) {
            return true;
        }
        return RETRYABLE_ERROR_CODES.contains(((MongoException)throwable).getCode());
    }

    static void rethrowIfNotNamespaceError(MongoCommandException mongoCommandException) {
        CommandOperationHelper.rethrowIfNotNamespaceError(mongoCommandException, null);
    }

    @Nullable
    static <T> T rethrowIfNotNamespaceError(MongoCommandException mongoCommandException, @Nullable T t) {
        if (!CommandOperationHelper.isNamespaceError(mongoCommandException)) {
            throw mongoCommandException;
        }
        return t;
    }

    static boolean isNamespaceError(Throwable throwable) {
        if (throwable instanceof MongoCommandException) {
            MongoCommandException mongoCommandException = (MongoCommandException)throwable;
            return mongoCommandException.getErrorMessage().contains("ns not found") || mongoCommandException.getErrorCode() == 26;
        }
        return false;
    }

    static boolean shouldAttemptToRetryRead(RetryState retryState, Throwable throwable) {
        boolean bl;
        Assertions.assertFalse(throwable instanceof OperationHelper.ResourceSupplierInternalException);
        boolean bl2 = bl = CommandOperationHelper.isRetryableException(throwable) || throwable instanceof MongoSecurityException && throwable.getCause() != null && CommandOperationHelper.isRetryableException(throwable.getCause());
        if (!bl) {
            CommandOperationHelper.logUnableToRetry(retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).orElse(null), throwable);
        }
        return bl;
    }

    static boolean loggingShouldAttemptToRetryWriteAndAddRetryableLabel(RetryState retryState, Throwable throwable) {
        boolean bl;
        Throwable throwable2 = CommandOperationHelper.getAttemptFailureNotToRetryOrAddRetryableLabel(retryState, throwable);
        boolean bl2 = bl = throwable2 == null;
        if (!bl && retryState.attachment(AttachmentKeys.retryableCommandFlag()).orElse(false).booleanValue()) {
            CommandOperationHelper.logUnableToRetry(retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).orElse(null), Assertions.assertNotNull(throwable2));
        }
        return bl;
    }

    static boolean shouldAttemptToRetryWriteAndAddRetryableLabel(RetryState retryState, Throwable throwable) {
        return CommandOperationHelper.getAttemptFailureNotToRetryOrAddRetryableLabel(retryState, throwable) != null;
    }

    @Nullable
    private static Throwable getAttemptFailureNotToRetryOrAddRetryableLabel(RetryState retryState, Throwable throwable) {
        Throwable throwable2 = throwable instanceof OperationHelper.ResourceSupplierInternalException ? throwable.getCause() : throwable;
        boolean bl = false;
        MongoException mongoException = null;
        if (throwable2 instanceof MongoConnectionPoolClearedException || throwable2 instanceof MongoSecurityException && throwable2.getCause() != null && CommandOperationHelper.isRetryableException(throwable2.getCause())) {
            bl = true;
            mongoException = (MongoException)throwable2;
        }
        if (retryState.attachment(AttachmentKeys.retryableCommandFlag()).orElse(false).booleanValue()) {
            if (mongoException != null) {
                mongoException.addLabel(RETRYABLE_WRITE_ERROR_LABEL);
            } else if (CommandOperationHelper.decideRetryableAndAddRetryableWriteErrorLabel(throwable2, retryState.attachment(AttachmentKeys.maxWireVersion()).orElse(null))) {
                bl = true;
            }
        }
        return bl ? null : Assertions.assertNotNull(throwable2);
    }

    static boolean isRetryWritesEnabled(@Nullable BsonDocument bsonDocument) {
        return bsonDocument != null && (bsonDocument.containsKey("txnNumber") || bsonDocument.getFirstKey().equals("commitTransaction") || bsonDocument.getFirstKey().equals("abortTransaction"));
    }

    private static boolean decideRetryableAndAddRetryableWriteErrorLabel(Throwable throwable, @Nullable Integer n) {
        if (!(throwable instanceof MongoException)) {
            return false;
        }
        MongoException mongoException = (MongoException)throwable;
        if (n != null) {
            CommandOperationHelper.addRetryableWriteErrorLabel(mongoException, n);
        }
        return mongoException.hasErrorLabel(RETRYABLE_WRITE_ERROR_LABEL);
    }

    static void addRetryableWriteErrorLabel(MongoException mongoException, int n) {
        if (n >= 9 && mongoException instanceof MongoSocketException) {
            mongoException.addLabel(RETRYABLE_WRITE_ERROR_LABEL);
        } else if (n < 9 && CommandOperationHelper.isRetryableException(mongoException)) {
            mongoException.addLabel(RETRYABLE_WRITE_ERROR_LABEL);
        }
    }

    static void logRetryExecute(RetryState retryState, OperationContext operationContext) {
        if (OperationHelper.LOGGER.isDebugEnabled() && !retryState.isFirstAttempt()) {
            String string = retryState.attachment(AttachmentKeys.commandDescriptionSupplier()).map(Supplier::get).orElse(null);
            Throwable throwable = retryState.exception().orElseThrow(Assertions::fail);
            int n = retryState.attempt() + 1;
            long l = operationContext.getId();
            OperationHelper.LOGGER.debug(string == null ? String.format("Retrying the operation with operation ID %s due to the error \"%s\". Attempt number: #%d", l, throwable, n) : String.format("Retrying the operation '%s' with operation ID %s due to the error \"%s\". Attempt number: #%d", string, l, throwable, n));
        }
    }

    private static void logUnableToRetry(@Nullable Supplier<String> supplier, Throwable throwable) {
        if (OperationHelper.LOGGER.isDebugEnabled()) {
            String string = supplier == null ? null : supplier.get();
            OperationHelper.LOGGER.debug(string == null ? String.format("Unable to retry an operation due to the error \"%s\"", throwable) : String.format("Unable to retry the operation %s due to the error \"%s\"", string, throwable));
        }
    }

    static MongoException transformWriteException(MongoException mongoException) {
        if (mongoException.getCode() == 20 && mongoException.getMessage().contains("Transaction numbers")) {
            MongoClientException mongoClientException = new MongoClientException("This MongoDB deployment does not support retryable writes. Please add retryWrites=false to your connection string.", mongoException);
            for (String string : mongoException.getErrorLabels()) {
                mongoClientException.addLabel(string);
            }
            return mongoClientException;
        }
        return mongoException;
    }

    private CommandOperationHelper() {
    }

    static interface CommandCreator {
        public BsonDocument create(OperationContext var1, ServerDescription var2, ConnectionDescription var3);
    }
}

