/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import org.bson.BsonDocument;
import org.bson.codecs.Decoder;

public class CommandReadOperation<T>
implements AsyncReadOperation<T>,
ReadOperation<T> {
    private final String databaseName;
    private final CommandOperationHelper.CommandCreator commandCreator;
    private final Decoder<T> decoder;

    public CommandReadOperation(String string, BsonDocument bsonDocument, Decoder<T> decoder) {
        this(string, (OperationContext operationContext, ServerDescription serverDescription, ConnectionDescription connectionDescription) -> bsonDocument, decoder);
    }

    public CommandReadOperation(String string, CommandOperationHelper.CommandCreator commandCreator, Decoder<T> decoder) {
        this.databaseName = Assertions.notNull("databaseName", string);
        this.commandCreator = Assertions.notNull("commandCreator", commandCreator);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    @Override
    public T execute(ReadBinding readBinding) {
        return (T)SyncOperationHelper.executeRetryableRead(readBinding, this.databaseName, this.commandCreator, this.decoder, (object, connectionSource, connection) -> object, false);
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<T> singleResultCallback) {
        AsyncOperationHelper.executeRetryableReadAsync(asyncReadBinding, this.databaseName, this.commandCreator, this.decoder, (object, asyncConnectionSource, asyncConnection) -> object, false, singleResultCallback);
    }
}

