/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.internal.operation.BsonArrayWrapper;
import java.util.ArrayList;
import org.bson.BsonArray;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistry;

class CommandResultArrayCodec<T>
extends BsonArrayCodec {
    private final Decoder<T> decoder;

    CommandResultArrayCodec(CodecRegistry codecRegistry, Decoder<T> decoder) {
        super(codecRegistry);
        this.decoder = decoder;
    }

    @Override
    public BsonArray decode(BsonReader bsonReader, DecoderContext decoderContext) {
        bsonReader.readStartArray();
        ArrayList<T> arrayList = new ArrayList<T>();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            if (bsonReader.getCurrentBsonType() == BsonType.NULL) {
                bsonReader.readNull();
                arrayList.add(null);
                continue;
            }
            arrayList.add(this.decoder.decode(bsonReader, decoderContext));
        }
        bsonReader.readEndArray();
        return new BsonArrayWrapper(arrayList);
    }

    @Override
    protected BsonValue readValue(BsonReader bsonReader, DecoderContext decoderContext) {
        if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT) {
            return new BsonDocumentWrapper<T>(this.decoder.decode(bsonReader, decoderContext), null);
        }
        return super.readValue(bsonReader, decoderContext);
    }
}

