/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.internal.operation.CommandResultArrayCodec;
import com.mongodb.internal.operation.CommandResultCodecProvider;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

class CommandResultDocumentCodec<T>
extends BsonDocumentCodec {
    private final Decoder<T> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultDocumentCodec(CodecRegistry codecRegistry, Decoder<T> decoder, List<String> list) {
        super(codecRegistry);
        this.payloadDecoder = decoder;
        this.fieldsContainingPayload = list;
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, String string) {
        return CommandResultDocumentCodec.create(decoder, Collections.singletonList(string));
    }

    static <P> Codec<BsonDocument> create(Decoder<P> decoder, List<String> list) {
        CodecRegistry codecRegistry = CodecRegistries.fromProviders(new CommandResultCodecProvider<P>(decoder, list));
        return codecRegistry.get(BsonDocument.class);
    }

    @Override
    protected BsonValue readValue(BsonReader bsonReader, DecoderContext decoderContext) {
        if (this.fieldsContainingPayload.contains(bsonReader.getCurrentName())) {
            if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new BsonDocumentWrapper<T>(this.payloadDecoder.decode(bsonReader, decoderContext), null);
            }
            if (bsonReader.getCurrentBsonType() == BsonType.ARRAY) {
                return new CommandResultArrayCodec<T>(this.getCodecRegistry(), this.payloadDecoder).decode(bsonReader, decoderContext);
            }
        }
        return super.readValue(bsonReader, decoderContext);
    }
}

