/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.Function;
import com.mongodb.MongoException;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.WriteConcern;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.TransactionOperation;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;

public class CommitTransactionOperation
extends TransactionOperation {
    private final boolean alreadyCommitted;
    private BsonDocument recoveryToken;
    private static final List<Integer> NON_RETRYABLE_WRITE_CONCERN_ERROR_CODES = Arrays.asList(79, 100);

    public CommitTransactionOperation(WriteConcern writeConcern) {
        this(writeConcern, false);
    }

    public CommitTransactionOperation(WriteConcern writeConcern, boolean bl) {
        super(writeConcern);
        this.alreadyCommitted = bl;
    }

    public CommitTransactionOperation recoveryToken(@Nullable BsonDocument bsonDocument) {
        this.recoveryToken = bsonDocument;
        return this;
    }

    @Override
    public Void execute(WriteBinding writeBinding) {
        try {
            return super.execute(writeBinding);
        }
        catch (MongoException mongoException) {
            this.addErrorLabels(mongoException);
            throw mongoException;
        }
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<Void> singleResultCallback) {
        super.executeAsync(asyncWriteBinding, (Void void_, Throwable throwable) -> {
            if (throwable instanceof MongoException) {
                this.addErrorLabels((MongoException)throwable);
            }
            singleResultCallback.onResult((Void)void_, throwable);
        });
    }

    private void addErrorLabels(MongoException mongoException) {
        if (CommitTransactionOperation.shouldAddUnknownTransactionCommitResultLabel(mongoException)) {
            mongoException.addLabel("UnknownTransactionCommitResult");
        }
    }

    private static boolean shouldAddUnknownTransactionCommitResultLabel(MongoException mongoException) {
        if (mongoException instanceof MongoSocketException || mongoException instanceof MongoTimeoutException || mongoException instanceof MongoNotPrimaryException || mongoException instanceof MongoNodeIsRecoveringException || mongoException instanceof MongoExecutionTimeoutException) {
            return true;
        }
        if (mongoException.hasErrorLabel("RetryableWriteError")) {
            return true;
        }
        if (mongoException instanceof MongoWriteConcernException) {
            return !NON_RETRYABLE_WRITE_CONCERN_ERROR_CODES.contains(mongoException.getCode());
        }
        return false;
    }

    @Override
    protected String getCommandName() {
        return "commitTransaction";
    }

    @Override
    CommandOperationHelper.CommandCreator getCommandCreator() {
        CommandOperationHelper.CommandCreator commandCreator = (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = CommitTransactionOperation.super.getCommandCreator().create(operationContext, serverDescription, connectionDescription);
            operationContext.getTimeoutContext().setMaxTimeOverrideToMaxCommitTime();
            return bsonDocument;
        };
        if (this.alreadyCommitted) {
            return (operationContext, serverDescription, connectionDescription) -> this.getRetryCommandModifier(operationContext.getTimeoutContext()).apply(commandCreator.create(operationContext, serverDescription, connectionDescription));
        }
        if (this.recoveryToken != null) {
            return (operationContext, serverDescription, connectionDescription) -> commandCreator.create(operationContext, serverDescription, connectionDescription).append("recoveryToken", this.recoveryToken);
        }
        return commandCreator;
    }

    @Override
    protected Function<BsonDocument, BsonDocument> getRetryCommandModifier(TimeoutContext timeoutContext) {
        return bsonDocument -> {
            WriteConcern writeConcern = this.getWriteConcern().withW("majority");
            if (writeConcern.getWTimeout(TimeUnit.MILLISECONDS) == null && !timeoutContext.hasTimeoutMS()) {
                writeConcern = writeConcern.withWTimeout(10000L, TimeUnit.MILLISECONDS);
            }
            bsonDocument.put("writeConcern", writeConcern.asDocument());
            if (this.recoveryToken != null) {
                bsonDocument.put("recoveryToken", this.recoveryToken);
            }
            return bsonDocument;
        };
    }
}

