/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AggregateOperation;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class CountDocumentsOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private BsonDocument filter;
    private BsonValue hint;
    private BsonValue comment;
    private long skip;
    private long limit;
    private Collation collation;

    public CountDocumentsOperation(MongoNamespace mongoNamespace) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
    }

    @Nullable
    public BsonDocument getFilter() {
        return this.filter;
    }

    public CountDocumentsOperation filter(@Nullable BsonDocument bsonDocument) {
        this.filter = bsonDocument;
        return this;
    }

    public CountDocumentsOperation retryReads(boolean bl) {
        this.retryReads = bl;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public BsonValue getHint() {
        return this.hint;
    }

    public CountDocumentsOperation hint(@Nullable BsonValue bsonValue) {
        this.hint = bsonValue;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public CountDocumentsOperation limit(long l) {
        this.limit = l;
        return this;
    }

    public long getSkip() {
        return this.skip;
    }

    public CountDocumentsOperation skip(long l) {
        this.skip = l;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public CountDocumentsOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public CountDocumentsOperation comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Override
    public Long execute(ReadBinding readBinding) {
        try (Object object = this.getAggregateOperation().execute(readBinding);){
            Long l = object.hasNext() ? this.getCountFromAggregateResults((List<BsonDocument>)object.next()) : 0L;
            return l;
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<Long> singleResultCallback) {
        this.getAggregateOperation().executeAsync(asyncReadBinding, (asyncBatchCursor, throwable2) -> {
            if (throwable2 != null) {
                singleResultCallback.onResult(null, throwable2);
            } else {
                asyncBatchCursor.next((list, throwable) -> {
                    if (throwable != null) {
                        singleResultCallback.onResult(null, throwable);
                    } else {
                        singleResultCallback.onResult(this.getCountFromAggregateResults((List<BsonDocument>)list), null);
                    }
                });
            }
        });
    }

    private AggregateOperation<BsonDocument> getAggregateOperation() {
        return new AggregateOperation<BsonDocument>(this.namespace, this.getPipeline(), DECODER).retryReads(this.retryReads).collation(this.collation).comment(this.comment).hint(this.hint);
    }

    private List<BsonDocument> getPipeline() {
        ArrayList<BsonDocument> arrayList = new ArrayList<BsonDocument>();
        arrayList.add(new BsonDocument("$match", this.filter != null ? this.filter : new BsonDocument()));
        if (this.skip > 0L) {
            arrayList.add(new BsonDocument("$skip", new BsonInt64(this.skip)));
        }
        if (this.limit > 0L) {
            arrayList.add(new BsonDocument("$limit", new BsonInt64(this.limit)));
        }
        arrayList.add(new BsonDocument("$group", new BsonDocument("_id", new BsonInt32(1)).append("n", new BsonDocument("$sum", new BsonInt32(1)))));
        return arrayList;
    }

    private Long getCountFromAggregateResults(@Nullable List<BsonDocument> list) {
        if (list == null || list.isEmpty()) {
            return 0L;
        }
        return list.get(0).getNumber("n").longValue();
    }
}

