/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationReadConcernHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class CountOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private BsonDocument filter;
    private BsonValue hint;
    private long skip;
    private long limit;
    private Collation collation;

    public CountOperation(MongoNamespace mongoNamespace) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public CountOperation filter(BsonDocument bsonDocument) {
        this.filter = bsonDocument;
        return this;
    }

    public CountOperation retryReads(boolean bl) {
        this.retryReads = bl;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public CountOperation hint(BsonValue bsonValue) {
        this.hint = bsonValue;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public CountOperation limit(long l) {
        this.limit = l;
        return this;
    }

    public long getSkip() {
        return this.skip;
    }

    public CountOperation skip(long l) {
        this.skip = l;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CountOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public Long execute(ReadBinding readBinding) {
        return SyncOperationHelper.executeRetryableRead(readBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), DECODER, this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<Long> singleResultCallback) {
        AsyncOperationHelper.executeRetryableReadAsync(asyncReadBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), DECODER, this.asyncTransformer(), this.retryReads, singleResultCallback);
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, Long> transformer() {
        return (bsonDocument, connectionSource, connection) -> bsonDocument.getNumber("n").longValue();
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, Long> asyncTransformer() {
        return (bsonDocument, asyncConnectionSource, asyncConnection) -> bsonDocument.getNumber("n").longValue();
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = new BsonDocument("count", new BsonString(this.namespace.getCollectionName()));
            OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), connectionDescription.getMaxWireVersion(), bsonDocument);
            DocumentHelper.putIfNotNull(bsonDocument, "query", this.filter);
            DocumentHelper.putIfNotZero(bsonDocument, "limit", this.limit);
            DocumentHelper.putIfNotZero(bsonDocument, "skip", this.skip);
            DocumentHelper.putIfNotNull(bsonDocument, "hint", this.hint);
            if (this.collation != null) {
                bsonDocument.put("collation", this.collation.asDocument());
            }
            return bsonDocument;
        };
    }
}

