/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.ChangeStreamPreAndPostImagesOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.TimeSeriesGranularity;
import com.mongodb.client.model.TimeSeriesOptions;
import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonString;

public class CreateCollectionOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private static final String ENCRYPT_PREFIX = "enxcol_.";
    private static final BsonDocument ENCRYPT_CLUSTERED_INDEX = BsonDocument.parse("{key: {_id: 1}, unique: true}");
    private static final BsonArray SAFE_CONTENT_ARRAY = new BsonArray(Collections.singletonList(BsonDocument.parse("{key: {__safeContent__: 1}, name: '__safeContent___1'}")));
    private final String databaseName;
    private final String collectionName;
    private final WriteConcern writeConcern;
    private boolean capped = false;
    private long sizeInBytes = 0L;
    private boolean autoIndex = true;
    private long maxDocuments = 0L;
    private BsonDocument storageEngineOptions;
    private BsonDocument indexOptionDefaults;
    private BsonDocument validator;
    private ValidationLevel validationLevel = null;
    private ValidationAction validationAction = null;
    private Collation collation = null;
    private long expireAfterSeconds;
    private TimeSeriesOptions timeSeriesOptions;
    private ChangeStreamPreAndPostImagesOptions changeStreamPreAndPostImagesOptions;
    private BsonDocument clusteredIndexKey;
    private boolean clusteredIndexUnique;
    private String clusteredIndexName;
    private BsonDocument encryptedFields;

    public CreateCollectionOperation(String string, String string2, @Nullable WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", string);
        this.collectionName = Assertions.notNull("collectionName", string2);
        this.writeConcern = writeConcern;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isAutoIndex() {
        return this.autoIndex;
    }

    public CreateCollectionOperation autoIndex(boolean bl) {
        this.autoIndex = bl;
        return this;
    }

    public long getMaxDocuments() {
        return this.maxDocuments;
    }

    public CreateCollectionOperation maxDocuments(long l) {
        this.maxDocuments = l;
        return this;
    }

    public boolean isCapped() {
        return this.capped;
    }

    public CreateCollectionOperation capped(boolean bl) {
        this.capped = bl;
        return this;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public CreateCollectionOperation sizeInBytes(long l) {
        this.sizeInBytes = l;
        return this;
    }

    public BsonDocument getStorageEngineOptions() {
        return this.storageEngineOptions;
    }

    public CreateCollectionOperation storageEngineOptions(@Nullable BsonDocument bsonDocument) {
        this.storageEngineOptions = bsonDocument;
        return this;
    }

    public BsonDocument getIndexOptionDefaults() {
        return this.indexOptionDefaults;
    }

    public CreateCollectionOperation indexOptionDefaults(@Nullable BsonDocument bsonDocument) {
        this.indexOptionDefaults = bsonDocument;
        return this;
    }

    public BsonDocument getValidator() {
        return this.validator;
    }

    public CreateCollectionOperation validator(@Nullable BsonDocument bsonDocument) {
        this.validator = bsonDocument;
        return this;
    }

    public ValidationLevel getValidationLevel() {
        return this.validationLevel;
    }

    public CreateCollectionOperation validationLevel(@Nullable ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
        return this;
    }

    public ValidationAction getValidationAction() {
        return this.validationAction;
    }

    public CreateCollectionOperation validationAction(@Nullable ValidationAction validationAction) {
        this.validationAction = validationAction;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CreateCollectionOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public CreateCollectionOperation expireAfter(long l) {
        this.expireAfterSeconds = l;
        return this;
    }

    public CreateCollectionOperation timeSeriesOptions(@Nullable TimeSeriesOptions timeSeriesOptions) {
        this.timeSeriesOptions = timeSeriesOptions;
        return this;
    }

    public CreateCollectionOperation changeStreamPreAndPostImagesOptions(@Nullable ChangeStreamPreAndPostImagesOptions changeStreamPreAndPostImagesOptions) {
        this.changeStreamPreAndPostImagesOptions = changeStreamPreAndPostImagesOptions;
        return this;
    }

    public CreateCollectionOperation clusteredIndexKey(@Nullable BsonDocument bsonDocument) {
        this.clusteredIndexKey = bsonDocument;
        return this;
    }

    public CreateCollectionOperation clusteredIndexUnique(boolean bl) {
        this.clusteredIndexUnique = bl;
        return this;
    }

    public CreateCollectionOperation clusteredIndexName(@Nullable String string) {
        this.clusteredIndexName = string;
        return this;
    }

    public CreateCollectionOperation encryptedFields(@Nullable BsonDocument bsonDocument) {
        this.encryptedFields = bsonDocument;
        return this;
    }

    @Override
    public Void execute(WriteBinding writeBinding) {
        return SyncOperationHelper.withConnection(writeBinding, connection -> {
            this.checkEncryptedFieldsSupported(connection.getDescription());
            this.getCommandFunctions().forEach(supplier -> SyncOperationHelper.executeCommand(writeBinding, this.databaseName, (BsonDocument)supplier.get(), connection, SyncOperationHelper.writeConcernErrorTransformer(writeBinding.getOperationContext().getTimeoutContext())));
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<Void> singleResultCallback) {
        AsyncOperationHelper.withAsyncConnection(asyncWriteBinding, (asyncConnection, throwable) -> {
            SingleResultCallback<Object> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER);
            if (throwable != null) {
                singleResultCallback2.onResult(null, throwable);
            } else {
                SingleResultCallback<Void> singleResultCallback3 = AsyncOperationHelper.releasingCallback(singleResultCallback2, asyncConnection);
                if (!this.checkEncryptedFieldsSupported(asyncConnection.getDescription(), singleResultCallback3)) {
                    return;
                }
                new ProcessCommandsCallback(asyncWriteBinding, asyncConnection, singleResultCallback3).onResult(null, null);
            }
        });
    }

    private String getGranularityAsString(TimeSeriesGranularity timeSeriesGranularity) {
        switch (timeSeriesGranularity) {
            case SECONDS: {
                return "seconds";
            }
            case MINUTES: {
                return "minutes";
            }
            case HOURS: {
                return "hours";
            }
        }
        throw new AssertionError((Object)("Unexpected granularity " + (Object)((Object)timeSeriesGranularity)));
    }

    private List<Supplier<BsonDocument>> getCommandFunctions() {
        if (this.encryptedFields == null) {
            return Collections.singletonList(this::getCreateCollectionCommand);
        }
        return Arrays.asList(() -> this.getCreateEncryptedFieldsCollectionCommand("esc"), () -> this.getCreateEncryptedFieldsCollectionCommand("ecoc"), this::getCreateCollectionCommand, () -> new BsonDocument("createIndexes", new BsonString(this.collectionName)).append("indexes", SAFE_CONTENT_ARRAY));
    }

    private BsonDocument getCreateEncryptedFieldsCollectionCommand(String string) {
        return new BsonDocument().append("create", this.encryptedFields.getOrDefault(string + "Collection", new BsonString(ENCRYPT_PREFIX + this.collectionName + "." + string))).append("clusteredIndex", ENCRYPT_CLUSTERED_INDEX);
    }

    private BsonDocument getCreateCollectionCommand() {
        BsonDocument bsonDocument;
        BsonDocument bsonDocument2 = new BsonDocument("create", new BsonString(this.collectionName));
        DocumentHelper.putIfFalse(bsonDocument2, "autoIndexId", this.autoIndex);
        bsonDocument2.put("capped", BsonBoolean.valueOf(this.capped));
        if (this.capped) {
            DocumentHelper.putIfNotZero(bsonDocument2, "size", this.sizeInBytes);
            DocumentHelper.putIfNotZero(bsonDocument2, "max", this.maxDocuments);
        }
        DocumentHelper.putIfNotNull(bsonDocument2, "storageEngine", this.storageEngineOptions);
        DocumentHelper.putIfNotNull(bsonDocument2, "indexOptionDefaults", this.indexOptionDefaults);
        DocumentHelper.putIfNotNull(bsonDocument2, "validator", this.validator);
        if (this.validationLevel != null) {
            bsonDocument2.put("validationLevel", new BsonString(this.validationLevel.getValue()));
        }
        if (this.validationAction != null) {
            bsonDocument2.put("validationAction", new BsonString(this.validationAction.getValue()));
        }
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, bsonDocument2);
        if (this.collation != null) {
            bsonDocument2.put("collation", this.collation.asDocument());
        }
        DocumentHelper.putIfNotZero(bsonDocument2, "expireAfterSeconds", this.expireAfterSeconds);
        if (this.timeSeriesOptions != null) {
            Long l;
            Long l2;
            TimeSeriesGranularity timeSeriesGranularity;
            bsonDocument = new BsonDocument("timeField", new BsonString(this.timeSeriesOptions.getTimeField()));
            String string = this.timeSeriesOptions.getMetaField();
            if (string != null) {
                bsonDocument.put("metaField", new BsonString(string));
            }
            if ((timeSeriesGranularity = this.timeSeriesOptions.getGranularity()) != null) {
                bsonDocument.put("granularity", new BsonString(this.getGranularityAsString(timeSeriesGranularity)));
            }
            if ((l2 = this.timeSeriesOptions.getBucketMaxSpan(TimeUnit.SECONDS)) != null) {
                bsonDocument.put("bucketMaxSpanSeconds", new BsonInt64(l2));
            }
            if ((l = this.timeSeriesOptions.getBucketRounding(TimeUnit.SECONDS)) != null) {
                bsonDocument.put("bucketRoundingSeconds", new BsonInt64(l));
            }
            bsonDocument2.put("timeseries", bsonDocument);
        }
        if (this.changeStreamPreAndPostImagesOptions != null) {
            bsonDocument2.put("changeStreamPreAndPostImages", new BsonDocument("enabled", BsonBoolean.valueOf(this.changeStreamPreAndPostImagesOptions.isEnabled())));
        }
        if (this.clusteredIndexKey != null) {
            bsonDocument = new BsonDocument().append("key", this.clusteredIndexKey).append("unique", BsonBoolean.valueOf(this.clusteredIndexUnique));
            if (this.clusteredIndexName != null) {
                bsonDocument.put("name", new BsonString(this.clusteredIndexName));
            }
            bsonDocument2.put("clusteredIndex", bsonDocument);
        }
        DocumentHelper.putIfNotNull(bsonDocument2, "encryptedFields", this.encryptedFields);
        return bsonDocument2;
    }

    private void checkEncryptedFieldsSupported(ConnectionDescription connectionDescription) throws MongoException {
        if (this.encryptedFields != null && ServerVersionHelper.serverIsLessThanVersionSevenDotZero(connectionDescription)) {
            throw new MongoClientException("Driver support of Queryable Encryption is incompatible with server. Upgrade server to use Queryable Encryption.");
        }
    }

    private boolean checkEncryptedFieldsSupported(ConnectionDescription connectionDescription, SingleResultCallback<Void> singleResultCallback) {
        try {
            this.checkEncryptedFieldsSupported(connectionDescription);
            return true;
        }
        catch (Exception exception) {
            singleResultCallback.onResult(null, exception);
            return false;
        }
    }

    class ProcessCommandsCallback
    implements SingleResultCallback<Void> {
        private final AsyncWriteBinding binding;
        private final AsyncConnection connection;
        private final SingleResultCallback<Void> finalCallback;
        private final Deque<Supplier<BsonDocument>> commands;

        ProcessCommandsCallback(AsyncWriteBinding asyncWriteBinding, AsyncConnection asyncConnection, SingleResultCallback<Void> singleResultCallback) {
            this.binding = asyncWriteBinding;
            this.connection = asyncConnection;
            this.finalCallback = singleResultCallback;
            this.commands = new ArrayDeque<Supplier<BsonDocument>>(CreateCollectionOperation.this.getCommandFunctions());
        }

        @Override
        public void onResult(@Nullable Void void_, @Nullable Throwable throwable) {
            if (throwable != null) {
                this.finalCallback.onResult(null, throwable);
                return;
            }
            Supplier<BsonDocument> supplier = this.commands.poll();
            if (supplier == null) {
                this.finalCallback.onResult(null, null);
            } else {
                AsyncOperationHelper.executeCommandAsync(this.binding, CreateCollectionOperation.this.databaseName, supplier.get(), this.connection, AsyncOperationHelper.writeConcernErrorTransformerAsync(this.binding.getOperationContext().getTimeoutContext()), this);
            }
        }
    }
}

