/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.CreateIndexCommitQuorum;
import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoClientException;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.bulk.IndexRequest;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.IndexHelper;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;

public class CreateIndexesOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;
    private final List<IndexRequest> requests;
    private final WriteConcern writeConcern;
    private CreateIndexCommitQuorum commitQuorum;

    public CreateIndexesOperation(MongoNamespace mongoNamespace, List<IndexRequest> list, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.requests = Assertions.notNull("indexRequests", list);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public List<IndexRequest> getRequests() {
        return this.requests;
    }

    public List<String> getIndexNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.requests.size());
        for (IndexRequest indexRequest : this.requests) {
            if (indexRequest.getName() != null) {
                arrayList.add(indexRequest.getName());
                continue;
            }
            arrayList.add(IndexHelper.generateIndexName(indexRequest.getKeys()));
        }
        return arrayList;
    }

    public CreateIndexCommitQuorum getCommitQuorum() {
        return this.commitQuorum;
    }

    public CreateIndexesOperation commitQuorum(@Nullable CreateIndexCommitQuorum createIndexCommitQuorum) {
        this.commitQuorum = createIndexCommitQuorum;
        return this;
    }

    @Override
    public Void execute(WriteBinding writeBinding) {
        try {
            return SyncOperationHelper.executeCommand(writeBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), SyncOperationHelper.writeConcernErrorTransformer(writeBinding.getOperationContext().getTimeoutContext()));
        }
        catch (MongoCommandException mongoCommandException) {
            throw this.checkForDuplicateKeyError(mongoCommandException);
        }
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<Void> singleResultCallback) {
        AsyncOperationHelper.executeCommandAsync(asyncWriteBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), AsyncOperationHelper.writeConcernErrorTransformerAsync(asyncWriteBinding.getOperationContext().getTimeoutContext()), (void_, throwable) -> {
            if (throwable != null) {
                singleResultCallback.onResult(null, this.translateException(throwable));
            } else {
                singleResultCallback.onResult((Void)void_, null);
            }
        });
    }

    private BsonDocument getIndex(IndexRequest indexRequest) {
        BsonDocument bsonDocument = new BsonDocument();
        bsonDocument.append("key", indexRequest.getKeys());
        bsonDocument.append("name", new BsonString(indexRequest.getName() != null ? indexRequest.getName() : IndexHelper.generateIndexName(indexRequest.getKeys())));
        if (indexRequest.isBackground()) {
            bsonDocument.append("background", BsonBoolean.TRUE);
        }
        if (indexRequest.isUnique()) {
            bsonDocument.append("unique", BsonBoolean.TRUE);
        }
        if (indexRequest.isSparse()) {
            bsonDocument.append("sparse", BsonBoolean.TRUE);
        }
        if (indexRequest.getExpireAfter(TimeUnit.SECONDS) != null) {
            bsonDocument.append("expireAfterSeconds", new BsonInt64(Assertions.assertNotNull(indexRequest.getExpireAfter(TimeUnit.SECONDS))));
        }
        if (indexRequest.getVersion() != null) {
            bsonDocument.append("v", new BsonInt32(Assertions.assertNotNull(indexRequest.getVersion())));
        }
        if (indexRequest.getWeights() != null) {
            bsonDocument.append("weights", Assertions.assertNotNull(indexRequest.getWeights()));
        }
        if (indexRequest.getDefaultLanguage() != null) {
            bsonDocument.append("default_language", new BsonString(Assertions.assertNotNull(indexRequest.getDefaultLanguage())));
        }
        if (indexRequest.getLanguageOverride() != null) {
            bsonDocument.append("language_override", new BsonString(Assertions.assertNotNull(indexRequest.getLanguageOverride())));
        }
        if (indexRequest.getTextVersion() != null) {
            bsonDocument.append("textIndexVersion", new BsonInt32(Assertions.assertNotNull(indexRequest.getTextVersion())));
        }
        if (indexRequest.getSphereVersion() != null) {
            bsonDocument.append("2dsphereIndexVersion", new BsonInt32(Assertions.assertNotNull(indexRequest.getSphereVersion())));
        }
        if (indexRequest.getBits() != null) {
            bsonDocument.append("bits", new BsonInt32(Assertions.assertNotNull(indexRequest.getBits())));
        }
        if (indexRequest.getMin() != null) {
            bsonDocument.append("min", new BsonDouble(Assertions.assertNotNull(indexRequest.getMin())));
        }
        if (indexRequest.getMax() != null) {
            bsonDocument.append("max", new BsonDouble(Assertions.assertNotNull(indexRequest.getMax())));
        }
        if (indexRequest.getDropDups()) {
            bsonDocument.append("dropDups", BsonBoolean.TRUE);
        }
        if (indexRequest.getStorageEngine() != null) {
            bsonDocument.append("storageEngine", Assertions.assertNotNull(indexRequest.getStorageEngine()));
        }
        if (indexRequest.getPartialFilterExpression() != null) {
            bsonDocument.append("partialFilterExpression", Assertions.assertNotNull(indexRequest.getPartialFilterExpression()));
        }
        if (indexRequest.getCollation() != null) {
            bsonDocument.append("collation", Assertions.assertNotNull(indexRequest.getCollation().asDocument()));
        }
        if (indexRequest.getWildcardProjection() != null) {
            bsonDocument.append("wildcardProjection", Assertions.assertNotNull(indexRequest.getWildcardProjection()));
        }
        if (indexRequest.isHidden()) {
            bsonDocument.append("hidden", BsonBoolean.TRUE);
        }
        return bsonDocument;
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = new BsonDocument("createIndexes", new BsonString(this.namespace.getCollectionName()));
            ArrayList<BsonDocument> arrayList = new ArrayList<BsonDocument>();
            for (IndexRequest indexRequest : this.requests) {
                arrayList.add(this.getIndex(indexRequest));
            }
            bsonDocument.put("indexes", new BsonArray(arrayList));
            WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, bsonDocument);
            if (this.commitQuorum != null) {
                if (ServerVersionHelper.serverIsAtLeastVersionFourDotFour(connectionDescription)) {
                    bsonDocument.put("commitQuorum", this.commitQuorum.toBsonValue());
                } else {
                    throw new MongoClientException("Specifying a value for the create index commit quorum option requires a minimum MongoDB version of 4.4");
                }
            }
            return bsonDocument;
        };
    }

    @Nullable
    private MongoException translateException(@Nullable Throwable throwable) {
        return throwable instanceof MongoCommandException ? this.checkForDuplicateKeyError((MongoCommandException)throwable) : MongoException.fromThrowable(throwable);
    }

    private MongoException checkForDuplicateKeyError(MongoCommandException mongoCommandException) {
        if (ErrorCategory.fromErrorCode(mongoCommandException.getCode()) == ErrorCategory.DUPLICATE_KEY) {
            return new DuplicateKeyException(mongoCommandException.getResponse(), mongoCommandException.getServerAddress(), WriteConcernResult.acknowledged(0, false, null));
        }
        return mongoCommandException;
    }
}

