/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.SearchIndexType;
import com.mongodb.internal.operation.AbstractWriteSearchIndexOperation;
import com.mongodb.internal.operation.SearchIndexRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;

public final class CreateSearchIndexesOperation
extends AbstractWriteSearchIndexOperation {
    private static final String COMMAND_NAME = "createSearchIndexes";
    private final List<SearchIndexRequest> indexRequests;

    public CreateSearchIndexesOperation(MongoNamespace mongoNamespace, List<SearchIndexRequest> list) {
        super(mongoNamespace);
        this.indexRequests = Assertions.assertNotNull(list);
    }

    private static BsonArray convert(List<SearchIndexRequest> list) {
        return list.stream().map(CreateSearchIndexesOperation::convert).collect(Collectors.toCollection(BsonArray::new));
    }

    private static BsonDocument convert(SearchIndexRequest searchIndexRequest) {
        SearchIndexType searchIndexType;
        BsonDocument bsonDocument = new BsonDocument();
        String string = searchIndexRequest.getIndexName();
        if (string != null) {
            bsonDocument.append("name", new BsonString(string));
        }
        if ((searchIndexType = searchIndexRequest.getSearchIndexType()) != null) {
            bsonDocument.append("type", searchIndexType.toBsonValue());
        }
        bsonDocument.append("definition", searchIndexRequest.getDefinition());
        return bsonDocument;
    }

    @Override
    BsonDocument buildCommand() {
        return new BsonDocument(COMMAND_NAME, new BsonString(this.getNamespace().getCollectionName())).append("indexes", CreateSearchIndexesOperation.convert(this.indexRequests));
    }
}

