/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.codecs.BsonDocumentCodec;

public class CreateViewOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final String databaseName;
    private final String viewName;
    private final String viewOn;
    private final List<BsonDocument> pipeline;
    private final WriteConcern writeConcern;
    private Collation collation;

    public CreateViewOperation(String string, String string2, String string3, List<BsonDocument> list, WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", string);
        this.viewName = Assertions.notNull("viewName", string2);
        this.viewOn = Assertions.notNull("viewOn", string3);
        this.pipeline = Assertions.notNull("pipeline", list);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getViewOn() {
        return this.viewOn;
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CreateViewOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public Void execute(WriteBinding writeBinding) {
        return SyncOperationHelper.withConnection(writeBinding, connection -> {
            SyncOperationHelper.executeCommand(writeBinding, this.databaseName, this.getCommand(), new BsonDocumentCodec(), SyncOperationHelper.writeConcernErrorTransformer(writeBinding.getOperationContext().getTimeoutContext()));
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<Void> singleResultCallback) {
        AsyncOperationHelper.withAsyncConnection(asyncWriteBinding, (asyncConnection, throwable) -> {
            SingleResultCallback<Object> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER);
            if (throwable != null) {
                singleResultCallback2.onResult(null, throwable);
            } else {
                SingleResultCallback singleResultCallback3 = AsyncOperationHelper.releasingCallback(singleResultCallback2, asyncConnection);
                AsyncOperationHelper.executeCommandAsync(asyncWriteBinding, this.databaseName, this.getCommand(), asyncConnection, AsyncOperationHelper.writeConcernErrorTransformerAsync(asyncWriteBinding.getOperationContext().getTimeoutContext()), singleResultCallback3);
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument bsonDocument = new BsonDocument("create", new BsonString(this.viewName)).append("viewOn", new BsonString(this.viewOn)).append("pipeline", new BsonArray(this.pipeline));
        if (this.collation != null) {
            bsonDocument.put("collation", this.collation.asDocument());
        }
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, bsonDocument);
        return bsonDocument;
    }
}

