/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.MongoSocketException;
import com.mongodb.ServerCursor;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.Locks;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.connection.Connection;
import com.mongodb.lang.Nullable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
abstract class CursorResourceManager<CS extends ReferenceCounted, C extends ReferenceCounted> {
    private final Lock lock = new ReentrantLock();
    private final MongoNamespace namespace;
    private volatile State state;
    @Nullable
    private volatile CS connectionSource;
    @Nullable
    private volatile C pinnedConnection;
    @Nullable
    private volatile ServerCursor serverCursor;
    private volatile boolean skipReleasingServerResourcesOnClose;

    CursorResourceManager(MongoNamespace mongoNamespace, CS CS, @Nullable C c, @Nullable ServerCursor serverCursor) {
        this.namespace = mongoNamespace;
        this.state = State.IDLE;
        if (serverCursor != null) {
            CS.retain();
            this.connectionSource = CS;
            if (c != null) {
                c.retain();
                this.markAsPinned(c, Connection.PinningMode.CURSOR);
                this.pinnedConnection = c;
            }
        }
        this.skipReleasingServerResourcesOnClose = false;
        this.serverCursor = serverCursor;
    }

    MongoNamespace getNamespace() {
        return this.namespace;
    }

    State getState() {
        return this.state;
    }

    @Nullable
    CS getConnectionSource() {
        return this.connectionSource;
    }

    @Nullable
    C getPinnedConnection() {
        return this.pinnedConnection;
    }

    boolean isSkipReleasingServerResourcesOnClose() {
        return this.skipReleasingServerResourcesOnClose;
    }

    abstract void markAsPinned(C var1, Connection.PinningMode var2);

    boolean operable() {
        return this.state.operable();
    }

    boolean tryStartOperation() throws IllegalStateException {
        return Locks.withLock(this.lock, () -> {
            State state = this.state;
            if (!state.operable()) {
                return false;
            }
            if (state == State.IDLE) {
                this.state = State.OPERATION_IN_PROGRESS;
                return true;
            }
            if (state == State.OPERATION_IN_PROGRESS) {
                throw new IllegalStateException("Another operation is currently in progress, concurrent operations are not supported");
            }
            throw Assertions.fail(this.state.toString());
        });
    }

    void endOperation() {
        boolean bl = Locks.withLock(this.lock, () -> {
            State state = this.state;
            if (state == State.OPERATION_IN_PROGRESS) {
                this.state = State.IDLE;
            } else {
                if (state == State.CLOSE_PENDING) {
                    this.state = State.CLOSED;
                    return true;
                }
                if (state != State.CLOSED) {
                    throw Assertions.fail(state.toString());
                }
            }
            return false;
        });
        if (bl) {
            this.doClose();
        }
    }

    void close() {
        boolean bl = Locks.withLock(this.lock, () -> {
            State state = this.state;
            if (state.inProgress()) {
                this.state = State.CLOSE_PENDING;
            } else if (state != State.CLOSED) {
                this.state = State.CLOSED;
                return true;
            }
            return false;
        });
        if (bl) {
            this.doClose();
        }
    }

    abstract void doClose();

    void onCorruptedConnection(@Nullable C c, MongoSocketException mongoSocketException) {
        C c2 = this.pinnedConnection;
        if (c2 != null) {
            if (c != c2) {
                mongoSocketException.addSuppressed((Throwable)((Object)new AssertionError((Object)"Corrupted connection does not equal the pinned connection.")));
            }
            this.skipReleasingServerResourcesOnClose = true;
        }
    }

    @Nullable
    final ServerCursor getServerCursor() {
        return this.serverCursor;
    }

    void setServerCursor(@Nullable ServerCursor serverCursor) {
        Assertions.assertTrue(this.state.inProgress());
        Assertions.assertNotNull(this.serverCursor);
        Assertions.assertNotNull(this.connectionSource);
        this.serverCursor = serverCursor;
        if (serverCursor == null) {
            this.releaseClientResources();
        }
    }

    void unsetServerCursor() {
        this.serverCursor = null;
    }

    void releaseClientResources() {
        C c;
        Assertions.assertNull(this.serverCursor);
        CS CS = this.connectionSource;
        if (CS != null) {
            CS.release();
            this.connectionSource = null;
        }
        if ((c = this.pinnedConnection) != null) {
            c.release();
            this.pinnedConnection = null;
        }
    }

    static enum State {
        IDLE(true, false),
        OPERATION_IN_PROGRESS(true, true),
        CLOSE_PENDING(false, true),
        CLOSED(false, false);

        private final boolean operable;
        private final boolean inProgress;

        private State(boolean bl, boolean bl2) {
            this.operable = bl;
            this.inProgress = bl2;
        }

        boolean operable() {
            return this.operable;
        }

        boolean inProgress() {
            return this.inProgress;
        }
    }
}

