/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.lang.Nullable;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;

final class DocumentHelper {
    private DocumentHelper() {
    }

    static void putIfTrue(BsonDocument bsonDocument, String string, boolean bl) {
        if (bl) {
            bsonDocument.put(string, BsonBoolean.TRUE);
        }
    }

    static void putIfFalse(BsonDocument bsonDocument, String string, boolean bl) {
        if (!bl) {
            bsonDocument.put(string, BsonBoolean.FALSE);
        }
    }

    static void putIfNotNullOrEmpty(BsonDocument bsonDocument, String string, @Nullable BsonDocument bsonDocument2) {
        if (bsonDocument2 != null && !bsonDocument2.isEmpty()) {
            bsonDocument.put(string, bsonDocument2);
        }
    }

    static void putIfNotNull(BsonDocument bsonDocument, String string, @Nullable BsonValue bsonValue) {
        if (bsonValue != null) {
            bsonDocument.put(string, bsonValue);
        }
    }

    static void putIfNotNull(BsonDocument bsonDocument, String string, @Nullable String string2) {
        if (string2 != null) {
            bsonDocument.put(string, new BsonString(string2));
        }
    }

    static void putIfNotNull(BsonDocument bsonDocument, String string, @Nullable Boolean bl) {
        if (bl != null) {
            bsonDocument.put(string, new BsonBoolean(bl));
        }
    }

    static void putIfNotZero(BsonDocument bsonDocument, String string, int n) {
        if (n != 0) {
            bsonDocument.put(string, new BsonInt32(n));
        }
    }

    static void putIfNotZero(BsonDocument bsonDocument, String string, long l) {
        if (l != 0L) {
            bsonDocument.put(string, new BsonInt64(l));
        }
    }
}

