/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.ListCollectionsOperation;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonValueCodec;

public class DropCollectionOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private static final String ENCRYPT_PREFIX = "enxcol_.";
    private static final BsonValueCodec BSON_VALUE_CODEC = new BsonValueCodec();
    private final MongoNamespace namespace;
    private final WriteConcern writeConcern;
    private BsonDocument encryptedFields;
    private boolean autoEncryptedFields;

    public DropCollectionOperation(MongoNamespace mongoNamespace, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public DropCollectionOperation encryptedFields(BsonDocument bsonDocument) {
        this.encryptedFields = bsonDocument;
        return this;
    }

    public DropCollectionOperation autoEncryptedFields(boolean bl) {
        this.autoEncryptedFields = bl;
        return this;
    }

    @Override
    public Void execute(WriteBinding writeBinding) {
        BsonDocument bsonDocument = this.getEncryptedFields((ReadWriteBinding)writeBinding);
        return SyncOperationHelper.withConnection(writeBinding, connection -> {
            this.getCommands(bsonDocument).forEach(supplier -> {
                try {
                    SyncOperationHelper.executeCommand(writeBinding, this.namespace.getDatabaseName(), (BsonDocument)supplier.get(), connection, SyncOperationHelper.writeConcernErrorTransformer(writeBinding.getOperationContext().getTimeoutContext()));
                }
                catch (MongoCommandException mongoCommandException) {
                    CommandOperationHelper.rethrowIfNotNamespaceError(mongoCommandException);
                }
            });
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<Void> singleResultCallback) {
        SingleResultCallback<Void> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER);
        this.getEncryptedFields((AsyncReadWriteBinding)asyncWriteBinding, (bsonDocument, throwable2) -> {
            if (throwable2 != null) {
                singleResultCallback2.onResult(null, throwable2);
            } else {
                AsyncOperationHelper.withAsyncConnection(asyncWriteBinding, (asyncConnection, throwable) -> {
                    if (throwable != null) {
                        singleResultCallback2.onResult(null, throwable);
                    } else {
                        new ProcessCommandsCallback(asyncWriteBinding, asyncConnection, this.getCommands((BsonDocument)bsonDocument), AsyncOperationHelper.releasingCallback(singleResultCallback2, asyncConnection)).onResult(null, null);
                    }
                });
            }
        });
    }

    private List<Supplier<BsonDocument>> getCommands(BsonDocument bsonDocument) {
        if (bsonDocument == null) {
            return Collections.singletonList(this::dropCollectionCommand);
        }
        return Arrays.asList(() -> this.getDropEncryptedFieldsCollectionCommand(bsonDocument, "esc"), () -> this.getDropEncryptedFieldsCollectionCommand(bsonDocument, "ecoc"), this::dropCollectionCommand);
    }

    private BsonDocument getDropEncryptedFieldsCollectionCommand(BsonDocument bsonDocument, String string) {
        BsonString bsonString = new BsonString(ENCRYPT_PREFIX + this.namespace.getCollectionName() + "." + string);
        return new BsonDocument("drop", bsonDocument.getOrDefault(string + "Collection", bsonString));
    }

    private BsonDocument dropCollectionCommand() {
        BsonDocument bsonDocument = new BsonDocument("drop", new BsonString(this.namespace.getCollectionName()));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, bsonDocument);
        return bsonDocument;
    }

    @Nullable
    private BsonDocument getEncryptedFields(ReadWriteBinding readWriteBinding) {
        if (this.encryptedFields == null && this.autoEncryptedFields) {
            try (Object object = this.listCollectionOperation().execute(readWriteBinding);){
                BsonDocument bsonDocument = this.getCollectionEncryptedFields(this.encryptedFields, object.tryNext());
                return bsonDocument;
            }
        }
        return this.encryptedFields;
    }

    private void getEncryptedFields(AsyncReadWriteBinding asyncReadWriteBinding, SingleResultCallback<BsonDocument> singleResultCallback) {
        if (this.encryptedFields == null && this.autoEncryptedFields) {
            this.listCollectionOperation().executeAsync((AsyncReadBinding)asyncReadWriteBinding, (asyncBatchCursor, throwable2) -> {
                if (throwable2 != null) {
                    singleResultCallback.onResult(null, throwable2);
                } else {
                    asyncBatchCursor.next((list, throwable) -> {
                        if (throwable != null) {
                            singleResultCallback.onResult(null, throwable);
                        } else {
                            singleResultCallback.onResult(this.getCollectionEncryptedFields(this.encryptedFields, (List<BsonValue>)list), null);
                        }
                    });
                }
            });
        } else {
            singleResultCallback.onResult(this.encryptedFields, null);
        }
    }

    private BsonDocument getCollectionEncryptedFields(BsonDocument bsonDocument, @Nullable List<BsonValue> list) {
        if (list != null && list.size() > 0) {
            return list.get(0).asDocument().getDocument("options", new BsonDocument()).getDocument("encryptedFields", new BsonDocument());
        }
        return bsonDocument;
    }

    private ListCollectionsOperation<BsonValue> listCollectionOperation() {
        return new ListCollectionsOperation<BsonValue>(this.namespace.getDatabaseName(), BSON_VALUE_CODEC).filter(new BsonDocument("name", new BsonString(this.namespace.getCollectionName()))).batchSize(1);
    }

    class ProcessCommandsCallback
    implements SingleResultCallback<Void> {
        private final AsyncWriteBinding binding;
        private final AsyncConnection connection;
        private final SingleResultCallback<Void> finalCallback;
        private final Deque<Supplier<BsonDocument>> commands;

        ProcessCommandsCallback(AsyncWriteBinding asyncWriteBinding, AsyncConnection asyncConnection, List<Supplier<BsonDocument>> list, SingleResultCallback<Void> singleResultCallback) {
            this.binding = asyncWriteBinding;
            this.connection = asyncConnection;
            this.finalCallback = singleResultCallback;
            this.commands = new ArrayDeque<Supplier<BsonDocument>>(list);
        }

        @Override
        public void onResult(@Nullable Void void_, @Nullable Throwable throwable) {
            if (throwable != null && !CommandOperationHelper.isNamespaceError(throwable)) {
                this.finalCallback.onResult(null, throwable);
                return;
            }
            Supplier<BsonDocument> supplier = this.commands.poll();
            if (supplier == null) {
                this.finalCallback.onResult(null, null);
            } else {
                try {
                    AsyncOperationHelper.executeCommandAsync(this.binding, DropCollectionOperation.this.namespace.getDatabaseName(), supplier.get(), this.connection, AsyncOperationHelper.writeConcernErrorTransformerAsync(this.binding.getOperationContext().getTimeoutContext()), this);
                }
                catch (MongoOperationTimeoutException mongoOperationTimeoutException) {
                    this.finalCallback.onResult(null, mongoOperationTimeoutException);
                }
            }
        }
    }
}

