/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonInt32;

public class DropDatabaseOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final String databaseName;
    private final WriteConcern writeConcern;

    public DropDatabaseOperation(String string, @Nullable WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", string);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(WriteBinding writeBinding) {
        return SyncOperationHelper.withConnection(writeBinding, connection -> {
            SyncOperationHelper.executeCommand(writeBinding, this.databaseName, this.getCommand(), connection, SyncOperationHelper.writeConcernErrorTransformer(writeBinding.getOperationContext().getTimeoutContext()));
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<Void> singleResultCallback) {
        AsyncOperationHelper.withAsyncConnection(asyncWriteBinding, (asyncConnection, throwable) -> {
            SingleResultCallback<Object> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER);
            if (throwable != null) {
                singleResultCallback2.onResult(null, throwable);
            } else {
                AsyncOperationHelper.executeCommandAsync(asyncWriteBinding, this.databaseName, this.getCommand(), asyncConnection, AsyncOperationHelper.writeConcernErrorTransformerAsync(asyncWriteBinding.getOperationContext().getTimeoutContext()), AsyncOperationHelper.releasingCallback(singleResultCallback2, asyncConnection));
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument bsonDocument = new BsonDocument("dropDatabase", new BsonInt32(1));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, bsonDocument);
        return bsonDocument;
    }
}

