/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;

public class DropIndexOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;
    private final String indexName;
    private final BsonDocument indexKeys;
    private final WriteConcern writeConcern;

    public DropIndexOperation(MongoNamespace mongoNamespace, String string, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.indexName = Assertions.notNull("indexName", string);
        this.indexKeys = null;
        this.writeConcern = writeConcern;
    }

    public DropIndexOperation(MongoNamespace mongoNamespace, BsonDocument bsonDocument, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.indexKeys = Assertions.notNull("indexKeys", bsonDocument);
        this.indexName = null;
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(WriteBinding writeBinding) {
        try {
            SyncOperationHelper.executeCommand(writeBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), SyncOperationHelper.writeConcernErrorTransformer(writeBinding.getOperationContext().getTimeoutContext()));
        }
        catch (MongoCommandException mongoCommandException) {
            CommandOperationHelper.rethrowIfNotNamespaceError(mongoCommandException);
        }
        return null;
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<Void> singleResultCallback) {
        AsyncOperationHelper.executeCommandAsync(asyncWriteBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), AsyncOperationHelper.writeConcernErrorTransformerAsync(asyncWriteBinding.getOperationContext().getTimeoutContext()), (void_, throwable) -> {
            if (throwable != null && !CommandOperationHelper.isNamespaceError(throwable)) {
                singleResultCallback.onResult(null, throwable);
            } else {
                singleResultCallback.onResult(null, null);
            }
        });
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = new BsonDocument("dropIndexes", new BsonString(this.namespace.getCollectionName()));
            if (this.indexName != null) {
                bsonDocument.put("index", new BsonString(this.indexName));
            } else {
                bsonDocument.put("index", this.indexKeys);
            }
            WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, bsonDocument);
            return bsonDocument;
        };
    }
}

