/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.OperationReadConcernHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class EstimatedDocumentCountOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private BsonValue comment;

    public EstimatedDocumentCountOperation(MongoNamespace mongoNamespace) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
    }

    public EstimatedDocumentCountOperation retryReads(boolean bl) {
        this.retryReads = bl;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public EstimatedDocumentCountOperation comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    @Override
    public Long execute(ReadBinding readBinding) {
        try {
            return SyncOperationHelper.executeRetryableRead(readBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.transformer(), this.retryReads);
        }
        catch (MongoCommandException mongoCommandException) {
            return Assertions.assertNotNull(CommandOperationHelper.rethrowIfNotNamespaceError(mongoCommandException, 0L));
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<Long> singleResultCallback) {
        AsyncOperationHelper.executeRetryableReadAsync(asyncReadBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.asyncTransformer(), this.retryReads, (l, throwable) -> {
            if (CommandOperationHelper.isNamespaceError(throwable)) {
                singleResultCallback.onResult(0L, null);
            } else {
                singleResultCallback.onResult((Long)l, throwable);
            }
        });
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, Long> transformer() {
        return (bsonDocument, connectionSource, connection) -> this.transformResult((BsonDocument)bsonDocument, connection.getDescription());
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, Long> asyncTransformer() {
        return (bsonDocument, asyncConnectionSource, asyncConnection) -> this.transformResult((BsonDocument)bsonDocument, asyncConnection.getDescription());
    }

    private long transformResult(BsonDocument bsonDocument, ConnectionDescription connectionDescription) {
        return bsonDocument.getNumber("n").longValue();
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = new BsonDocument("count", new BsonString(this.namespace.getCollectionName()));
            OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), connectionDescription.getMaxWireVersion(), bsonDocument);
            if (this.comment != null) {
                bsonDocument.put("comment", this.comment);
            }
            return bsonDocument;
        };
    }
}

