/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoInternalException;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;

final class ExplainHelper {
    static BsonDocument asExplainCommand(BsonDocument bsonDocument, @Nullable ExplainVerbosity explainVerbosity) {
        BsonDocument bsonDocument2 = new BsonDocument("explain", bsonDocument);
        if (explainVerbosity != null) {
            bsonDocument2.append("verbosity", ExplainHelper.getVerbosityAsString(explainVerbosity));
        }
        return bsonDocument2;
    }

    private static BsonString getVerbosityAsString(ExplainVerbosity explainVerbosity) {
        switch (explainVerbosity) {
            case QUERY_PLANNER: {
                return new BsonString("queryPlanner");
            }
            case EXECUTION_STATS: {
                return new BsonString("executionStats");
            }
            case ALL_PLANS_EXECUTIONS: {
                return new BsonString("allPlansExecution");
            }
        }
        throw new MongoInternalException(String.format("Unsupported explain verbosity %s", new Object[]{explainVerbosity}));
    }

    private ExplainHelper() {
    }
}

