/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoWriteConcernException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcernResult;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.lang.Nullable;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;

final class FindAndModifyHelper {
    static <T> SyncOperationHelper.CommandWriteTransformer<BsonDocument, T> transformer() {
        return (bsonDocument, connection) -> FindAndModifyHelper.transformDocument(bsonDocument, connection.getDescription().getServerAddress());
    }

    static <T> AsyncOperationHelper.CommandWriteTransformerAsync<BsonDocument, T> asyncTransformer() {
        return (bsonDocument, asyncConnection) -> FindAndModifyHelper.transformDocument(bsonDocument, asyncConnection.getDescription().getServerAddress());
    }

    @Nullable
    private static <T> T transformDocument(BsonDocument bsonDocument, ServerAddress serverAddress) {
        if (WriteConcernHelper.hasWriteConcernError(bsonDocument)) {
            throw new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(bsonDocument.getDocument("writeConcernError")), FindAndModifyHelper.createWriteConcernResult(bsonDocument.getDocument("lastErrorObject", new BsonDocument())), serverAddress, bsonDocument.getArray("errorLabels", new BsonArray()).stream().map(bsonValue -> bsonValue.asString().getValue()).collect(Collectors.toSet()));
        }
        if (!bsonDocument.isDocument("value")) {
            return null;
        }
        return BsonDocumentWrapperHelper.toDocument(bsonDocument.getDocument("value", null));
    }

    private static WriteConcernResult createWriteConcernResult(BsonDocument bsonDocument) {
        BsonBoolean bsonBoolean = bsonDocument.getBoolean("updatedExisting", BsonBoolean.FALSE);
        return WriteConcernResult.acknowledged(bsonDocument.getNumber("n", new BsonInt32(0)).intValue(), bsonBoolean.getValue(), bsonDocument.get("upserted"));
    }

    private FindAndModifyHelper() {
    }
}

