/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.operation.BaseFindAndModifyOperation;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.validator.MappedFieldNameValidator;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.internal.validator.ReplacingDocumentFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

public class FindAndReplaceOperation<T>
extends BaseFindAndModifyOperation<T> {
    private final BsonDocument replacement;
    private boolean returnOriginal = true;
    private boolean upsert;
    private Boolean bypassDocumentValidation;

    public FindAndReplaceOperation(MongoNamespace mongoNamespace, WriteConcern writeConcern, boolean bl, Decoder<T> decoder, BsonDocument bsonDocument) {
        super(mongoNamespace, writeConcern, bl, decoder);
        this.replacement = Assertions.notNull("replacement", bsonDocument);
    }

    public BsonDocument getReplacement() {
        return this.replacement;
    }

    public boolean isReturnOriginal() {
        return this.returnOriginal;
    }

    public FindAndReplaceOperation<T> returnOriginal(boolean bl) {
        this.returnOriginal = bl;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public FindAndReplaceOperation<T> upsert(boolean bl) {
        this.upsert = bl;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public FindAndReplaceOperation<T> bypassDocumentValidation(@Nullable Boolean bl) {
        this.bypassDocumentValidation = bl;
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> filter(@Nullable BsonDocument bsonDocument) {
        super.filter(bsonDocument);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> projection(@Nullable BsonDocument bsonDocument) {
        super.projection(bsonDocument);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> sort(@Nullable BsonDocument bsonDocument) {
        super.sort(bsonDocument);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> hint(@Nullable BsonDocument bsonDocument) {
        super.hint(bsonDocument);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> hintString(@Nullable String string) {
        super.hintString(string);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> collation(@Nullable Collation collation) {
        super.collation(collation);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> comment(@Nullable BsonValue bsonValue) {
        super.comment(bsonValue);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> let(@Nullable BsonDocument bsonDocument) {
        super.let(bsonDocument);
        return this;
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        return new MappedFieldNameValidator(NoOpFieldNameValidator.INSTANCE, Collections.singletonMap("update", ReplacingDocumentFieldNameValidator.INSTANCE));
    }

    @Override
    protected void specializeCommand(BsonDocument bsonDocument, ConnectionDescription connectionDescription) {
        bsonDocument.put("new", new BsonBoolean(!this.isReturnOriginal()));
        DocumentHelper.putIfTrue(bsonDocument, "upsert", this.isUpsert());
        bsonDocument.put("update", this.getReplacement());
        if (this.bypassDocumentValidation != null) {
            bsonDocument.put("bypassDocumentValidation", BsonBoolean.valueOf(this.bypassDocumentValidation));
        }
    }
}

