/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.operation.BaseFindAndModifyOperation;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.validator.MappedFieldNameValidator;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.internal.validator.UpdateFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

public class FindAndUpdateOperation<T>
extends BaseFindAndModifyOperation<T> {
    private final BsonDocument update;
    private final List<BsonDocument> updatePipeline;
    private boolean returnOriginal = true;
    private boolean upsert;
    private Boolean bypassDocumentValidation;
    private List<BsonDocument> arrayFilters;

    public FindAndUpdateOperation(MongoNamespace mongoNamespace, WriteConcern writeConcern, boolean bl, Decoder<T> decoder, BsonDocument bsonDocument) {
        super(mongoNamespace, writeConcern, bl, decoder);
        this.update = Assertions.notNull("update", bsonDocument);
        this.updatePipeline = null;
    }

    public FindAndUpdateOperation(MongoNamespace mongoNamespace, WriteConcern writeConcern, boolean bl, Decoder<T> decoder, List<BsonDocument> list) {
        super(mongoNamespace, writeConcern, bl, decoder);
        this.updatePipeline = list;
        this.update = null;
    }

    @Nullable
    public BsonDocument getUpdate() {
        return this.update;
    }

    @Nullable
    public List<BsonDocument> getUpdatePipeline() {
        return this.updatePipeline;
    }

    public boolean isReturnOriginal() {
        return this.returnOriginal;
    }

    public FindAndUpdateOperation<T> returnOriginal(boolean bl) {
        this.returnOriginal = bl;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public FindAndUpdateOperation<T> upsert(boolean bl) {
        this.upsert = bl;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public FindAndUpdateOperation<T> bypassDocumentValidation(@Nullable Boolean bl) {
        this.bypassDocumentValidation = bl;
        return this;
    }

    public FindAndUpdateOperation<T> arrayFilters(@Nullable List<BsonDocument> list) {
        this.arrayFilters = list;
        return this;
    }

    public List<BsonDocument> getArrayFilters() {
        return this.arrayFilters;
    }

    @Override
    public FindAndUpdateOperation<T> filter(@Nullable BsonDocument bsonDocument) {
        super.filter(bsonDocument);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> projection(@Nullable BsonDocument bsonDocument) {
        super.projection(bsonDocument);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> sort(@Nullable BsonDocument bsonDocument) {
        super.sort(bsonDocument);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> hint(@Nullable BsonDocument bsonDocument) {
        super.hint(bsonDocument);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> hintString(@Nullable String string) {
        super.hintString(string);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> collation(@Nullable Collation collation) {
        super.collation(collation);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> comment(@Nullable BsonValue bsonValue) {
        super.comment(bsonValue);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> let(@Nullable BsonDocument bsonDocument) {
        super.let(bsonDocument);
        return this;
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        return new MappedFieldNameValidator(NoOpFieldNameValidator.INSTANCE, Collections.singletonMap("update", new UpdateFieldNameValidator()));
    }

    @Override
    protected void specializeCommand(BsonDocument bsonDocument, ConnectionDescription connectionDescription) {
        bsonDocument.put("new", new BsonBoolean(!this.isReturnOriginal()));
        DocumentHelper.putIfTrue(bsonDocument, "upsert", this.isUpsert());
        if (this.getUpdatePipeline() != null) {
            bsonDocument.put("update", new BsonArray(this.getUpdatePipeline()));
        } else {
            DocumentHelper.putIfNotNull(bsonDocument, "update", this.getUpdate());
        }
        if (this.bypassDocumentValidation != null) {
            bsonDocument.put("bypassDocumentValidation", BsonBoolean.valueOf(this.bypassDocumentValidation));
        }
        if (this.arrayFilters != null) {
            bsonDocument.put("arrayFilters", new BsonArray(this.arrayFilters));
        }
    }
}

