/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.CursorType;
import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoQueryException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.AsyncCommandBatchCursor;
import com.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandBatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.ExplainHelper;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.OperationReadConcernHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.function.Supplier;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

public class FindOperation<T>
implements AsyncExplainableReadOperation<AsyncBatchCursor<T>>,
ExplainableReadOperation<BatchCursor<T>> {
    private static final String FIRST_BATCH = "firstBatch";
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private BsonDocument filter;
    private int batchSize;
    private int limit;
    private BsonDocument projection;
    private int skip;
    private BsonDocument sort;
    private CursorType cursorType = CursorType.NonTailable;
    private boolean noCursorTimeout;
    private boolean partial;
    private Collation collation;
    private BsonValue comment;
    private BsonValue hint;
    private BsonDocument variables;
    private BsonDocument max;
    private BsonDocument min;
    private boolean returnKey;
    private boolean showRecordId;
    private Boolean allowDiskUse;
    private TimeoutMode timeoutMode;

    public FindOperation(MongoNamespace mongoNamespace, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindOperation<T> filter(@Nullable BsonDocument bsonDocument) {
        this.filter = bsonDocument;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public FindOperation<T> batchSize(int n) {
        this.batchSize = n;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public FindOperation<T> limit(int n) {
        this.limit = n;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindOperation<T> projection(@Nullable BsonDocument bsonDocument) {
        this.projection = bsonDocument;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public FindOperation<T> skip(int n) {
        this.skip = n;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindOperation<T> sort(@Nullable BsonDocument bsonDocument) {
        this.sort = bsonDocument;
        return this;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public FindOperation<T> cursorType(CursorType cursorType) {
        this.cursorType = Assertions.notNull("cursorType", cursorType);
        return this;
    }

    public FindOperation<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        if (timeoutMode != null) {
            this.timeoutMode = timeoutMode;
        }
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public FindOperation<T> noCursorTimeout(boolean bl) {
        this.noCursorTimeout = bl;
        return this;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public FindOperation<T> partial(boolean bl) {
        this.partial = bl;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public FindOperation<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public FindOperation<T> comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public FindOperation<T> hint(@Nullable BsonValue bsonValue) {
        this.hint = bsonValue;
        return this;
    }

    public BsonDocument getLet() {
        return this.variables;
    }

    public FindOperation<T> let(@Nullable BsonDocument bsonDocument) {
        this.variables = bsonDocument;
        return this;
    }

    public BsonDocument getMax() {
        return this.max;
    }

    public FindOperation<T> max(@Nullable BsonDocument bsonDocument) {
        this.max = bsonDocument;
        return this;
    }

    public BsonDocument getMin() {
        return this.min;
    }

    public FindOperation<T> min(@Nullable BsonDocument bsonDocument) {
        this.min = bsonDocument;
        return this;
    }

    public boolean isReturnKey() {
        return this.returnKey;
    }

    public FindOperation<T> returnKey(boolean bl) {
        this.returnKey = bl;
        return this;
    }

    public boolean isShowRecordId() {
        return this.showRecordId;
    }

    public FindOperation<T> showRecordId(boolean bl) {
        this.showRecordId = bl;
        return this;
    }

    public FindOperation<T> retryReads(boolean bl) {
        this.retryReads = bl;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public Boolean isAllowDiskUse() {
        return this.allowDiskUse;
    }

    public FindOperation<T> allowDiskUse(@Nullable Boolean bl) {
        this.allowDiskUse = bl;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding readBinding) {
        IllegalStateException illegalStateException = this.invalidTimeoutModeException();
        if (illegalStateException != null) {
            throw illegalStateException;
        }
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, readBinding.getOperationContext().getTimeoutContext());
        Supplier<BatchCursor> supplier = SyncOperationHelper.decorateReadWithRetries(retryState, readBinding.getOperationContext(), () -> SyncOperationHelper.withSourceAndConnection(readBinding::getReadConnectionSource, false, (connectionSource, connection) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(connectionSource.getServerDescription(), readBinding.getOperationContext()));
            try {
                return SyncOperationHelper.createReadCommandAndExecute(retryState, readBinding.getOperationContext(), connectionSource, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, FIRST_BATCH), this.transformer(), connection);
            }
            catch (MongoCommandException mongoCommandException) {
                throw new MongoQueryException(mongoCommandException.getResponse(), mongoCommandException.getServerAddress());
            }
        }));
        return supplier.get();
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<AsyncBatchCursor<T>> singleResultCallback) {
        IllegalStateException illegalStateException = this.invalidTimeoutModeException();
        if (illegalStateException != null) {
            singleResultCallback.onResult(null, illegalStateException);
            return;
        }
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, asyncReadBinding.getOperationContext().getTimeoutContext());
        asyncReadBinding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncCallbackSupplier = AsyncOperationHelper.decorateReadWithRetriesAsync(retryState, asyncReadBinding.getOperationContext(), singleResultCallback2 -> AsyncOperationHelper.withAsyncSourceAndConnection(asyncReadBinding::getReadConnectionSource, false, singleResultCallback2, (asyncConnectionSource, asyncConnection, singleResultCallback) -> {
            if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(asyncConnectionSource.getServerDescription(), asyncReadBinding.getOperationContext()), singleResultCallback)) {
                return;
            }
            SingleResultCallback<T> singleResultCallback2 = FindOperation.exceptionTransformingCallback(singleResultCallback);
            AsyncOperationHelper.createReadCommandAndExecuteAsync(retryState, asyncReadBinding.getOperationContext(), asyncConnectionSource, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, FIRST_BATCH), this.asyncTransformer(), asyncConnection, singleResultCallback2);
        })).whenComplete(asyncReadBinding::release);
        asyncCallbackSupplier.get(ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER));
    }

    private static <T> SingleResultCallback<T> exceptionTransformingCallback(SingleResultCallback<T> singleResultCallback) {
        return (object, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof MongoCommandException) {
                    MongoCommandException mongoCommandException = (MongoCommandException)throwable;
                    singleResultCallback.onResult(object, new MongoQueryException(mongoCommandException.getResponse(), mongoCommandException.getServerAddress()));
                } else {
                    singleResultCallback.onResult(object, throwable);
                }
            } else {
                singleResultCallback.onResult(object, null);
            }
        };
    }

    @Override
    public <R> ReadOperation<R> asExplainableOperation(@Nullable ExplainVerbosity explainVerbosity, Decoder<R> decoder) {
        return this.createExplainableOperation(explainVerbosity, decoder);
    }

    @Override
    public <R> AsyncReadOperation<R> asAsyncExplainableOperation(@Nullable ExplainVerbosity explainVerbosity, Decoder<R> decoder) {
        return this.createExplainableOperation(explainVerbosity, decoder);
    }

    <R> CommandReadOperation<R> createExplainableOperation(@Nullable ExplainVerbosity explainVerbosity, Decoder<R> decoder) {
        return new CommandReadOperation<R>(this.getNamespace().getDatabaseName(), (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = this.getCommand(operationContext, 0);
            CommandHelper.applyMaxTimeMS(operationContext.getTimeoutContext(), bsonDocument);
            return ExplainHelper.asExplainCommand(bsonDocument, explainVerbosity);
        }, decoder);
    }

    private BsonDocument getCommand(OperationContext operationContext, int n) {
        BsonDocument bsonDocument = new BsonDocument("find", new BsonString(this.namespace.getCollectionName()));
        OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), n, bsonDocument);
        DocumentHelper.putIfNotNull(bsonDocument, "filter", this.filter);
        DocumentHelper.putIfNotNullOrEmpty(bsonDocument, "sort", this.sort);
        DocumentHelper.putIfNotNullOrEmpty(bsonDocument, "projection", this.projection);
        if (this.skip > 0) {
            bsonDocument.put("skip", new BsonInt32(this.skip));
        }
        if (this.limit != 0) {
            bsonDocument.put("limit", new BsonInt32(Math.abs(this.limit)));
        }
        if (this.limit >= 0) {
            if (this.batchSize < 0 && Math.abs(this.batchSize) < this.limit) {
                bsonDocument.put("limit", new BsonInt32(Math.abs(this.batchSize)));
            } else if (this.batchSize != 0) {
                bsonDocument.put("batchSize", new BsonInt32(Math.abs(this.batchSize)));
            }
        }
        if (this.limit < 0 || this.batchSize < 0) {
            bsonDocument.put("singleBatch", BsonBoolean.TRUE);
        }
        if (this.isTailableCursor()) {
            bsonDocument.put("tailable", BsonBoolean.TRUE);
            if (this.isAwaitData()) {
                bsonDocument.put("awaitData", BsonBoolean.TRUE);
            } else {
                operationContext.getTimeoutContext().disableMaxTimeOverride();
            }
        } else {
            OperationHelper.setNonTailableCursorMaxTimeSupplier(this.timeoutMode, operationContext);
        }
        if (this.noCursorTimeout) {
            bsonDocument.put("noCursorTimeout", BsonBoolean.TRUE);
        }
        if (this.partial) {
            bsonDocument.put("allowPartialResults", BsonBoolean.TRUE);
        }
        if (this.collation != null) {
            bsonDocument.put("collation", this.collation.asDocument());
        }
        if (this.comment != null) {
            bsonDocument.put("comment", this.comment);
        }
        if (this.hint != null) {
            bsonDocument.put("hint", this.hint);
        }
        if (this.variables != null) {
            bsonDocument.put("let", this.variables);
        }
        if (this.max != null) {
            bsonDocument.put("max", this.max);
        }
        if (this.min != null) {
            bsonDocument.put("min", this.min);
        }
        if (this.returnKey) {
            bsonDocument.put("returnKey", BsonBoolean.TRUE);
        }
        if (this.showRecordId) {
            bsonDocument.put("showRecordId", BsonBoolean.TRUE);
        }
        if (this.allowDiskUse != null) {
            bsonDocument.put("allowDiskUse", BsonBoolean.valueOf(this.allowDiskUse));
        }
        return bsonDocument;
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> this.getCommand(operationContext, connectionDescription.getMaxWireVersion());
    }

    private boolean isTailableCursor() {
        return this.cursorType.isTailable();
    }

    private boolean isAwaitData() {
        return this.cursorType == CursorType.TailableAwait;
    }

    private TimeoutMode getTimeoutMode() {
        if (this.timeoutMode == null) {
            return this.isTailableCursor() ? TimeoutMode.ITERATION : TimeoutMode.CURSOR_LIFETIME;
        }
        return this.timeoutMode;
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, CommandBatchCursor<T>> transformer() {
        return (bsonDocument, connectionSource, connection) -> new CommandBatchCursor<T>(this.getTimeoutMode(), (BsonDocument)bsonDocument, this.batchSize, this.getMaxTimeForCursor(connectionSource.getOperationContext()), this.decoder, this.comment, connectionSource, connection);
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (bsonDocument, asyncConnectionSource, asyncConnection) -> new AsyncCommandBatchCursor<T>(this.getTimeoutMode(), (BsonDocument)bsonDocument, this.batchSize, this.getMaxTimeForCursor(asyncConnectionSource.getOperationContext()), this.decoder, this.comment, asyncConnectionSource, asyncConnection);
    }

    private long getMaxTimeForCursor(OperationContext operationContext) {
        return this.cursorType == CursorType.TailableAwait ? operationContext.getTimeoutContext().getMaxAwaitTimeMS() : 0L;
    }

    @Nullable
    private IllegalStateException invalidTimeoutModeException() {
        if (this.isTailableCursor() && this.timeoutMode == TimeoutMode.CURSOR_LIFETIME) {
            return new IllegalStateException("Tailable cursors only support the ITERATION value for the timeoutMode option.");
        }
        return null;
    }
}

