/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.SearchIndexModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;

public final class IndexHelper {
    public static List<String> getIndexNames(List<IndexModel> list, CodecRegistry codecRegistry) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (IndexModel indexModel : list) {
            String string = indexModel.getOptions().getName();
            if (string != null) {
                arrayList.add(string);
                continue;
            }
            arrayList.add(IndexHelper.generateIndexName(indexModel.getKeys().toBsonDocument(BsonDocument.class, codecRegistry)));
        }
        return arrayList;
    }

    public static List<String> getSearchIndexNames(List<SearchIndexModel> list) {
        return list.stream().map(IndexHelper::getSearchIndexName).collect(Collectors.toList());
    }

    private static String getSearchIndexName(SearchIndexModel searchIndexModel) {
        String string = searchIndexModel.getName();
        return string != null ? string : "default";
    }

    public static String generateIndexName(BsonDocument bsonDocument) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : bsonDocument.keySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('_');
            }
            stringBuilder.append(string).append('_');
            BsonValue bsonValue = bsonDocument.get(string);
            if (bsonValue instanceof BsonNumber) {
                stringBuilder.append(((BsonNumber)bsonValue).intValue());
                continue;
            }
            if (!(bsonValue instanceof BsonString)) continue;
            stringBuilder.append(((BsonString)bsonValue).getValue().replace(' ', '_'));
        }
        return stringBuilder.toString();
    }

    private IndexHelper() {
    }
}

