/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncSingleBatchCursor;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.CursorHelper;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SingleBatchCursor;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;

public class ListCollectionsOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private final String databaseName;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private BsonDocument filter;
    private int batchSize;
    private boolean nameOnly;
    private boolean authorizedCollections;
    private BsonValue comment;
    private TimeoutMode timeoutMode = TimeoutMode.CURSOR_LIFETIME;

    public ListCollectionsOperation(String string, Decoder<T> decoder) {
        this.databaseName = Assertions.notNull("databaseName", string);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public boolean isNameOnly() {
        return this.nameOnly;
    }

    public ListCollectionsOperation<T> filter(@Nullable BsonDocument bsonDocument) {
        this.filter = bsonDocument;
        return this;
    }

    public ListCollectionsOperation<T> nameOnly(boolean bl) {
        this.nameOnly = bl;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public ListCollectionsOperation<T> batchSize(int n) {
        this.batchSize = n;
        return this;
    }

    public ListCollectionsOperation<T> retryReads(boolean bl) {
        this.retryReads = bl;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public ListCollectionsOperation<T> comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    public ListCollectionsOperation<T> authorizedCollections(boolean bl) {
        this.authorizedCollections = bl;
        return this;
    }

    public boolean isAuthorizedCollections() {
        return this.authorizedCollections;
    }

    public TimeoutMode getTimeoutMode() {
        return this.timeoutMode;
    }

    public ListCollectionsOperation<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        if (timeoutMode != null) {
            this.timeoutMode = timeoutMode;
        }
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding readBinding) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, readBinding.getOperationContext().getTimeoutContext());
        Supplier<BatchCursor> supplier = SyncOperationHelper.decorateReadWithRetries(retryState, readBinding.getOperationContext(), () -> SyncOperationHelper.withSourceAndConnection(readBinding::getReadConnectionSource, false, (connectionSource, connection) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(connectionSource.getServerDescription(), readBinding.getOperationContext()));
            try {
                return SyncOperationHelper.createReadCommandAndExecute(retryState, readBinding.getOperationContext(), connectionSource, this.databaseName, this.getCommandCreator(), this.createCommandDecoder(), this.transformer(), connection);
            }
            catch (MongoCommandException mongoCommandException) {
                return CommandOperationHelper.rethrowIfNotNamespaceError(mongoCommandException, SingleBatchCursor.createEmptySingleBatchCursor(connectionSource.getServerDescription().getAddress(), this.batchSize));
            }
        }));
        return supplier.get();
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<AsyncBatchCursor<T>> singleResultCallback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, asyncReadBinding.getOperationContext().getTimeoutContext());
        asyncReadBinding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncCallbackSupplier = AsyncOperationHelper.decorateReadWithRetriesAsync(retryState, asyncReadBinding.getOperationContext(), singleResultCallback2 -> AsyncOperationHelper.withAsyncSourceAndConnection(asyncReadBinding::getReadConnectionSource, false, singleResultCallback2, (asyncConnectionSource, asyncConnection, singleResultCallback) -> {
            if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(asyncConnectionSource.getServerDescription(), asyncReadBinding.getOperationContext()), singleResultCallback)) {
                return;
            }
            AsyncOperationHelper.createReadCommandAndExecuteAsync(retryState, asyncReadBinding.getOperationContext(), asyncConnectionSource, this.databaseName, this.getCommandCreator(), this.createCommandDecoder(), this.asyncTransformer(), asyncConnection, (asyncSingleBatchCursor, throwable) -> {
                if (throwable != null && !CommandOperationHelper.isNamespaceError(throwable)) {
                    singleResultCallback.onResult(null, throwable);
                } else {
                    singleResultCallback.onResult(asyncSingleBatchCursor != null ? asyncSingleBatchCursor : AsyncSingleBatchCursor.createEmptyAsyncSingleBatchCursor(this.getBatchSize()), null);
                }
            });
        })).whenComplete(asyncReadBinding::release);
        asyncCallbackSupplier.get(ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER));
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return (bsonDocument, connectionSource, connection) -> SyncOperationHelper.cursorDocumentToBatchCursor(this.timeoutMode, bsonDocument, this.batchSize, this.decoder, this.comment, connectionSource, connection);
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (bsonDocument, asyncConnectionSource, asyncConnection) -> AsyncOperationHelper.cursorDocumentToAsyncBatchCursor(this.timeoutMode, bsonDocument, this.batchSize, this.decoder, this.comment, asyncConnectionSource, asyncConnection);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = new BsonDocument("listCollections", new BsonInt32(1)).append("cursor", CursorHelper.getCursorDocumentFromBatchSize(this.batchSize == 0 ? null : Integer.valueOf(this.batchSize)));
            DocumentHelper.putIfNotNull(bsonDocument, "filter", this.filter);
            DocumentHelper.putIfTrue(bsonDocument, "nameOnly", this.nameOnly);
            DocumentHelper.putIfTrue(bsonDocument, "authorizedCollections", this.authorizedCollections);
            OperationHelper.setNonTailableCursorMaxTimeSupplier(this.timeoutMode, operationContext);
            DocumentHelper.putIfNotNull(bsonDocument, "comment", this.comment);
            return bsonDocument;
        };
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, "firstBatch");
    }
}

