/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncSingleBatchCursor;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.CursorHelper;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SingleBatchCursor;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;

public class ListIndexesOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private int batchSize;
    private BsonValue comment;
    private TimeoutMode timeoutMode = TimeoutMode.CURSOR_LIFETIME;

    public ListIndexesOperation(MongoNamespace mongoNamespace, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public ListIndexesOperation<T> batchSize(int n) {
        this.batchSize = n;
        return this;
    }

    public ListIndexesOperation<T> retryReads(boolean bl) {
        this.retryReads = bl;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public ListIndexesOperation<T> comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    public TimeoutMode getTimeoutMode() {
        return this.timeoutMode;
    }

    public ListIndexesOperation<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        if (timeoutMode != null) {
            this.timeoutMode = timeoutMode;
        }
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding readBinding) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, readBinding.getOperationContext().getTimeoutContext());
        Supplier<BatchCursor> supplier = SyncOperationHelper.decorateReadWithRetries(retryState, readBinding.getOperationContext(), () -> SyncOperationHelper.withSourceAndConnection(readBinding::getReadConnectionSource, false, (connectionSource, connection) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(connectionSource.getServerDescription(), readBinding.getOperationContext()));
            try {
                return SyncOperationHelper.createReadCommandAndExecute(retryState, readBinding.getOperationContext(), connectionSource, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), this.transformer(), connection);
            }
            catch (MongoCommandException mongoCommandException) {
                return CommandOperationHelper.rethrowIfNotNamespaceError(mongoCommandException, SingleBatchCursor.createEmptySingleBatchCursor(connectionSource.getServerDescription().getAddress(), this.batchSize));
            }
        }));
        return supplier.get();
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<AsyncBatchCursor<T>> singleResultCallback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads, asyncReadBinding.getOperationContext().getTimeoutContext());
        asyncReadBinding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncCallbackSupplier = AsyncOperationHelper.decorateReadWithRetriesAsync(retryState, asyncReadBinding.getOperationContext(), singleResultCallback2 -> AsyncOperationHelper.withAsyncSourceAndConnection(asyncReadBinding::getReadConnectionSource, false, singleResultCallback2, (asyncConnectionSource, asyncConnection, singleResultCallback) -> {
            if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(asyncConnectionSource.getServerDescription(), asyncReadBinding.getOperationContext()), singleResultCallback)) {
                return;
            }
            AsyncOperationHelper.createReadCommandAndExecuteAsync(retryState, asyncReadBinding.getOperationContext(), asyncConnectionSource, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), this.asyncTransformer(), asyncConnection, (asyncSingleBatchCursor, throwable) -> {
                if (throwable != null && !CommandOperationHelper.isNamespaceError(throwable)) {
                    singleResultCallback.onResult(null, throwable);
                } else {
                    singleResultCallback.onResult(asyncSingleBatchCursor != null ? asyncSingleBatchCursor : AsyncSingleBatchCursor.createEmptyAsyncSingleBatchCursor(this.getBatchSize()), null);
                }
            });
        })).whenComplete(asyncReadBinding::release);
        asyncCallbackSupplier.get(ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER));
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = new BsonDocument("listIndexes", new BsonString(this.namespace.getCollectionName())).append("cursor", CursorHelper.getCursorDocumentFromBatchSize(this.batchSize == 0 ? null : Integer.valueOf(this.batchSize)));
            OperationHelper.setNonTailableCursorMaxTimeSupplier(this.timeoutMode, operationContext);
            DocumentHelper.putIfNotNull(bsonDocument, "comment", this.comment);
            return bsonDocument;
        };
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return (bsonDocument, connectionSource, connection) -> SyncOperationHelper.cursorDocumentToBatchCursor(this.timeoutMode, bsonDocument, this.batchSize, this.decoder, this.comment, connectionSource, connection);
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (bsonDocument, asyncConnectionSource, asyncConnection) -> AsyncOperationHelper.cursorDocumentToAsyncBatchCursor(this.timeoutMode, bsonDocument, this.batchSize, this.decoder, this.comment, asyncConnectionSource, asyncConnection);
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, "firstBatch");
    }
}

