/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AggregateOperation;
import com.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncSingleBatchCursor;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SingleBatchCursor;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

public final class ListSearchIndexesOperation<T>
implements AsyncExplainableReadOperation<AsyncBatchCursor<T>>,
ExplainableReadOperation<BatchCursor<T>> {
    private static final String STAGE_LIST_SEARCH_INDEXES = "$listSearchIndexes";
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    @Nullable
    private final Boolean allowDiskUse;
    @Nullable
    private final Integer batchSize;
    @Nullable
    private final Collation collation;
    @Nullable
    private final BsonValue comment;
    @Nullable
    private final String indexName;
    private final boolean retryReads;

    public ListSearchIndexesOperation(MongoNamespace mongoNamespace, Decoder<T> decoder, @Nullable String string, @Nullable Integer n, @Nullable Collation collation, @Nullable BsonValue bsonValue, @Nullable Boolean bl, boolean bl2) {
        this.namespace = mongoNamespace;
        this.decoder = decoder;
        this.allowDiskUse = bl;
        this.batchSize = n;
        this.collation = collation;
        this.comment = bsonValue;
        this.indexName = string;
        this.retryReads = bl2;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding readBinding) {
        try {
            return this.asAggregateOperation().execute(readBinding);
        }
        catch (MongoCommandException mongoCommandException) {
            int n;
            int n2 = n = this.batchSize == null ? 0 : this.batchSize;
            if (!CommandOperationHelper.isNamespaceError(mongoCommandException)) {
                throw mongoCommandException;
            }
            return SingleBatchCursor.createEmptySingleBatchCursor(mongoCommandException.getServerAddress(), n);
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<AsyncBatchCursor<T>> singleResultCallback) {
        this.asAggregateOperation().executeAsync(asyncReadBinding, (AsyncBatchCursor<T> asyncBatchCursor, Throwable throwable) -> {
            if (throwable != null && !CommandOperationHelper.isNamespaceError(throwable)) {
                singleResultCallback.onResult(null, throwable);
            } else if (throwable != null) {
                singleResultCallback.onResult(AsyncSingleBatchCursor.createEmptyAsyncSingleBatchCursor(this.batchSize == null ? 0 : this.batchSize), null);
            } else {
                singleResultCallback.onResult((AsyncBatchCursor<T>)asyncBatchCursor, null);
            }
        });
    }

    @Override
    public <R> ReadOperation<R> asExplainableOperation(@Nullable ExplainVerbosity explainVerbosity, Decoder<R> decoder) {
        return this.asAggregateOperation().asExplainableOperation(explainVerbosity, decoder);
    }

    @Override
    public <R> AsyncReadOperation<R> asAsyncExplainableOperation(@Nullable ExplainVerbosity explainVerbosity, Decoder<R> decoder) {
        return this.asAggregateOperation().asAsyncExplainableOperation(explainVerbosity, decoder);
    }

    private AggregateOperation<T> asAggregateOperation() {
        BsonDocument bsonDocument = this.getSearchDefinition();
        BsonDocument bsonDocument2 = new BsonDocument(STAGE_LIST_SEARCH_INDEXES, bsonDocument);
        return new AggregateOperation<T>(this.namespace, Collections.singletonList(bsonDocument2), this.decoder).retryReads(this.retryReads).collation(this.collation).comment(this.comment).allowDiskUse(this.allowDiskUse).batchSize(this.batchSize);
    }

    @NonNull
    private BsonDocument getSearchDefinition() {
        if (this.indexName == null) {
            return new BsonDocument();
        }
        return new BsonDocument("name", new BsonString(this.indexName));
    }
}

