/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.internal.operation.MapReduceStatistics;
import org.bson.BsonDocument;
import org.bson.BsonInt32;

final class MapReduceHelper {
    static MapReduceStatistics createStatistics(BsonDocument bsonDocument) {
        return new MapReduceStatistics(MapReduceHelper.getInputCount(bsonDocument), MapReduceHelper.getOutputCount(bsonDocument), MapReduceHelper.getEmitCount(bsonDocument), MapReduceHelper.getDuration(bsonDocument));
    }

    private static int getInputCount(BsonDocument bsonDocument) {
        return bsonDocument.getDocument("counts", new BsonDocument()).getNumber("input", new BsonInt32(0)).intValue();
    }

    private static int getOutputCount(BsonDocument bsonDocument) {
        return bsonDocument.getDocument("counts", new BsonDocument()).getNumber("output", new BsonInt32(0)).intValue();
    }

    private static int getEmitCount(BsonDocument bsonDocument) {
        return bsonDocument.getDocument("counts", new BsonDocument()).getNumber("emit", new BsonInt32(0)).intValue();
    }

    private static int getDuration(BsonDocument bsonDocument) {
        return bsonDocument.getNumber("timeMillis", new BsonInt32(0)).intValue();
    }

    private MapReduceHelper() {
    }
}

